package eu.javaexperience.nativ.java.socket;

import java.io.IOException;
import java.io.InputStream;

import eu.javaexperience.nativ.java.JavaNativeExtension;

public class NativeLinuxInputStream extends InputStream
{
	public NativeLinuxInputStream(FileDescriptorHolder fdh)
	{
		this.fdh = fdh;
	}
	
	protected FileDescriptorHolder fdh;
	
	/*protected static final int readBufferMaxSize = 8096;
	
	//acclocationg a buffer is expensive
	protected long readBuffer = Posix.malloc(readBufferMaxSize);
	
	@Override
	protected void finalize() throws Throwable
	{
		Posix.free(readBuffer);
		super.finalize();
	}
	*/
	
	@Override
	public int read() throws IOException
	{
		byte[] rb = new byte[1];
		int ret = read(rb);
		if(ret < 1)
		{
			return -1;
		}
	
		return rb[0];
	}
	
	@Override
	public int read(byte[] b, int off, int len) throws IOException
	{
		//return JavaNativeExtension.checkedBufferedRead(fdh.getFd(), readBuffer, readBufferMaxSize, b, off, len);
		//return JavaNativeExtension.checkedRead(fdh.getFd(), b, off, len);
		return JavaNativeExtension.checkedExperimentalRead(fdh.getFd(), b, off, len);
	}
}
