package eu.javaexperience.nativ.posix;

//TODO comment
public class PosixErrnoException extends Exception
{
	private static final long serialVersionUID = 1L;

	private final ERRNO err;
	
	public PosixErrnoException(ERRNO err)
	{
		if(err == null)
			throw new IllegalArgumentException("Error can not be null");
		
		this.err = err;
	}

	public String toString()
	{
		return err.toString();
	}
	
	public ERRNO getErrno()
	{
		return err;
	}
	
	public static void throwIfErrorOcurred() throws PosixErrnoException
	{
		int errno = Posix.errno();
		if(errno>0)
			throw new PosixErrnoException(ERRNO.ERRNOOfValue(errno));
	}
	
	public static PosixErrnoException getIfOcurred()
	{
		int errno = Posix.errno();
		if(errno > 0)
			return new PosixErrnoException(ERRNO.ERRNOOfValue(errno));
		
		return null;
	}

	public static void throwRtIfErrorOcurred()
	{
		PosixErrnoException ret = getIfOcurred();
		if(null != ret)
		{
			throw new RuntimeException(ret);
		}
	}
}