package eu.javaexperience.nativ.utils;

import eu.javaexperience.nativ.posix.Posix;

/**
 * 
 * */
public class CString implements CharSequence
{
	private final long addr;
	private final int maxlen;
	private int len = -1;
	
	public CString(String str)
	{
		addr = Posix.jstrcpy(str);
		maxlen = Posix.strlen(addr);
	}
	
	public CString(int len)
	{
		addr = Posix.malloc(len);
		Posix.setByteAt(addr, (byte)0);
		maxlen = len;
	}

	public CString(String str,int maxlen)
	{
		this.addr = Posix.jstrcpy(str);
		int len = Posix.strlen(this.addr);
		this.maxlen = maxlen>len? maxlen:len;
	}
	
	public CString(long addr,int maxlen)
	{
		this.addr = addr;
		this.maxlen = maxlen;
	}
	
	public void setCharAt(int i,char c)
	{
		Posix.setByteAt(addr+i, (byte)c);
	}
	
	public static CString strClone(long addr,int len)
	{
		long p = Posix.malloc(len+1);
		Posix.cpyrange(p, addr,len);
		return new CString(p,len);
	}
	
	@Override
	public char charAt(int arg0)
	{
		return (char) (Posix.byteAt(addr)+arg0);
	}
	
	public int getMaximalLength()
	{
		return maxlen;
	}

	public int setLength(int leng)
	{
		return len = leng > maxlen?maxlen:leng;
	}
	
	@Override
	public int length()
	{
		if(len < 0)
			return Posix.strlen(addr);
		return len;
	}

	@Override
	public CharSequence subSequence(int arg0, int arg1)
	{
		//TODO Teszt args?
		CString ret = new CString(this.addr+arg0, arg1-arg0);
		ret.setLength(arg1-arg0);
		return ret;
	}
	
	public void free()
	{
		Posix.free(addr);
	}
	
	public String toString()
	{
		return Posix.getCstrUTF(addr); 
	}
	
	public static void main(String[] args)
	{
		CString cs = new CString("Helló Világ");
		System.out.println(cs);
	}
}