/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.commands;

import eu.javaexperience.arrays.ArrayTools;
import java.io.File;
import java.io.IOException;

public class LinuxCommandTools {
    protected static boolean execZero(String ... params) throws InterruptedException, IOException {
        return 0 == new ProcessBuilder(params).start().waitFor();
    }

    public static boolean chown(String file, String user, String group) throws InterruptedException, IOException {
        return LinuxCommandTools.execZero("chown", user + ":" + group, file.toString());
    }

    public static boolean chown(String file, String user) throws InterruptedException, IOException {
        return LinuxCommandTools.execZero("chown", user, file.toString());
    }

    public static boolean chmod(String file, int mode) throws InterruptedException, IOException {
        return LinuxCommandTools.execZero("chmod", String.valueOf(mode), file.toString());
    }

    public static boolean chmod(File file, int mode) throws InterruptedException, IOException {
        return LinuxCommandTools.chmod(file.toString(), mode);
    }

    public static boolean tarCompressDirectory(String destinationTarFile, String ... directories) throws InterruptedException, IOException {
        return LinuxCommandTools.execZero((String[])ArrayTools.arrayConcat((Object[])new String[]{"tar", "cf", destinationTarFile}, (Object[])directories));
    }

    public static boolean tarCompressDirectory(File destinationTarFile, String ... directories) throws InterruptedException, IOException {
        return LinuxCommandTools.execZero((String[])ArrayTools.arrayConcat((Object[])new String[]{"tar", "cf", destinationTarFile.toString()}, (Object[])directories));
    }
}

