/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.nativ.posix;

import eu.javaexperience.nativ.posix.ERRNO;
import eu.javaexperience.nativ.posix.Posix;

public class PosixErrnoException
extends Exception {
    private static final long serialVersionUID = 1L;
    private final ERRNO err;

    public PosixErrnoException(ERRNO err) {
        if (err == null) {
            throw new IllegalArgumentException("Error can not be null");
        }
        this.err = err;
    }

    @Override
    public String toString() {
        return this.err.toString();
    }

    public ERRNO getErrno() {
        return this.err;
    }

    public static void throwIfErrorOcurred() throws PosixErrnoException {
        int errno = Posix.errno();
        if (errno > 0) {
            throw new PosixErrnoException(ERRNO.ERRNOOfValue(errno));
        }
    }

    public static PosixErrnoException getIfOcurred() {
        int errno = Posix.errno();
        if (errno > 0) {
            return new PosixErrnoException(ERRNO.ERRNOOfValue(errno));
        }
        return null;
    }

    public static void throwRtIfErrorOcurred() {
        PosixErrnoException ret = PosixErrnoException.getIfOcurred();
        if (null != ret) {
            throw new RuntimeException(ret);
        }
    }
}

