package eu.javaexperience.nativ.java.socket;

import java.io.IOException;
import java.io.OutputStream;

import eu.javaexperience.nativ.java.JavaNativeExtension;
import eu.javaexperience.nativ.posix.Posix;
import eu.javaexperience.nativ.posix.PosixErrnoException;

public class NativeLinuxOutputStream extends OutputStream
{
	public NativeLinuxOutputStream(FileDescriptorHolder fdh)
	{
		this.fdh = fdh;
	}
	
	protected FileDescriptorHolder fdh;
	
	/*protected static final int writeBufferMaxSize = 8096; 
	protected long writeBuffer = Posix.malloc(writeBufferMaxSize);
	
	@Override
	protected void finalize() throws Throwable
	{
		Posix.free(writeBuffer);
		super.finalize();
	}*/
	
	@Override
	public void write(int i) throws IOException
	{
		byte[] rb = new byte[]{(byte)i};
		write(rb);
	}
	
	@Override
	public void write(byte[] b, int off, int len) throws IOException
	{
		int rem = len;
		while(rem > 0)
		{
			int diff = 
					//JavaNativeExtension.checkedBufferedWrite(fdh.getFd(), writeBuffer, writeBufferMaxSize, b, off+(len-rem), rem);
					//JavaNativeExtension.checkedWrite(fdh.getFd(), b, off+(len-rem), rem);
					JavaNativeExtension.checkedExperimentalWrite(fdh.getFd(), b, off+(len-rem), rem);
			if(diff < 0)
			{
				throw new RuntimeException(PosixErrnoException.getIfOcurred());
			}
			rem -= diff;
		}
	}
	
	@Override
	public void flush() throws IOException
	{
		Posix.fsync(fdh.getFd());
	}
}
