package eu.javaexperience.nativ.posix;

import java.io.FileDescriptor;

import eu.javaexperience.gnu.GccTools;


/**
 * TODO 
 * <div class="en">
 * This is my favorite class, mostly contains native methods and constants which also used in linux C prgramming.
 * The name of the class? Could be named POSIX or Linux, but the most methods can be found in all UNIX platforms.
 * Loading of the class is a little bit tricky:
 * 	- first try to load the JUnix.arch.so (where arch is the current architecture)
 * 	- if can't load then try to access the so in the class package folder relatively to the current working directory,
 * 	- if can't load again then try to access the so in classpaths invluding all *.jar files,
 * 	- if can't load again then copy the JUnix.cpp nad the headers file into the current working directory and try to compile, this process is needs build-essential package installed.
 * If so founded (or compiled) is copied into the current woring directory, so next load will be success in the first "try to load"
 * This load method is designed to access files through the {@link ClassLoader}, so you can also load the .so file if its remote.  
 * </div> 
 * */
public final class Posix
{
	/*
	 * http://stackoverflow.com/questions/17352915/how-to-compile-a-program-using-llvm-for-different-target-architecture
	 * System.getProperty("arch.os");
	 * http://lopica.sourceforge.net/os.html
	 * 
	 * */
	static
	{
		//TODO
		boolean loaded = GccTools.loadArchDependSharedJavaLibraryOrCompileAndLoad
		(
			"eu/javaexperience/nativ/posix",
			"Posix",
			new String[]{"util", "dl"},
			null,
			new String[]{"-fpermissive"/*, "-Ofast"*/},
			System.out,
			System.err
		);
		
		if(!loaded)
			throw new UnsatisfiedLinkError("Posix shared library not found!");
			
		try
		{
			Class<?> c = null;
			c = STRING.class;
			ClassLoader.getSystemClassLoader().loadClass(c.getCanonicalName());
			c = INTEGER.class;
			ClassLoader.getSystemClassLoader().loadClass(c.getCanonicalName());
			c = VOID.class;
			ClassLoader.getSystemClassLoader().loadClass(c.getCanonicalName());
			//A nativ metódus már lássa ezeket az osztályokat,ezért hivatkozom rá.
		}
		catch(Throwable t)
		{
			throw new RuntimeException(t);
		}
		
		initNative();
	}
	
	private static final native void initNative();
	
	/** Hangup (POSIX).  */
	public static final int SIGHUP =    1;
	
	/** Interrupt (ANSI).  */
	public static final int SIGINT =    2;
	
	/** Quit (POSIX).  */
	public static final int SIGQUIT =   3;
	
	/** Illegal instruction (ANSI).  */
	public static final int SIGILL =    4;
	
	/** Trace trap (POSIX).  */
	public static final int SIGTRAP =   5;
	
	/** Abort (ANSI).  */
	public static final int SIGABRT =   6;
	
	/** IOT trap (4.2 BSD).  */
	public static final int SIGIOT =    6;
	
	/** BUS error (4.2 BSD).  */
	public static final int SIGBUS =    7;
	
	/** Floating-point exception (ANSI).  */
	public static final int SIGFPE =    8;
	
	/** Kill, unblockable (POSIX).  */
	public static final int SIGKILL =   9;
	
	/** User-defined signal 1 (POSIX).  */
	public static final int SIGUSR1 =   10;
	
	/** Segmentation violation (ANSI).  */
	public static final int SIGSEGV =   11;
	
	/** User-defined signal 2 (POSIX).  */
	public static final int SIGUSR2 =   12;
	
	/** Broken pipe (POSIX).  */
	public static final int SIGPIPE =   13;
	
	/** Alarm clock (POSIX).  */
	public static final int SIGALRM =   14;
	
	/** Termination (ANSI).  */
	public static final int SIGTERM =   15;
	
	/** Stack fault.  */
	public static final int SIGSTKFLT = 16;
	
	/** Same as SIGCHLD (System V).  */
	public static final int SIGCLD =    17;
	
	/** Child status has changed (POSIX).  */
	public static final int SIGCHLD =   17;
	
	/** Continue (POSIX).  */
	public static final int SIGCONT =   18;
	
	/** Stop, unblockable (POSIX).  */
	public static final int SIGSTOP =   19;
	
	/** Keyboard stop (POSIX).  */
	public static final int SIGTSTP =   20;
	
	/** Background read from tty (POSIX).  */
	public static final int SIGTTIN =   21;
	
	/** Background write to tty (POSIX).  */
	public static final int SIGTTOU =   22;
	
	/** Urgent condition on socket (4.2 BSD).  */
	public static final int SIGURG =    23;
	
	/** CPU limit exceeded (4.2 BSD).  */
	public static final int SIGXCPU =   24;
	
	/** File size limit exceeded (4.2 BSD).  */
	public static final int SIGXFSZ =   25;
	
	/** Virtual alarm clock (4.2 BSD).  */
	public static final int SIGVTALRM = 26;
	
	/** Profiling alarm clock (4.2 BSD).  */
	public static final int SIGPROF =   27;
	
	/** Window size change (4.3 BSD, Sun).  */
	public static final int SIGWINCH =  28;
	
	/** Pollable event occurred (System V).  */
	public static final int SIGPOLL =   29;
	
	/** I/O now possible (4.2 BSD).  */
	public static final int SIGIO =     29;
	
	/** Power failure restart (System V).  */
	public static final int SIGPWR =    30;
	
	/** Bad system call.  */
	public static final int SIGSYS =    31;

	
	/**
	 * The canonicalize_file_name() function returns a null-terminated string containing the canonicalized absolute pathname corresponding to path. In the returned string, symbolic links are resolved, as are . and .. pathname components. Consecutive slash (/) characters are replaced by a single slash.
	 * */
	public static final native String canonicalFilename(String path);

	/**
	 * The pause() function shall suspend the calling thread until delivery of a signal whose action is either to execute a signal-catching function or to terminate the process. 
	 * */
	public static final native void pause();

	/**
	 * The kill() function shall send a signal to a process or a group of processes specified by pid. The signal to be sent is specified by sig and is either one from the list given in <signal.h> or 0. If sig is 0 (the null signal), error checking is performed but no signal is actually sent. The null signal can be used to check the validity of pid. 
	 * */
	public static final native int kill(int pid, int signal);

	
	/**
	 * The forkpty() function combines openpty(), fork(2), and login_tty() to create a new process operating in a pseudoterminal. The file descriptor of the master side of the pseudoterminal is returned in amaster, and the filename of the slave in name if it is not NULL. The termp and winp arguments, if not NULL, will determine the terminal attributes and window size of the slave side of the pseudoterminal. 
	 * */
	public static final native int forkpty(INTEGER fd, STRING path,long termios,long winp);

	/**
	 * The openpty() function finds an available pseudoterminal and returns file descriptors for the master and slave in amaster and aslave. If name is not NULL, the filename of the slave is returned in name. If termp is not NULL, the terminal parameters of the slave will be set to the values in termp. If winp is not NULL, the window size of the slave will be set to the values in winp.  
	 * */
	public static final native int openpty(INTEGER FDmaster,INTEGER FDslave, STRING path,long termios,long winp);

	/**
	 * The login_tty() function prepares for a login on the terminal fd (which may be a real terminal device, or the slave of a pseudoterminal as returned by openpty()) by creating a new session, making fd the controlling terminal for the calling process, setting fd to be the standard input, output, and error streams of the current process, and closing fd. 
	 * */
	public static final native int loginTTY(int fd);

	/**
	 * The wait() and waitpid() functions shall obtain status information pertaining to one of the caller's child processes. Various options permit status information to be obtained for child processes that have terminated or stopped. If status information is available for two or more child processes, the order in which their status is reported is unspecified.
	 * */
	public static final native int waitpid(int pid,INTEGER retval);

	/**
	 * The exec() family of functions replaces the current process image with a new process image. The functions described in this manual page are front-ends for execve(2). (See the manual page for execve(2) for further details about the replacement of the current process image.) 
	 * The execv(), execvp(), and execvpe() functions provide an array of pointers to null-terminated strings that represent the argument list available to the new program. The first argument, by convention, should point to the filename associated with the file being executed. The array of pointers must be terminated by a NULL pointer. 
	 * */
	public static final native int execv(String path, String... args);

	/**
	 * The fork() function shall create a new process. The new process (child process) shall be an exact copy of the calling process (parent process) except as detailed below: 
	 * http://linux.die.net/man/3/fork
	 * */
	public static final native int fork();

	/**
	 * The close() function shall deallocate the file descriptor indicated by fildes. To deallocate means to make the file descriptor available for return by subsequent calls to open() or other functions that allocate file descriptors. All outstanding record locks owned by the process on the file associated with the file descriptor shall be removed (that is, unlocked). 
	 * */
	public static final native int close(int fd);

	/**
	 * The socketpair() function shall create an unbound pair of connected sockets in a specified domain, of a specified type, under the protocol optionally specified by the protocol argument. The two sockets shall be identical. The file descriptors used in referencing the created sockets shall be returned in socket_vector[0] and socket_vector[1]. 
	 * */
	public static final native int socketpair(INTEGER fd1,INTEGER fd2);

	/**
	 * dup, dup2 - duplicate an open file descriptor 
	 * */
	public static final native void dup(INTEGER fd,INTEGER to);

	/**
	 * dup, dup2 - duplicate an open file descriptor 
	 * */
	public static final native int dup2(INTEGER fd,INTEGER to);

	/**
	 * The chdir() function shall cause the directory named by the pathname pointed to by the path argument to become the current working directory; that is, the starting point for path searches for pathnames not beginning with '/' . 
	 * */
	public static final native int chdir(String path);

	//TODO
	public static final native int select(FileDescriptor[] fds,long timeout_s,long timeout_us);

	/** There is data to read */
	public static final short POLLIN = 0x0001;    
	
	/** There is urgent data to read */
	public static final short POLLPRI = 0x0002;
    /** Writing now will not block */
	public static final short POLLOUT = 0x0004;
	
	/** Error condition */
	public static final short POLLERR = 0x0008;    
	
	/** Hung up */
	public static final short POLLHUP = 0x0010;
	
	/** Invalid request: fd not open */
	public static final short POLLNVAL = 0x0020;    

	//TODO
	public static final native int poll(long[] pollfds,int timeout_ms);

	//TODO
	public static final native long pollfd(FileDescriptor fd,short events);

	//TODO
	public static final native int pollfdfd(long pfd_struct);

	//TODO
	public static final native short pollfdevents(long pfd_struct);

	//TODO
	public static final native short pollfdrevents(long pfd_struct);

	public static final native void free(long pointer);
	
	
	
	/* Socket types. */
	public static final int SOCK_STREAM	= 1;		/* stream (connection) socket	*/
	public static final int SOCK_DGRAM	= 2;		/* datagram (conn.less) socket	*/
	public static final int SOCK_RAW	= 3;		/* raw socket			*/
	public static final int SOCK_RDM	= 4;		/* reliably-delivered message	*/
	public static final int SOCK_SEQPACKET	= 5;		/* sequential packet socket	*/
	public static final int SOCK_PACKET	= 10;		/* linux specific way of	*/
						/* getting packets at the dev	*/
						/* level.  For writing rarp and	*/
						/* other similar things on the	*/
						/* user level.			*/
	
	/* Supported address families. */
	public static final int AF_UNSPEC	= 0;
	public static final int AF_UNIX		= 1;	/* Unix domain sockets 		*/
	public static final int AF_INET		= 2;	/* Internet IP Protocol 	*/
	public static final int AF_AX25		= 3;	/* Amateur Radio AX.25 		*/
	public static final int AF_IPX		= 4;	/* Novell IPX 			*/
	public static final int AF_APPLETALK	= 5;	/* Appletalk DDP 		*/
	public static final int AF_NETROM	= 6;	/* Amateur radio NetROM 	*/
	public static final int AF_BRIDGE	= 7;	/* Multiprotocol bridge 	*/
	public static final int AF_AAL5		= 8;	/* Reserved for Werner's ATM 	*/
	public static final int AF_X25		= 9;	/* Reserved for X.25 project 	*/
	public static final int AF_INET6	= 10;	/* IP version 6			*/
	public static final int AF_MAX		= 12;	/* For now.. */
	
	/* Protocol families, same as address families. */
	public static final int PF_UNSPEC	= AF_UNSPEC;
	public static final int PF_UNIX		= AF_UNIX;
	public static final int PF_INET		= AF_INET;
	public static final int PF_AX25		= AF_AX25;
	public static final int PF_IPX		=	AF_IPX;
	public static final int PF_APPLETALK=	AF_APPLETALK;
	public static final int PF_NETROM	= AF_NETROM;
	public static final int PF_BRIDGE	= AF_BRIDGE;
	public static final int PF_AAL5		= AF_AAL5;
	public static final int PF_X25		= AF_X25;
	public static final int PF_INET6	= AF_INET6;
	
	public static final int PF_MAX		= AF_MAX;
	
	/* Maximum queue length specifiable by listen.  */
	public static final int SOMAXCONN = 128;
	
	/* Flags we can use with send/ and recv. */
	public static final int MSG_OOB	= 1;
	/*public static final int MSG_CTRUNC	8	- We need to support this for BSD oddments */
	
	/* Setsockoptions(2) level. Thanks to BSD these must match IPPROTO_xxx */
	public static final int SOL_IP		=0;
	public static final int SOL_IPX		=256;
	public static final int SOL_AX25	=257;
	public static final int SOL_ATALK	=258;
	public static final int SOL_NETROM	=259;
	public static final int SOL_TCP		=6;
	public static final int SOL_UDP		=17;
	
	/* IP options */
	public static final int IP_TOS		=1;
	public static final int IPTOS_LOWDELAY		=0x10;
	public static final int IPTOS_THROUGHPUT	=0x08;
	public static final int IPTOS_RELIABILITY	=0x04;
	public static final int IP_TTL		=2;
	public static final int IP_HDRINCL	=3;
	public static final int IP_OPTIONS	=4;
	
	public static final int  IP_TRANSPARENT	= 19;
	
	public static final int IP_MULTICAST_IF			=32;
	public static final int IP_MULTICAST_TTL 		=33;
	public static final int IP_MULTICAST_LOOP 		=34;
	public static final int IP_ADD_MEMBERSHIP		=35;
	public static final int IP_DROP_MEMBERSHIP		=36;
	
	/* These need to appear somewhere around here */
	public static final int IP_DEFAULT_MULTICAST_TTL        =1;
	public static final int IP_DEFAULT_MULTICAST_LOOP       =1;
	public static final int IP_MAX_MEMBERSHIPS              =20;
	 
	/* IPX options */
	public static final int IPX_TYPE	=1;
	
	/* TCP options - this way around because someone left a set in the c library includes */
	public static final int TCP_NODELAY	=1;
	public static final int TCP_MAXSEG	=2;
	
	/* The various priorities. */
	public static final int SOPRI_INTERACTIVE =	0;
	public static final int SOPRI_NORMAL		=1;
	public static final int SOPRI_BACKGROUND	=2;
	
	
	/*
	 * Option flags per-socket.
	 */
	public static final int SO_DEBUG	= 0x0001;		/* turn on debugging info recording */
	public static final int SO_ACCEPTCONN	= 0x0002;		/* socket has had listen() */
	public static final int SO_REUSEADDR	= 0x0004;		/* allow local address reuse */
	public static final int SO_REUSEPORT 	= 0x0200;
	public static final int SO_KEEPALIVE	= 0x0008;		/* keep connections alive */
	public static final int SO_DONTROUTE	= 0x0010;		/* just use interface addresses */
	public static final int SO_BROADCAST	= 0x0020;		/* permit sending of broadcast msgs */
	public static final int SO_USELOOPBACK	= 0x0040;		/* bypass hardware when possible */
	public static final int SO_LINGER	= 0x0080;		/* linger on close if data present */
	public static final int SO_OOBINLINE	= 0x0100;		/* leave received OOB data in line */
	
	/*
	 * Additional options, not kept in so_options.
	 */
	public static final int SO_SNDBUF	= 0x1001;		/* send buffer size */
	public static final int SO_RCVBUF	= 0x1002;		/* receive buffer size */
	public static final int SO_SNDLOWAT	= 0x1003;		/* send low-water mark */
	public static final int SO_RCVLOWAT	= 0x1004;		/* receive low-water mark */
	public static final int SO_SNDTIMEO	= 0x1005;		/* send timeout */
	public static final int SO_RCVTIMEO	= 0x1006;		/* receive timeout */
	public static final int SO_ERROR	= 0x1007;		/* get error status and clear */
	public static final int SO_TYPE		= 0x1008;		/* get socket type */

	
	public static final native int socket(int family,int type,int options);
	
	public static final native int bind(int fd, long structAddr, int structlen);
	
	public static final native int connect(int fd, long structAddr, int structlen);
	
	public static final native int listen(int fd, int backlog);
	
	public static final native int accept(int fd, long sockAddr, long sockAddrLen);
	
	public static final native int accept4(int fd, long sockAddr, long sockAddrLen, int flags);
	
	public static final int SHUT_RD = 0;		/* No more receptions.  */
	public static final int SHUT_WR = 1;		/* No more transmissions.  */
	public static final int SHUT_RDWR = 2;		/* No more receptions or transmissions.  */
	
	public static final native int shutdown(int fd, int how);
	
	public static final native int setsockopt(int socket, int level, int option_name,long option_value, int option_len);

	public static final native int fsync(int fd);

	public static final native int fdatasync(int fd); 

	public static final native int getpeername(int fd, long sockAddr, long sockLen);
	

	/** Page can be read.  */
	public static final int PROT_READ = 0x1      ;      
	
	/** Page can be written.  */
	public static final int PROT_WRITE = 0x2     ;        
	
	/** Page can be executed.  */
	public static final int PROT_EXEC  =     0x4 ;            
	
	/** Page can not be accessed.  */
	public static final int PROT_NONE   =    0x0 ;            
	
	/** Extend change to start of growsdown vma (mprotect only).  */
	public static final int PROT_GROWSDOWN = 0x01000000 ;     
	
	/** Extend change to start of growsup vma (mprotect only).  */
	public static final int PROT_GROWSUP   = 0x02000000;      

	/** Share changes.  */
	public static final int MAP_SHARED     = 0x01 ;           
	
	/** Changes are private.  */
	public static final int MAP_PRIVATE    = 0x02;           
	
	/** Mask for type of mapping.  */
	public static final int MAP_TYPE      = 0x0f;            

	/** Interpret addr exactly.  */
	public static final int MAP_FIXED      = 0x10;            

	
	public static final int MAP_FILE       =0;
	
	/** Don't use a file.  */
	public static final int MAP_ANONYMOUS = 0x20;            
	public static final int MAP_ANON      = MAP_ANONYMOUS;
	
	/** Only give out 32-bit addresses.  */
	public static final int MAP_32BIT     = 0x40;       

	/** Stack-like segment.  */	
	public static final int MAP_GROWSDOWN  = 0x00100;         
	
	/** ETXTBSY */
	public static final int MAP_DENYWRITE  = 0x00800;         
	
	/** Mark it as an executable.  */
	public static final int MAP_EXECUTABLE = 0x01000;         
	
	/** Lock the mapping.  */
	public static final int MAP_LOCKED     = 0x02000;         
	
	/** Don't check for reservations.  */
	public static final int MAP_NORESERVE  = 0x04000;
	
	/** Populate (prefault) pagetables.  */
	public static final int MAP_POPULATE   = 0x08000;         
	
	/** Do not block on IO.  */
	public static final int MAP_NONBLOCK   = 0x10000;
	
	/** Allocation is for a stack.  */
	public static final int MAP_STACK      = 0x20000;         
	
	/** Create huge page mapping.  */
	public static final int MAP_HUGETLB    = 0x40000;         

	/**
	 * The mmap() function shall establish a mapping between a process' address space and a file, shared memory object, or typed memory object.
	 * */
	public static final native long mmap(long start_pointer,long length,int prot,int flags,int fd, long offset);

	/**
	 * The munmap() function shall remove any mappings for those entire pages containing any part of the address space of the process starting at addr and continuing for len bytes. Further references to these pages shall result in the generation of a SIGSEGV signal to the process. If there are no mappings in the specified address range, then munmap() has no effect. 
	 * */
	public static final native int munmap(long start_pointer,long length);

	
	/** Sync memory asynchronously.  */
	public static final int MS_ASYNC =       1; 			
	
	/** Synchronous memory sync.  */
	public static final int MS_SYNC  =       4;				
	
	/** Invalidate the caches.  */
	public static final int MS_INVALIDATE =  2;               

	/**
	 * The msync() function shall write all modified data to permanent storage locations, if any, in those whole pages containing any part of the address space of the process starting at address addr and continuing for len bytes. If no such storage exists, msync() need not have any effect. If requested, the msync() function shall then invalidate cached copies of data. 
	 * */
	public static final native int msync(long addr, long length,int flags);

	public static final native byte byteAt(long pointer);

	public static final native long longAt(long pointer);

	public static final native int intAt(long pointer);

	/**
	 * The malloc() function allocates size bytes and returns a pointer to the allocated memory. The memory is not initialized. If size is 0, then malloc() returns either NULL, or a unique pointer value that can later be successfully passed to free(). 
	 * */
	public static final native long malloc(long size);

	public static final native void setLongAt(long pointer,long val);

	public static final native void setIntAt(long pointer,int val);

	public static final native void setByteAt(long pointer,byte val);

	public static final native long getObjectPointer(Object pointer);

	public static final native Object getObjectAtPointer(long pointer);

	/**
	 * The mprotect() function shall change the access protections to be that specified by prot for those whole pages containing any part of the address space of the process starting at address addr and continuing for len bytes. The parameter prot determines whether read, write, execute, or some combination of accesses are permitted to the data being mapped. The prot argument should be either PROT_NONE or the bitwise-inclusive OR of one or more of PROT_READ, PROT_WRITE, and PROT_EXEC. 
	 * */
	public static final native int mprotect(long addr,long size,int prot);


	public static final int SPLICE_F_MOVE = 0x01;
	public static final int SPLICE_F_NONBLOCK = 0x02;
	public static final int SPLICE_F_MORE = 0x04;

	//TODO
	public static final native long splice(int sfd,long soff,int dfd,long doff,long len,int flags);

	/**
	 * ssize_t sendfile(int out_fd, int in_fd, off_t * offset , size_t  count);
	 * */
	public static final native long sendfile(int out_fd,int in_fd,long off,long len); 
	
	/**
	 * The <errno.h> header file defines the integer variable errno, which is set by system calls and some library functions in the event of an error to indicate what went wrong. Its value is significant only when the return value of the call indicated an error (i.e., -1 from most system calls; -1 or NULL from most library functions); a function that succeeds is allowed to change errno. 
	 * */
	public static final native int errno();

	/**
	 * The read() function shall attempt to read nbyte bytes from the file associated with the open file descriptor, fildes, into the buffer pointed to by buf. The behavior of multiple concurrent reads on the same pipe, FIFO, or terminal device is unspecified. 
	 * */
	public static final native long read(int fd,long start_pointer,long size);

	/**
	 * The write() function shall attempt to write nbyte bytes from the buffer pointed to by buf to the file associated with the open file descriptor, fildes. 
	 * */
	public static final native long write(int fd,long start_pointer,long size);

	public static final int O_ACCMODE =		0x00000003;
	public static final int O_RDONLY = 		0x00000000;
	public static final int O_WRONLY =		0x00000001;
	public static final int O_RDWR	=		0x00000002;
	public static final int O_CREAT	=		0x00000100;	/* not fcntl */
	public static final int O_EXCL	=		0x00000200;	/* not fcntl */
	public static final int O_NOCTTY=		0x00000400;	/* not fcntl */
	public static final int O_TRUNC	=		0x00001000;	/* not fcntl */
	public static final int O_APPEND=		0x00002000;
	public static final int O_NONBLOCK=		0x00004000;
	public static final int O_DSYNC	=		0x00010000;	/* used to be O_SYNC, see below */
	public static final int FASYNC	=		0x00020000;	/* fcntl, for BSD compatibility */
	public static final int O_DIRECT=		0x00040000;	/* direct disk access hint */
	public static final int O_LARGEFILE=	0x00100000;
	public static final int O_DIRECTORY=	0x00200000;	/* must be a directory */
	public static final int O_NOFOLLOW=		0x00400000;	/* don't follow links */
	public static final int O_NOATIME=		0x01000000;
	public static final int O_CLOEXEC=		0x02000000;	/* set close_on_exec */


	public static final int F_DUPFD	=	0;	/* dup */
	public static final int F_GETFD	=	1;	/* get close_on_exec */
	public static final int F_SETFD	=	2;	/* set/clear close_on_exec */
	public static final int F_GETFL	=	3;	/* get file->f_flags */
	public static final int F_SETFL	=	4;	/* set file->f_flags */
	public static final int F_GETLK	=	5;
	public static final int F_SETLK	=	6;
	public static final int F_SETLKW=	7;
	public static final int F_SETOWN=	8;	/* for sockets. */
	public static final int F_GETOWN=	9;	/* for sockets. */
	public static final int F_SETSIG=	10;	/* for sockets. */
	public static final int F_GETSIG=	11;	/* for sockets. */
	public static final int F_GETLK64=	12;	/*  using 'struct flock64' */
	public static final int F_SETLK64=	13;
	public static final int F_SETLKW64=	14;
	public static final int F_SETOWN_EX=	15;
	public static final int F_GETOWN_EX=	16;
	public static final int F_OWNER_TID=	0;
	public static final int F_OWNER_PID=	1;
	public static final int F_OWNER_PGRP=	2;

	public static final native int fcntl(int fd,int cmd,int sarg);

	public static final int MSG_PEEK		= 0x02;	/* Peek at incoming messages.  */
	public static final int MSG_DONTROUTE	= 0x04;	/* Don't use local routing.  */
	public static final int MSG_TRYHARD		= MSG_DONTROUTE;
	public static final int MSG_CTRUNC		= 0x08;	/* Control data lost before delivery.  */
	public static final int MSG_PROXY		= 0x10;/* Supply or ask second address.  */
	public static final int MSG_TRUNC		= 0x20;
	public static final int MSG_DONTWAIT	= 0x40; /* Nonblocking IO.  */
	public static final int MSG_EOR		= 0x80; /* End of record.  */
	public static final int MSG_WAITALL		= 0x100; /* Wait for a full request.  */
	public static final int MSG_FIN		= 0x200;
	public static final int MSG_SYN		= 0x400;
	public static final int MSG_CONFIRM		= 0x800; /* Confirm path validity.  */
	public static final int MSG_RST		= 0x1000;
	public static final int MSG_ERRQUEUE	= 0x2000; /* Fetch message from error queue.  */
	public static final int MSG_NOSIGNAL	= 0x4000; /* Do not generate SIGPIPE.  */
	public static final int MSG_MORE		= 0x8000;  /* Sender will send more.  */
	public static final int MSG_WAITFORONE	= 0x10000; /* Wait for at least one packet to return.*/
	public static final int MSG_FASTOPEN	= 0x20000000; /* Send data in TCP SYN.  */

	public static final native long recv(int fd,long start_pointer,long size,int flag);


	public static final native long send(int fd,long start_pointer,long size,int flag);

	public static final native int ioctl(int fd,int rq,long pointer);

	public static final native void jstrcpyp(String str,long pointer);

	public static final native long jstrcpy(String str);

	public static final native String getCstr(long pointer);

	public static final native String getCstrUTF(long pointer);

	public static final native int getuid();

	public static final native int getgid();

	public static final native int setuid(int uid);

	public static final native int setgid(int gid);

	public static final native int geteuid();

	public static final native int getegid();

	public static final native int seteuid(int uid);

	public static final native int setegid(int gid);

	public static final native void exit(int ret);

	public static final native int ftruncate(int fd,long len);

	public static final native int truncate(String path,long len);

	/**
	 *  user (file owner) has read, write and execute permission
	 * */
	public static final int S_IRWXU = 00700;

	/**
	 *  user has read permission
	 * */
	public static final int S_IRUSR = 00400;

	/**
	 *  user has write permission
	 * */
	public static final int S_IWUSR = 00200;

	/**
	 *  user has execute permission
	 * */
	public static final int S_IXUSR = 00100;

	/**
	 *  group has read, write and execute permission
	 * */
	public static final int S_IRWXG = 00070;

	/**
	 *  group has read permission
	 * */
	public static final int S_IRGRP = 00040;

	/**
	 *  group has write permission
	 * */
	public static final int S_IWGRP = 00020;

	/**
	 *  group has execute permission
	 * */
	public static final int S_IXGRP = 00010;

	/**
	 *  others have read, write and execute permission
	 * */
	public static final int S_IRWXO = 00007;

	/**
	 *  others have read permission
	 * */
	public static final int S_IROTH = 00004;

	/**
	 *  others have write permission
	 * */
	public static final int S_IWOTH = 00002;

	/**
	 *  others have execute permission
	 * */
	public static final int	S_IXOTH = 00001;

	public static final native int open(String path,int flag);

	public static final native int openm(String path,int flag,int mode);

	public static final native int creat(String path,int mode);
	
	public static final native int mkdir(String path,int mode);

	public static final native short shortAt(long addr);
	public static final native void setShortAt(long addr,short s);

	public static final native float floatAt(long addr);
	public static final native void setFloatAt(long addr,float f);

	public static final native double doubleAt(long addr);
	public static final native void setDoubleAt(long addr,double d);
	
	public static final native int tcgetattr(int fd, long termiosStruct);
	
	public static final native int tcsetattr(int fd,int optional_action,long termiosStruct);
	
	public static final native void memcpy(long destination,long source, int length);
	
	public static final native void memset(long addr, char val,int len);
	
	private static final int dummyFD;
	
	static
	{
		INTEGER fd1 = new INTEGER();
		INTEGER fd2 = new INTEGER();
		socketpair(fd1, fd2);
		//close(fd2);
		
		dummyFD = fd1.getValue();
		
		final int len = 4096; 
		final long addr = malloc(len);
		final int f = fd2.getValue(); 
		Thread t = new Thread()
		{
			public void run()
			{
				//while(true)
					read(f, addr, len);
			}
		};
		
		t.setName("Pointer validator dummy socketpair reader.");
		t.setDaemon(true);
		t.start();
	}

	//http://www.sourceware.org/pthreads-win32/manual/pthread_cond_init.html
	
	
	/**
	 * Megvizsgálja hogy az adott pointer olvasható-e a címtértben.
	 * */
	public static final boolean isAccessible(long address)
	{
		/*Egy olyan Socketpárba ír aminek a másik oldalát egy szálon olvassuk.
		 * Nem valami hatékony de legalább van.
		 * Ha a /dev/null-t nyitnám meg akkor azt null pointer esetén is tudnám írni...
		 * Ha nem olvasom a másik oldalt akkor egy idő után blokkolásba megy az írás,
		 * fnctl-lel nem lehet NONBlock-ot beállítani.
		 * Ha pedig bezárom akkor mindig fail...
		 */
		return write(dummyFD, address, 1) > 0;
	}
	
	/**
	 * Returns the length of the C string str.
	 * The length of a C string is determined by the terminating null-character: A C string is as long as the number of characters between the beginning of the string and the terminating null character (without including the terminating null character itself).
	 */
	public static final native int strlen(long pointer);
	
	/**
	 * Copies the C string pointed by source into the array pointed by destination, including the terminating null character (and stopping at that point).
	 * */
	public static final native void strcpy(long destination,long soruce);
	
	public static final native void cpyrange(long destination,long soruce,int len);
	
	public static final native int getpid();
	
	public static final native int tcflush(int fd,int param);
	public static final native int tcdrain(int fd);
	
	/**
	 * int clone(int (*fn)(void *), void *child_stack,int flags, void *arg, ...);
	 * clone() creates a new process, in a manner similar to fork(2). It is actually a library function layered on top of the underlying clone() system call, hereinafter referred to as sys_clone. A description of sys_clone is given toward the end of this page.
	 * Unlike fork(2), these calls allow the child process to share parts of its execution context with the calling process, such as the memory space, the table of file descriptors, and the table of signal handlers. (Note that on this manual page, "calling process" normally corresponds to "parent process". But see the description of CLONE_PARENT below.)
	 * http://man7.org/linux/man-pages/man2/clone.2.html 
	 * */
	public static final native int clone(long instructionStart,long stackAddress,int flags,long argumentsPointer);
	
	/** Set if VM shared between processes.  */
	public static final int CLONE_VM =     0x00000100;
	
	/** Set if fs info shared between processes.  */
	public static final int CLONE_FS =     0x00000200;
	
	/** Set if open files shared between processes.  */
	public static final int CLONE_FILES =  0x00000400; 
	
	/** Set if signal handlers shared.  */
	public static final int CLONE_SIGHAND= 0x00000800; 
	
	/** Set if tracing continues on the child.  */
	public static final int CLONE_PTRACE = 0x00002000; 
	
	/** Set if the parent wants the child to wake it up on mm_release.  */
	public static final int CLONE_VFORK  = 0x00004000;
	
	/** Set if we want to have the same parent as the cloner.  */
	public static final int CLONE_PARENT = 0x00008000;
	
	/** Set to add to same thread group.  */
	public static final int CLONE_THREAD = 0x00010000;
	
	/** Set to create new namespace.  */
	public static final int CLONE_NEWNS  = 0x00020000; 
	
	/** Set to shared SVID SEM_UNDO semantics.  */
	public static final int CLONE_SYSVSEM= 0x00040000; 
	
	/** Set TLS info.  */
	public static final int CLONE_SETTLS = 0x00080000; 
	
	/** Store TID in userlevel buffer before MM copy.  */
	public static final int CLONE_PARENT_SETTID = 0x00100000;
	
	/** Register exit futex and memory location to clear.  */
	public static final int CLONE_CHILD_CLEARTID= 0x00200000;
	
	/** Create clone detached.  */
	public static final int CLONE_DETACHED= 0x00400000;
	
	/** Set if the tracing process can't force CLONE_PTRACE on this clone.  */
	public static final int CLONE_UNTRACED= 0x00800000;
	
	/** Store TID in userlevel buffer in the child.  */
	public static final int CLONE_CHILD_SETTID= 0x01000000;
	
	/** New utsname group.  */	
	public static final int CLONE_NEWUTS =  0x04000000;
	
	/** New ipcs.  */
	public static final int CLONE_NEWIPC =  0x08000000;
	
	/** New user namespace.  */
	public static final int CLONE_NEWUSER = 0x10000000;     
	
	/** New pid namespace.  */
	public static final int CLONE_NEWPID  = 0x20000000;      
	
	/** New network namespace.  */
	public static final int CLONE_NEWNET  = 0x40000000;      
	
	/** Clone I/O context.  */
	public static final int CLONE_IO      = 0x80000000;      
	
	public static final native int ioperm(int from, int num,int turn_on);
	
	public static final native byte inb(short addr);
	
	public static final native void outb(byte val,short addr);
	
	 public static final int  IFF_UP =          0x1 ;            /* interface is up              */
	 public static final int  IFF_BROADCAST =   0x2 ;           /* broadcast address valid      */
	 public static final int  IFF_DEBUG =      0x4  ;           /* turn on debugging            */
	 public static final int  IFF_LOOPBACK =   0x8  ;           /* is a loopback net            */
	 public static final int  IFF_POINTOPOINT = 0x10;            /* interface is has p-p link    */
	 public static final int  IFF_NOTRAILERS = 0x20 ;           /* avoid use of trailers        */
	 public static final int  IFF_RUNNING =    0x40 ;           /* interface RFC2863 OPER_UP    */
	 public static final int  IFF_NOARP =      0x80 ;           /* no ARP protocol              */
	 public static final int  IFF_PROMISC =    0x100;           /* receive all packets          */
	 public static final int  IFF_ALLMULTI =   0x200;           /* receive all multicast packets*/

	 public static final int  IFF_MASTER  =    0x400;           /* master of a load balancer    */
	 public static final int  IFF_SLAVE   =    0x800;           /* slave of a load balancer     */
	 
	 public static final int  IFF_MULTICAST =  0x1000;          /* Supports multicast           */

	 public static final int  IFF_PORTSEL  =   0x2000;          /* can set media type           */
	 public static final int  IFF_AUTOMEDIA =  0x4000;          /* auto media select active     */
	 public static final int  IFF_DYNAMIC   =  0x8000;          /* dialup device with changing addresses*/

	 public static final int  IFF_LOWER_UP  =  0x10000;         /* driver signals L1 up         */
	 public static final int  IFF_DORMANT   =  0x20000;        /* driver signals dormant       */

	 public static final int  IFF_ECHO     =   0x40000 ;        /* echo sent packets            */

	 public static final int  IFF_VOLATILE  =  (IFF_LOOPBACK|IFF_POINTOPOINT|IFF_BROADCAST|IFF_ECHO|
	                  IFF_MASTER|IFF_SLAVE|IFF_RUNNING|IFF_LOWER_UP|IFF_DORMANT);
	 
	 /* Private (from user) interface flags (netdevice->priv_flags). */
	 public static final int  IFF_802_1Q_VLAN = 0x1   ;          /* 802.1Q VLAN device.          */
	 public static final int  IFF_EBRIDGE =    0x2     ;        /* Ethernet bridging device.    */
	 public static final int  IFF_SLAVE_INACTIVE  =     0x4 ;    /* bonding slave not the curr. active */
	 public static final int  IFF_MASTER_8023AD =      0x8   ;  /* bonding master, 802.3ad.     */
	 public static final int  IFF_MASTER_ALB  = 0x10         ;   /* bonding master, balance-alb. */
	 public static final int  IFF_BONDING    = 0x20         ;   /* bonding master or slave      */
	 public static final int  IFF_SLAVE_NEEDARP  =0x40       ;   /* need ARPs for validation     */
	 public static final int  IFF_ISATAP     = 0x80          ;  /* ISATAP interface (RFC4214)   */

	 public static final int  IF_GET_IFACE   = 0x0001      ;    /* for querying only */
	 public static final int  IF_GET_PROTO   = 0x0002;

	 /* For definitions see hdlc.h */
	 public static final int  IF_IFACE_V35   = 0x1000 ;         /* V.35 serial interface        */
	 public static final int  IF_IFACE_V24   = 0x1001  ;        /* V.24 serial interface        */
	 public static final int  IF_IFACE_X21   = 0x1002  ;        /* X.21 serial interface        */
	 public static final int  IF_IFACE_T1    = 0x1003  ;        /* T1 telco serial interface    */
	 public static final int  IF_IFACE_E1    = 0x1004  ;        /* E1 telco serial interface    */
	 public static final int  IF_IFACE_SYNC_SERIAL = 0x1005 ;    /* can't be set by software     */
	 public static final int  IF_IFACE_X21D  = 0x1006  ;        /* X.21 Dual Clocking (FarSite) */

	 /* For definitions see hdlc.h */
	 public static final int  IF_PROTO_HDLC  = 0x2000   ;       /* raw HDLC protocol            */
	 public static final int  IF_PROTO_PPP   = 0x2001 ;         /* PPP protocol                 */
	 public static final int  IF_PROTO_CISCO = 0x2002   ;       /* Cisco HDLC protocol          */
	 public static final int  IF_PROTO_FR    = 0x2003   ;       /* Frame Relay protocol         */
	 public static final int  IF_PROTO_FR_ADD_PVC = 0x2004  ;    /*    Create FR PVC             */
	 public static final int  IF_PROTO_FR_DEL_PVC =  0x2005  ;    /*    Delete FR PVC             */
	 public static final int  IF_PROTO_X25   = 0x2006        ;  /* X.25                         */
	 public static final int  IF_PROTO_HDLC_ETH  = 0x2007    ;    /* raw HDLC, Ethernet emulation */
	 public static final int  IF_PROTO_FR_ADD_ETH_PVC = 0x2008 ; /*  Create FR Ethernet-bridged PVC */
	 public static final int  IF_PROTO_FR_DEL_ETH_PVC = 0x2009 ; /*  Delete FR Ethernet-bridged PVC */
	 public static final int  IF_PROTO_FR_PVC = 0x200A    ;      /* for reading PVC status       */
	 public static final int  IF_PROTO_FR_ETH_PVC = 0x200B;
	 public static final int  IF_PROTO_RAW  =  0x200C     ;     /* RAW Socket         
	
	
23 /* Read queue size */
  public static final int  TUN_READQ_SIZE = 500;
		  /* TUN device flags */
  public static final int  TUN_TUN_DEV   =  0x0001;  
  public static final int  TUN_TAP_DEV   =  0x0002;
  public static final int  TUN_TYPE_MASK =  0x000f;

  public static final int  TUN_FASYNC     = 0x0010;
  public static final int  TUN_NOCHECKSUM = 0x0020;
  public static final int  TUN_NO_PI      = 0x0040;
  public static final int  TUN_ONE_QUEUE  = 0x0080;
  public static final int  TUN_PERSIST    = 0x0100; 
  /* Ioctl defines */
 
  /*
  public static final int  TUNSETNOCSUM  _IOW('T', 200, int) 
  public static final int  TUNSETDEBUG   _IOW('T', 201, int) 
  public static final int  TUNSETIFF     _IOW('T', 202, int) 
  public static final int  TUNSETPERSIST _IOW('T', 203, int) 
  public static final int  TUNSETOWNER   _IOW('T', 204, int)
  public static final int  TUNSETLINK    _IOW('T', 205, int)
  public static final int  TUNSETGROUP   _IOW('T', 206, int)
  */
  
  /* TUNSETIFF ifr flags */
  public static final int  IFF_TUN   =      0x0001;
  public static final int  IFF_TAP    =     0x0002;
  public static final int  IFF_NO_PI   =    0x1000;
  public static final int  IFF_ONE_QUEUE =  0x2000;

  public static final int O_NDELAY = 0x0004;
	
  public static final native int tunalloc(String tun,int flag);
	
  
  
	
	public static final int RTLD_LAZY	= 0x0001;
	public static final int RTLD_NOW	= 0x0002;
	public static final int RTLD_GLOBAL	= 0x0100;
	public static final int RTLD_LOCAL	= 0x0000;
	public static final int RTLD_NOSHARE= 0x1000;
	public static final int RTLD_EXE	= 0x2000;
	public static final int RTLD_SCRIPT	= 0x4000;

	public static final int SOL_SOCKET = 0xffff;

	

	public static final native long dlopen(String file, int flags);

	public static final native String dlerror();

	public static final native long dlsym(long handle, String symbol); 
	
	public static final native int dlclose(long handle);
	
	//TODO áthelyezés javaNative osztályba
	
	public static native long placeString(String str);
	
  
  
  
  
  //env->AllocObject azt amit kerestem, konstruktor nélküli objektumlétrehozás
  
	//dlopen és társai ha olyna metódusokat akarok hívni amihez nem akarok programkódot fordítani ill nem mindig elérhető az adott gépen
	
	/*
	 * int setenv(const char *name, const char *value, int overwrite);
	 * int unsetenv(const char *name);
	 * */
  
  
  public static void main(String[] args)
  {
	  System.out.println(getpid());
  }
}