package eu.javaexperience.unix.user;

import java.io.IOException;

import eu.javaexperience.unix.user.exception.GroupDoesnotExistException;

public class UnixGroup implements UnixGroupEntity
{
	protected final String gropuname;
	protected final int gid;
	
	public static UnixGroup getInstanceByName(String name) throws GroupDoesnotExistException, IOException
	{
		return new UnixGroup(name, UnixEntityManager.gidByGroupname(name));
	}
	
	public static UnixGroup getInstanceByGid(int gid) throws GroupDoesnotExistException, IOException
	{
		return new UnixGroup(UnixEntityManager.groupnameByGID(gid), gid);
	}
	
	public UnixGroup(String grpname, int gid)
	{
		this.gropuname = grpname;
		this.gid = gid;
	}
	
	@Override
	public String getName()
	{
		return gropuname;
	}

	@Override
	public String getGroupname()
	{
		return gropuname;
	}

	@Override
	public int getGid()
	{
		return gid;
	}

	@Override
	public String toString()
	{
		return "UnixGroup: "+gropuname;
	}
	
	@Override
	public UnixUserEntity[] getUsers()
	{
		return null;
	}
}
