/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.unix.user;

import eu.javaexperience.reflect.Mirror;
import eu.javaexperience.unix.user.UnixEntityManager;
import eu.javaexperience.unix.user.UnixGroup;
import eu.javaexperience.unix.user.UnixGroupEntity;
import eu.javaexperience.unix.user.UnixUserEntity;
import eu.javaexperience.unix.user.exception.UserDoesnotExistException;
import java.io.IOException;
import java.security.Principal;

public class UnixUser
implements UnixUserEntity,
Principal {
    protected final String username;
    protected final int uid;

    public UnixUser(String username, int uid) {
        this.username = username;
        this.uid = uid;
    }

    @Override
    public String getName() {
        return this.username;
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public int getUid() {
        return this.uid;
    }

    @Override
    public String getDefaultGroupname() {
        try {
            return UnixEntityManager.getUserDefaultGroupName(this.username);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public int getDefaultGroupGid() {
        try {
            return UnixEntityManager.getUserDefaultGroupGid(this.username);
        }
        catch (Exception e) {
            return -1;
        }
    }

    @Override
    public UnixGroup getDefaultGroup() {
        try {
            return UnixGroup.getInstanceByName(UnixEntityManager.getUserDefaultGroupName(this.username));
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public UnixGroupEntity[] getUnixGroups() {
        return null;
    }

    @Override
    public String[] getUnixGroupNames() {
        try {
            return UnixEntityManager.getUserGroups(this.username);
        }
        catch (Exception e) {
            return Mirror.emptyStringArray;
        }
    }

    @Override
    public int[] getUnixGids() {
        return null;
    }

    @Override
    public String toString() {
        return "UnixUser: " + this.username;
    }

    public String getHomePath() throws UserDoesnotExistException, IOException {
        return UnixEntityManager.getUserHomePath(this.username);
    }

    public String getRealName() throws UserDoesnotExistException, IOException {
        return UnixEntityManager.getUserRealName(this.username);
    }
}

