package eu.javaexperience.nativ.java;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;

import eu.javaexperience.nativ.posix.INTEGER;
import eu.javaexperience.nativ.posix.Posix;

public class SockAddr implements Closeable
{
	protected int family;
	protected long ptr;
	protected int size;
	
	protected String host;
	protected int port;
	
	public String getHost()
	{
		return host;
	}
	
	public int getPort()
	{
		return port;
	}
	
	public int getFamily()
	{
		return family;
	}
	
	public long getAddrPointer()
	{
		return ptr;
	}
	
	
	public int getAddrLen()
	{
		return size;
	}
	
	@Override
	protected void finalize() throws Throwable
	{
		close();
		super.finalize();
	}

	@Override
	public void close() throws IOException
	{
		long addr = ptr; 
		ptr = 0;
		Posix.free(addr);
	}
	
	public static SockAddr fromSocketaddress(InetSocketAddress addr)
	{
		return fromIpv4(addr.getAddress().getHostAddress(), (short) addr.getPort());
	}
	
	public static SockAddr fromUds(String path)
	{
		SockAddr ret = new SockAddr();
		ret.host = path;
		ret.port = -1;
		ret.family = Posix.AF_UNIX;
		INTEGER addrl = new INTEGER();
		ret.ptr = JavaNativeExtension.newSockaddrUn(path, addrl);
		ret.size = addrl.getValue();
		return ret;
	}
	
	//hack to specify UDS in IPv4 address socket everywhere in java.
	
	public static SockAddr fromIpv4(String ip, int port)
	{
		if(port < 0)
		{
			return fromUds(ip);
		}
		
		SockAddr ret = new SockAddr();
		ret.host = ip;
		ret.port = port;
		ret.family = Posix.AF_INET;
		INTEGER addrl = new INTEGER();
		ret.ptr = JavaNativeExtension.newSockaddrIn(ip, port, addrl);
		ret.size = addrl.getValue();
		return ret;
	}

	public static SockAddr fromIpv4(InetAddress host, int port)
	{
		if(port < 0)
		{
			return fromUds(host.getHostName());
		}
		
		return fromIpv4(host.getHostAddress(), port);
	}
}
