#include <pty.h>
#include <stdlib.h>
#include <stdio.h>
#include <sys/un.h>
#include <utmp.h>
#include <cstring>
#include <termio.h>
#include <iostream>
#include <unistd.h>
#include <sys/types.h>
#include <signal.h>
#include <unistd.h>
#include <pty.h>
#include <jni.h>
#include <sys/wait.h>
#include <sys/socket.h>
#include <sys/stat.h>
#include <poll.h>
#include <sys/mman.h>
#include <fcntl.h>
#include <cerrno>
#include <unistd.h>
#include <fcntl.h>
#include <stdio.h>
#include <sched.h>
#include <sys/io.h>
#include <sys/sendfile.h>
#include <dlfcn.h>
#include <netinet/in.h>

#define _BSD_SOURCE
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>

extern "C"
{
	static jfieldID	inp;	//INTEGER
	static jfieldID	chp;	//STRING
	static jfieldID pointer; //VOID (long)

	JNIEXPORT void JNICALL Java_eu_javaexperience_nativ_java_JavaNativeExtension_initNative(JNIEnv * env,jobject obj)
	{
		jclass cls;

		cls = env->FindClass("eu/javaexperience/nativ/posix/STRING");
		if(cls == NULL)
				return env->FatalError("eu/javaexperience/nativ/posix/STRING osztály nem található");

		chp = env->GetFieldID(cls, "value", "Ljava/lang/String;");

		cls = env->FindClass("eu/javaexperience/nativ/posix/INTEGER");
		if(cls == NULL)
			return env->FatalError("eu/javaexperience/nativ/posix/INTEGER osztály nem található");

		inp = env->GetFieldID(cls, "value", "I");
		if(inp == NULL)
			return env->FatalError("INTEGER.value field not found");

		cls = env->FindClass("eu/javaexperience/nativ/posix/VOID");
		if(cls == NULL)
			return env->FatalError("eu/javaexperience/nativ/posix/VOID osztály nem található");

		pointer = env->GetFieldID(cls, "value", "J");
	}

	JNIEXPORT int JNICALL Java_eu_javaexperience_nativ_java_JavaNativeExtension_udsClientConnect(JNIEnv * env,jobject obj,jstring path)
	{
		sockaddr_un address;
		int sock;
		size_t addrlen;

		if((sock = socket(PF_UNIX, SOCK_STREAM, 0))<0)
			return -1;

		memset(&address,0,sizeof(address));
		address.sun_family = AF_UNIX;

		char* utvon = (char*) env->GetStringUTFChars(path, 0);
		strncpy(address.sun_path, utvon, sizeof(address.sun_path)-1);
		env->ReleaseStringUTFChars(path, utvon);

		addrlen = sizeof(address.sun_family) + strnlen(address.sun_path, sizeof(address.sun_path));

		if(connect(sock,(struct sockaddr*) &address, addrlen) < 0)
			return -1;

		return sock;
	}

	JNIEXPORT int JNICALL Java_eu_javaexperience_nativ_java_JavaNativeExtension_udsServerListen(JNIEnv * env, jobject obj, jstring path, jint backlog,jobject sp,jobject alp)
	{
		sockaddr_un address;
		int sock;
		size_t addrlen;

		if((sock = socket(PF_UNIX, SOCK_STREAM, 0))<0)
			return -1;

		memset(&address,0,sizeof(address));
		address.sun_family = AF_UNIX;

		char* utvon = (char*) env->GetStringUTFChars(path, 0);
		strncpy(address.sun_path, utvon, sizeof(address.sun_path)-1);
		env->ReleaseStringUTFChars(path, utvon);

		addrlen = sizeof(address.sun_family)+ strnlen(address.sun_path, sizeof(address.sun_path));

		if(bind(sock,(struct sockaddr*) &address, addrlen) < 0)
			return -1;


		if(listen(sock,backlog)<0)
			return -1;


		env->SetLongField(sp,pointer, (jlong) &address);
		env->SetIntField(alp,inp, addrlen);

		return sock;
	}

	JNIEXPORT int JNICALL Java_eu_javaexperience_nativ_java_JavaNativeExtension_acceptBounded(JNIEnv * env,jobject obj,int fd,jobject tfd,jlong sp,jlong alp)
	{
		socklen_t len = alp;
		int sock = accept(fd, (struct sockaddr*) sp, &len);
		env->SetIntField(tfd,inp,sock);
		return sock;
	}

	JNIEXPORT jlong JNICALL Java_eu_javaexperience_nativ_java_JavaNativeExtension_newSockaddrUn(JNIEnv * env,jobject obj,jstring path, jobject alp)
	{
		sockaddr_un* ret = (sockaddr_un*) malloc(sizeof(sockaddr_un));

		memset(ret, 0, sizeof(sockaddr_un));
		ret->sun_family = AF_UNIX;

		char* utvon = (char*) env->GetStringUTFChars(path, 0);
		strncpy(ret->sun_path, utvon, sizeof(ret->sun_path)-1);
		env->ReleaseStringUTFChars(path, utvon);

		size_t addrlen = sizeof(ret->sun_family)+ strnlen(ret->sun_path, sizeof(ret->sun_path));

		if(NULL != alp)
		{
			env->SetIntField(alp, inp, (int) addrlen);
		}

		return (jlong) ret;
	}

	JNIEXPORT jlong JNICALL Java_eu_javaexperience_nativ_java_JavaNativeExtension_newSockaddrIn(JNIEnv * env,jobject obj,jstring ip, jint port, jobject alp)
	{
		sockaddr_in* ret = (sockaddr_in*) malloc(sizeof(sockaddr_in));

		memset(ret, 0, sizeof(sockaddr_in));
		ret->sin_family = AF_INET;
		ret->sin_port = htons(port);

		char* cip = (char*) env->GetStringUTFChars(ip, 0);

		inet_aton(cip, &ret->sin_addr/*.s_addr*/);
		env->ReleaseStringUTFChars(ip, cip);
		if(NULL != alp)
		{
			/*jclass in = env->FindClass("eu/javaexperience/nativ/posix/INTEGER");
			jfieldID i = env->GetFieldID(in, "value", "I");*/

			env->SetIntField(alp, inp, (int) sizeof(sockaddr_in));
		}
		return (jlong) ret;
	}

	//TODO newSockaddrin6

	JNIEXPORT jint JNICALL Java_eu_javaexperience_nativ_java_JavaNativeExtension_read(JNIEnv * env, jobject obj, jint fd, jbyteArray dst, jint off, jint len)
	{
		jboolean isCopy;
		char* arr = (char*)env->GetByteArrayElements(dst, &isCopy);
		//printf("read isCopy: %d\n", isCopy);
		int ret = read(fd, arr+off, len);
		env->ReleaseByteArrayElements(dst, (jbyte*) arr, 0);
		return ret;
	}

	JNIEXPORT jint JNICALL Java_eu_javaexperience_nativ_java_JavaNativeExtension_write(JNIEnv * env, jobject obj, jint fd, jbyteArray dst, jint off, jint len)
	{
		jboolean isCopy;
		char* arr = (char*)env->GetByteArrayElements(dst, &isCopy);
		//printf("write isCopy: %d\n", isCopy);
		int ret = write(fd, arr+off, len);
		env->ReleaseByteArrayElements(dst, (jbyte*) arr, JNI_ABORT);
		return ret;
	}

	JNIEXPORT jint JNICALL Java_eu_javaexperience_nativ_java_JavaNativeExtension_bufferedRead(JNIEnv * env, jobject obj, jint fd, jlong buff, jint buflen, jbyteArray dst, jint off, jint len)
	{
		//jboolean isCopy;
		if(len > buflen)
		{
			len = buflen;
		}
		int ret = read(fd, (char*)buff, len);
		if(ret > 0)
		{
	        env->SetByteArrayRegion(dst, off, ret, (jbyte*)buff);
		}
		return ret;
	}

	JNIEXPORT jint JNICALL Java_eu_javaexperience_nativ_java_JavaNativeExtension_bufferedWrite(JNIEnv * env, jobject obj, jint fd, jlong buff, jint buflen, jbyteArray dst, jint off, jint len)
	{
		if(len > buflen)
		{
			len = buflen;
		}

		env->GetByteArrayRegion(dst, off, len, (jbyte*) buff);
		int ret = write(fd, (char*)buff, len);
		return ret;
	}

	JNIEXPORT int JNICALL Java_eu_javaexperience_nativ_java_JavaNativeExtension_accept(JNIEnv * env,jobject thi, int fd, long addr, jint _size)
	{
		socklen_t size = _size;
		return accept(fd, (struct sockaddr *)addr, &size);
	}

	JNIEXPORT int JNICALL Java_eu_javaexperience_nativ_java_JavaNativeExtension_initSocket(JNIEnv * env,jobject thi, int fd)
	{
		int x = 1;
		return setsockopt(fd, SOL_SOCKET, SO_REUSEADDR, &x, sizeof(x));
	}

	/*
		the way that everybody avoid: arrayCritical & read (see the doc, explicitly forbids this situation)
		JNIEXPORT jint JNICALL Java_eu_javaexperience_nativ_java_JavaNativeExtension_experimentalRead(JNIEnv * env, jobject obj, jint fd, jbyteArray dst, jint off, jint len)
		{
			jboolean isCopy;
			char* arr = (char*)env->GetPrimitiveArrayCritical(dst, &isCopy);
			//printf("experimentalRead isCopy: %d\n", isCopy);
			int ret = read(fd, arr+off, len);
			env->ReleasePrimitiveArrayCritical(dst, (jbyte*) arr, 0);
			return ret;
		}

		JNIEXPORT jint JNICALL Java_eu_javaexperience_nativ_java_JavaNativeExtension_experimentalWrite(JNIEnv * env, jobject obj, jint fd, jbyteArray dst, jint off, jint len)
		{
			jboolean isCopy;
			char* arr = (char*)env->GetPrimitiveArrayCritical(dst, &isCopy);
			//printf("experimentalWrite isCopy: %d\n", isCopy);
			int ret = write(fd, arr+off, len);
			env->ReleasePrimitiveArrayCritical(dst, (jbyte*) arr, JNI_ABORT);
			return ret;
		}
	*/

	static int maxFdioSize = 8196;

	JNIEXPORT jint JNICALL Java_eu_javaexperience_nativ_java_JavaNativeExtension_experimentalRead(JNIEnv * env, jobject obj, jint fd, jbyteArray dst, jint off, jint len)
	{
		jboolean isCopy;
		if(len > maxFdioSize)
		{
			len = maxFdioSize;
		}

		char* buff = alloca(len);
		int ret = read(fd, (char*)buff, len);
		if(ret > 0)
		{
			env->SetByteArrayRegion(dst, off, ret, (jbyte*)buff);
		}
		return ret;
	}

	JNIEXPORT jint JNICALL Java_eu_javaexperience_nativ_java_JavaNativeExtension_experimentalWrite(JNIEnv * env, jobject obj, jint fd, jbyteArray dst, jint off, jint len)
	{
		jboolean isCopy;
		if(len > maxFdioSize)
		{
			len = maxFdioSize;
		}

		char* buff = alloca(len);
		env->GetByteArrayRegion(dst, off, len, (jbyte*) buff);
		int ret = write(fd, (char*)buff, len);
		return ret;
	}

}
