/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.nativ.java;

import eu.javaexperience.nativ.java.JavaNativeExtension;
import eu.javaexperience.nativ.posix.INTEGER;
import eu.javaexperience.nativ.posix.Posix;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;

public class SockAddr
implements Closeable {
    protected int family;
    protected long ptr;
    protected int size;
    protected String host;
    protected int port;

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public int getFamily() {
        return this.family;
    }

    public long getAddrPointer() {
        return this.ptr;
    }

    public int getAddrLen() {
        return this.size;
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    @Override
    public void close() throws IOException {
        long addr = this.ptr;
        this.ptr = 0L;
        Posix.free(addr);
    }

    public static SockAddr fromSocketaddress(InetSocketAddress addr) {
        return SockAddr.fromIpv4(addr.getAddress().getHostAddress(), (int)((short)addr.getPort()));
    }

    public static SockAddr fromUds(String path) {
        SockAddr ret = new SockAddr();
        ret.host = path;
        ret.port = -1;
        ret.family = 1;
        INTEGER addrl = new INTEGER();
        ret.ptr = JavaNativeExtension.newSockaddrUn(path, addrl);
        ret.size = addrl.getValue();
        return ret;
    }

    public static SockAddr fromIpv4(String ip, int port) {
        if (port < 0) {
            return SockAddr.fromUds(ip);
        }
        SockAddr ret = new SockAddr();
        ret.host = ip;
        ret.port = port;
        ret.family = 2;
        INTEGER addrl = new INTEGER();
        ret.ptr = JavaNativeExtension.newSockaddrIn(ip, port, addrl);
        ret.size = addrl.getValue();
        return ret;
    }

    public static SockAddr fromIpv4(InetAddress host, int port) {
        if (port < 0) {
            return SockAddr.fromUds(host.getHostName());
        }
        return SockAddr.fromIpv4(host.getHostAddress(), port);
    }
}

