/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.nativ.java.socket;

import eu.javaexperience.collection.map.SmallMap;
import eu.javaexperience.exceptions.UnimplementedMethodException;
import eu.javaexperience.io.fd.FDIOStream;
import eu.javaexperience.nativ.java.JavaNativeExtension;
import eu.javaexperience.nativ.java.SockAddr;
import eu.javaexperience.nativ.java.socket.FileDescriptorHolder;
import eu.javaexperience.nativ.java.socket.NativeLinuxInputStream;
import eu.javaexperience.nativ.java.socket.NativeLinuxOutputStream;
import eu.javaexperience.nativ.posix.INTEGER;
import eu.javaexperience.nativ.posix.Posix;
import eu.javaexperience.nativ.posix.PosixErrnoException;
import eu.javaexperience.reflect.CastTo;
import eu.javaexperience.reflect.Mirror;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketImpl;
import java.net.SocketImplFactory;
import java.util.Map;

public class NativeLinuxSocketImpl
extends SocketImpl
implements FileDescriptorHolder,
FDIOStream {
    public static final SocketImplFactory FACTORY = new SocketImplFactory(){

        @Override
        public SocketImpl createSocketImpl() {
            return new NativeLinuxSocketImpl();
        }
    };
    protected int fileDescriptor;
    protected SockAddr addr;
    Map<Integer, Integer> opts = new SmallMap();
    protected static final boolean printSetOpts = false;
    protected boolean createWithStream = true;
    protected NativeLinuxInputStream is = new NativeLinuxInputStream(this);
    protected NativeLinuxOutputStream os = new NativeLinuxOutputStream(this);
    protected boolean shIn = false;
    protected boolean shOut = false;

    public static void overrideJavaSocketFacilities() throws IOException {
        ServerSocket.setSocketFactory(FACTORY);
        Socket.setSocketImplFactory(FACTORY);
    }

    @Override
    public FileDescriptor getFileDescriptor() {
        return super.getFileDescriptor();
    }

    public NativeLinuxSocketImpl() {
        this.setFd(-1);
    }

    public NativeLinuxSocketImpl(int fd) {
        this.setFd(this.fileDescriptor);
    }

    protected void setFd(int fd) {
        this.fileDescriptor = fd;
        this.fd = this.fileDescriptor < 0 ? null : new INTEGER(fd).asFileDescriptor();
        this.setSockAddr(null);
    }

    protected void setSockAddr(SockAddr addr) {
        if (null != this.addr) {
            this.addr = null;
        }
        this.addr = addr;
    }

    @Override
    public void setOption(int optID, Object value) throws SocketException {
        Integer v = (Integer)CastTo.Int.cast(value);
        if (null != v) {
            if (this.fileDescriptor >= 0) {
                this.applyOneOption(optID, v);
            }
            this.opts.put(optID, v);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void applyOneOption(int k, int v) {
        long addr = 0L;
        try {
            addr = Posix.malloc(4L);
            Posix.setIntAt(addr, v);
            int n = Posix.setsockopt(this.fileDescriptor, 65535, k, addr, 4);
        }
        finally {
            Posix.free(addr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void applyOptions() {
        long addr = 0L;
        try {
            addr = Posix.malloc(4L);
            for (Map.Entry<Integer, Integer> kv : this.opts.entrySet()) {
                Posix.setIntAt(addr, kv.getValue());
                int n = Posix.setsockopt(this.fileDescriptor, 65535, kv.getKey(), addr, 4);
            }
        }
        finally {
            Posix.free(addr);
        }
    }

    @Override
    public Object getOption(int optID) throws SocketException {
        return null;
    }

    protected void tryCreateLazy(int family) {
        if (this.fileDescriptor < 0) {
            int ret = Posix.socket(family, this.createWithStream ? 1 : 2, 0);
            NativeLinuxSocketImpl.checkException(ret, false);
            this.setFd(ret);
            if (0 != JavaNativeExtension.initSocket(ret)) {
                PosixErrnoException.throwRtIfErrorOcurred();
            }
            this.applyOptions();
        }
    }

    @Override
    public void create(boolean stream) throws IOException {
        this.createWithStream = stream;
    }

    public void connect(SockAddr a) {
        this.tryCreateLazy(a.getFamily());
        this.setSockAddr(a);
        int ret = Posix.connect(this.fileDescriptor, this.addr.getAddrPointer(), this.addr.getAddrLen());
        NativeLinuxSocketImpl.checkException(ret, true);
    }

    @Override
    public void connect(String host, int port) throws IOException {
        this.connect(SockAddr.fromIpv4(host, port));
    }

    @Override
    public void connect(InetAddress address, int port) throws IOException {
        this.connect(SockAddr.fromIpv4(address.getHostAddress(), port));
    }

    @Override
    public void connect(SocketAddress address, int timeout) throws IOException {
        this.connect(SockAddr.fromSocketaddress((InetSocketAddress)address));
    }

    public void bind(SockAddr a) throws IOException {
        this.tryCreateLazy(a.getFamily());
        this.setSockAddr(a);
        int ret = -1;
        ret = Posix.bind(this.fileDescriptor, this.addr.getAddrPointer(), this.addr.getAddrLen());
        if (0 == ret) {
            return;
        }
        NativeLinuxSocketImpl.checkException(ret, true);
    }

    @Override
    public void bind(InetAddress host, int port) throws IOException {
        this.bind(SockAddr.fromIpv4(host, port));
    }

    @Override
    public void listen(int backlog) throws IOException {
        int ret = Posix.listen(this.fileDescriptor, backlog);
        NativeLinuxSocketImpl.checkException(ret, false);
    }

    @Override
    public void accept(SocketImpl _s) throws IOException {
        NativeLinuxSocketImpl s = (NativeLinuxSocketImpl)_s;
        int ret = JavaNativeExtension.accept(this.fileDescriptor, this.addr.getAddrPointer(), this.addr.getAddrLen());
        NativeLinuxSocketImpl.checkException(ret, false);
        s.setFd(ret);
    }

    @Override
    public InputStream getInputStream() {
        return this.is;
    }

    @Override
    public OutputStream getOutputStream() {
        return this.os;
    }

    @Override
    protected int available() throws IOException {
        throw new UnimplementedMethodException("NativeLinuxSocketImpl.available");
    }

    @Override
    public void close() {
        Posix.close(this.fileDescriptor);
        this.setFd(-1);
    }

    @Override
    protected void sendUrgentData(int data) throws IOException {
        throw new UnimplementedMethodException("NativeLinuxSocketImpl.sendUrgentData");
    }

    @Override
    public int getFd() {
        return this.fileDescriptor;
    }

    protected void closeIfBothShutdown() {
        if (this.shIn && this.shOut) {
            this.close();
        }
    }

    @Override
    protected void shutdownInput() throws IOException {
        try {
            Posix.shutdown(this.fileDescriptor, 0);
            PosixErrnoException.throwRtIfErrorOcurred();
        }
        finally {
            this.shIn = true;
            this.closeIfBothShutdown();
        }
    }

    @Override
    protected void shutdownOutput() throws IOException {
        try {
            Posix.shutdown(this.fileDescriptor, 1);
            PosixErrnoException.throwRtIfErrorOcurred();
        }
        finally {
            this.shOut = true;
            this.closeIfBothShutdown();
        }
    }

    public static void checkException(int ret, boolean zeroOnly) {
        if (zeroOnly ? 0 != ret : ret < 0) {
            try {
                PosixErrnoException.throwIfErrorOcurred();
            }
            catch (Exception e) {
                Mirror.propagateAnyway((Throwable)e);
            }
        }
    }

    public boolean isClosed() {
        return -1 != this.fileDescriptor;
    }

    public String localAddress() {
        return null;
    }

    public String remoteAddress() {
        return null;
    }

    public void flush() throws IOException {
        this.os.flush();
    }

    public int getFD() {
        return this.fileDescriptor;
    }

    protected void finalize() throws Throwable {
        this.close();
    }
}

