/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.nativ.utils;

import eu.javaexperience.nativ.posix.Posix;

public class CString
implements CharSequence {
    private final long addr;
    private final int maxlen;
    private int len = -1;

    public CString(String str) {
        this.addr = Posix.jstrcpy(str);
        this.maxlen = Posix.strlen(this.addr);
    }

    public CString(int len) {
        this.addr = Posix.malloc(len);
        Posix.setByteAt(this.addr, (byte)0);
        this.maxlen = len;
    }

    public CString(String str, int maxlen) {
        this.addr = Posix.jstrcpy(str);
        int len = Posix.strlen(this.addr);
        this.maxlen = maxlen > len ? maxlen : len;
    }

    public CString(long addr, int maxlen) {
        this.addr = addr;
        this.maxlen = maxlen;
    }

    public void setCharAt(int i, char c) {
        Posix.setByteAt(this.addr + (long)i, (byte)c);
    }

    public static CString strClone(long addr, int len) {
        long p = Posix.malloc(len + 1);
        Posix.cpyrange(p, addr, len);
        return new CString(p, len);
    }

    @Override
    public char charAt(int arg0) {
        return (char)(Posix.byteAt(this.addr) + arg0);
    }

    public int getMaximalLength() {
        return this.maxlen;
    }

    public int setLength(int leng) {
        this.len = leng > this.maxlen ? this.maxlen : leng;
        return this.len;
    }

    @Override
    public int length() {
        if (this.len < 0) {
            return Posix.strlen(this.addr);
        }
        return this.len;
    }

    @Override
    public CharSequence subSequence(int arg0, int arg1) {
        CString ret = new CString(this.addr + (long)arg0, arg1 - arg0);
        ret.setLength(arg1 - arg0);
        return ret;
    }

    public void free() {
        Posix.free(this.addr);
    }

    @Override
    public String toString() {
        return Posix.getCstrUTF(this.addr);
    }

    public static void main(String[] args) {
        CString cs = new CString("Hell\u00f3 Vil\u00e1g");
        System.out.println(cs);
    }
}

