/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.unix.user;

import eu.javaexperience.arrays.ArrayTools;
import eu.javaexperience.collection.CollectionTools;
import eu.javaexperience.io.IOTools;
import eu.javaexperience.io.file.FileReloadEntry;
import eu.javaexperience.log.JavaExperienceLoggingFacility;
import eu.javaexperience.log.LogLevel;
import eu.javaexperience.log.Loggable;
import eu.javaexperience.log.LoggableUnitDescriptor;
import eu.javaexperience.log.Logger;
import eu.javaexperience.log.LoggingDetailLevel;
import eu.javaexperience.log.LoggingTools;
import eu.javaexperience.reflect.Mirror;
import eu.javaexperience.regex.RegexTools;
import eu.javaexperience.semantic.references.MayNotNull;
import eu.javaexperience.semantic.references.MayNull;
import eu.javaexperience.unix.user.exception.GroupAlredyExistException;
import eu.javaexperience.unix.user.exception.GroupDoesnotExistException;
import eu.javaexperience.unix.user.exception.InsufficientPermissionException;
import eu.javaexperience.unix.user.exception.UserDoesnotExistException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public final class UnixEntityManager {
    protected static final Logger LOG = JavaExperienceLoggingFacility.getLogger((LoggableUnitDescriptor)new Loggable("UnixEntityManager"));
    private static boolean useSUDO = false;
    protected static final File passwdFile = new File("/etc/passwd");
    protected static final File groupFile = new File("/etc/group");
    protected static final FileReloadEntry<PasswdIndex> passwdIndex = new FileReloadEntry<PasswdIndex>(passwdFile){

        protected PasswdIndex processFile(File f) throws IOException {
            return PasswdIndex.parseAndIndexPasswdFile("/etc/passwd");
        }
    };
    protected static final FileReloadEntry<GroupIndex> groupIndex = new FileReloadEntry<GroupIndex>(groupFile){

        protected GroupIndex processFile(File f) throws IOException {
            return GroupIndex.parseAndIndexGroupFile("/etc/group");
        }
    };

    protected static PasswdIndex getPasswdIndex() throws FileNotFoundException, IOException {
        return (PasswdIndex)passwdIndex.get();
    }

    protected static GroupIndex getGroupIndex() throws FileNotFoundException, IOException {
        return (GroupIndex)groupIndex.get();
    }

    protected static boolean needReload(long entryTime, long fileTime) {
        long currentTime = System.currentTimeMillis() / 1000L;
        return (fileTime /= 1000L) == currentTime || fileTime > (entryTime /= 1000L);
    }

    private static void uidNonex(int uid) throws UserDoesnotExistException {
        throw new UserDoesnotExistException("UNIX user with UID: " + uid + " doesnot exist!");
    }

    private static void gidNonex(int gid) throws GroupDoesnotExistException {
        throw new GroupDoesnotExistException("UNIX group with GID: " + gid + " doesnot exist!");
    }

    private static void userNonex(String usr) throws UserDoesnotExistException {
        throw new UserDoesnotExistException("UNIX user with username: " + usr + " doesnot exist!");
    }

    private static void groupNonex(String grp) throws GroupDoesnotExistException {
        throw new GroupDoesnotExistException("UNIX group with groupname: " + grp + " doesnot exist!");
    }

    public static struct_passwd getExistingUser(PasswdIndex index, String username) throws UserDoesnotExistException {
        struct_passwd p = index.byUsername.get(username);
        if (null == p) {
            UnixEntityManager.userNonex(username);
        }
        return p;
    }

    public static struct_passwd getExistingUser(PasswdIndex index, int uid) throws UserDoesnotExistException {
        struct_passwd p = index.byUid.get(uid);
        if (null == p) {
            UnixEntityManager.uidNonex(uid);
        }
        return p;
    }

    public static struct_group getExistingGroup(GroupIndex index, String grpname) throws GroupDoesnotExistException {
        struct_group grp = index.byGroupname.get(grpname);
        if (null == grp) {
            UnixEntityManager.groupNonex(grpname);
        }
        return grp;
    }

    public static struct_group getExistingGroup(GroupIndex index, int gid) throws GroupDoesnotExistException {
        struct_group grp = index.byGid.get(gid);
        if (null == grp) {
            UnixEntityManager.gidNonex(gid);
        }
        return grp;
    }

    public static boolean isUserExistByName(String username) throws IOException {
        return UnixEntityManager.getPasswdIndex().byUsername.containsKey(username);
    }

    public static boolean isUserExistByUID(int UID) throws IOException {
        return UnixEntityManager.getPasswdIndex().byUid.containsKey(UID);
    }

    public static int UIDByUsername(String username) throws IOException, UserDoesnotExistException {
        return UnixEntityManager.getExistingUser((PasswdIndex)UnixEntityManager.getPasswdIndex(), (String)username).uid;
    }

    public static String usernameByUID(int UID) throws IOException, UserDoesnotExistException {
        return UnixEntityManager.getExistingUser((PasswdIndex)UnixEntityManager.getPasswdIndex(), (int)UID).username;
    }

    public static String getUserHomePath(String username) throws IOException, UserDoesnotExistException {
        return UnixEntityManager.getExistingUser((PasswdIndex)UnixEntityManager.getPasswdIndex(), (String)username).homeDir;
    }

    public static String getUserRealName(String username) throws IOException, UserDoesnotExistException {
        String[] buf = UnixEntityManager.getExistingUser((PasswdIndex)UnixEntityManager.getPasswdIndex(), (String)username).etcData.split(",");
        return buf.length > 0 ? buf[0] : null;
    }

    public static String[] usersBetween(int MIN_UID, int MAX_UID) throws IOException {
        PasswdIndex index = UnixEntityManager.getPasswdIndex();
        ArrayList<String> users = new ArrayList<String>();
        for (Map.Entry<Integer, struct_passwd> kv : index.byUid.entrySet()) {
            int uidbuf = kv.getValue().uid;
            if (uidbuf < MIN_UID || uidbuf > MAX_UID) continue;
            users.add(kv.getValue().username);
        }
        return users.toArray(Mirror.emptyStringArray);
    }

    public static String[] usersUsernameContains(String part) throws IOException {
        PasswdIndex index = UnixEntityManager.getPasswdIndex();
        ArrayList<String> users = new ArrayList<String>();
        for (Map.Entry<Integer, struct_passwd> kv : index.byUid.entrySet()) {
            struct_passwd p = kv.getValue();
            if (!p.username.contains(part)) continue;
            users.add(p.username);
        }
        return users.toArray(Mirror.emptyStringArray);
    }

    public static boolean isGroupExistByName(String groupname) throws IOException {
        return UnixEntityManager.getGroupIndex().byGroupname.containsKey(groupname);
    }

    public static boolean isGroupExistByGID(int GID) throws IOException {
        return UnixEntityManager.getGroupIndex().byGid.containsKey(GID);
    }

    public static int gidByGroupname(String groupname) throws IOException, GroupDoesnotExistException {
        return UnixEntityManager.getExistingGroup((GroupIndex)UnixEntityManager.getGroupIndex(), (String)groupname).gid;
    }

    public static String groupnameByGID(int GID) throws IOException, GroupDoesnotExistException {
        return UnixEntityManager.getExistingGroup((GroupIndex)UnixEntityManager.getGroupIndex(), (int)GID).groupname;
    }

    public static String[] groupsBetween(int MIN_GID, int MAX_GID) throws IOException {
        GroupIndex index = UnixEntityManager.getGroupIndex();
        ArrayList<String> users = new ArrayList<String>();
        for (Map.Entry<Integer, struct_group> kv : index.byGid.entrySet()) {
            int uidbuf = kv.getValue().gid;
            if (uidbuf < MIN_GID || uidbuf > MAX_GID) continue;
            users.add(kv.getValue().groupname);
        }
        return users.toArray(Mirror.emptyStringArray);
    }

    public static String[] groupGroupnameContains(String part) throws IOException {
        GroupIndex index = UnixEntityManager.getGroupIndex();
        ArrayList<String> users = new ArrayList<String>();
        for (Map.Entry<Integer, struct_group> kv : index.byGid.entrySet()) {
            struct_group p = kv.getValue();
            if (!p.groupname.contains(part)) continue;
            users.add(p.groupname);
        }
        return users.toArray(Mirror.emptyStringArray);
    }

    public static boolean isUserInGroup(String username, String groupname) throws IOException, GroupDoesnotExistException {
        struct_group grp = UnixEntityManager.getExistingGroup(UnixEntityManager.getGroupIndex(), groupname);
        return grp.users.contains(username);
    }

    public static String[] getUserGroups(String username) throws IOException, UserDoesnotExistException {
        ArrayList<String> ret = new ArrayList<String>();
        for (Map.Entry<String, struct_group> kv : UnixEntityManager.getGroupIndex().byGroupname.entrySet()) {
            if (!kv.getValue().users.contains(username)) continue;
            ret.add(kv.getKey());
        }
        return ret.toArray(Mirror.emptyStringArray);
    }

    public static void addUserToGroup(String username, String groupname) throws IOException, GroupDoesnotExistException, UserDoesnotExistException, InsufficientPermissionException {
        if (!UnixEntityManager.isGroupExistByName(groupname)) {
            UnixEntityManager.groupNonex(groupname);
        }
        String[] groups = UnixEntityManager.getUserGroups(username);
        StringBuilder gs = new StringBuilder();
        for (int i = 0; i < groups.length; ++i) {
            gs.append(groups[i]);
            gs.append(",");
        }
        gs.append(groupname);
        Object[] command = new String[]{"usermod", "-G", gs.toString(), username};
        if (useSUDO) {
            command = (String[])ArrayTools.arrayAppend((Object)"sudo", (Object[])command);
        }
        try {
            new ProcessBuilder((String[])command).start().waitFor();
        }
        catch (Exception e) {
            throw new InsufficientPermissionException("Cannot perform useradd command");
        }
    }

    public static void delUserFromGroup(String username, String groupname) throws IOException, UserDoesnotExistException, InsufficientPermissionException {
        if (!UnixEntityManager.isUserExistByName(username)) {
            UnixEntityManager.userNonex(username);
        }
        String[] groups = UnixEntityManager.getUserGroups(username);
        StringBuilder gs = new StringBuilder();
        for (int i = 0; i < groups.length; ++i) {
            if (groups[i].equals(groupname)) continue;
            if (i != 0) {
                gs.append(",");
            }
            gs.append(groups[i]);
        }
        Object[] command = new String[]{"usermod", "-G", gs.toString(), username};
        if (useSUDO) {
            command = (String[])ArrayTools.arrayAppend((Object)"sudo", (Object[])command);
        }
        try {
            new ProcessBuilder((String[])command).start().waitFor();
        }
        catch (Exception e) {
            throw new InsufficientPermissionException("Cannot perform useradd command");
        }
    }

    public static void createGroup(String groupname) throws IOException, InsufficientPermissionException {
        Object[] command = new String[]{"addgroup", groupname};
        if (useSUDO) {
            command = (String[])ArrayTools.arrayAppend((Object)"sudo", (Object[])command);
        }
        try {
            new ProcessBuilder((String[])command).start();
        }
        catch (IOException e) {
            throw new InsufficientPermissionException("Cannot perform addgroup command");
        }
    }

    public static String[] usersInGroup(String group) throws IOException, GroupDoesnotExistException {
        return UnixEntityManager.getExistingGroup((GroupIndex)UnixEntityManager.getGroupIndex(), (String)group).users.toArray(Mirror.emptyStringArray);
    }

    public static boolean login(String user, String password) throws IOException, InterruptedException {
        Process p = new ProcessBuilder("pwauth").start();
        p.getOutputStream().write((user + "\n" + password + "\n").getBytes());
        p.getOutputStream().flush();
        return p.waitFor() == 0;
    }

    public static boolean delGroup(String group) throws InterruptedException, IOException {
        return new ProcessBuilder("groupdel", group).start().waitFor() == 0;
    }

    public static boolean lockUser(String user, boolean l_p_u) throws IOException, UserDoesnotExistException, InterruptedException {
        UnixEntityManager.getExistingUser(UnixEntityManager.getPasswdIndex(), user);
        return new ProcessBuilder("passwd", user, l_p_u ? "-l" : "-u").start().waitFor() == 0;
    }

    public static void kickUsersInRange(String username, int min, int max) throws IOException, InterruptedException {
        String[] users = UnixEntityManager.usersBetween(min, max);
        for (int i = 0; i < users.length; ++i) {
            if (!users[i].equals(username)) continue;
            UnixEntityManager.kickUser(username);
            return;
        }
    }

    public static void kickUser(String username) throws InterruptedException, IOException {
        new ProcessBuilder("/usr/bin/killall", "-9", "--user", username).start().waitFor();
    }

    public static void renameGroup(String mirol, String mire) throws IOException, GroupDoesnotExistException, InterruptedException, GroupAlredyExistException {
        if (!UnixEntityManager.isGroupExistByName(mirol)) {
            UnixEntityManager.groupNonex(mirol);
        }
        if (UnixEntityManager.isGroupExistByName(mire)) {
            throw new GroupAlredyExistException(mire + " nev\u0171 csoport m\u00e1r l\u00e9tezik, " + mirol + "-t nem nevezheted \u00e1t erre.");
        }
        new ProcessBuilder("groupmod", mirol, "-n", mire).start().waitFor();
    }

    protected static String[] loadShadowLines() throws FileNotFoundException, IOException {
        return IOTools.readAllLine((File)new File("/etc/shadow"));
    }

    public static boolean isUserLocked(String user) throws IOException, UserDoesnotExistException {
        String[] lines;
        String[] unit = lines = UnixEntityManager.loadShadowLines();
        for (int i = 0; i < lines.length; ++i) {
            unit = lines[i].split(":");
            if (!unit[0].equals(user)) continue;
            return unit[1].charAt(0) == '!';
        }
        UnixEntityManager.userNonex(user);
        return false;
    }

    public static String getUserDefaultGroupName(String username) throws GroupDoesnotExistException, UserDoesnotExistException, FileNotFoundException, IOException {
        return UnixEntityManager.getExistingGroup((GroupIndex)UnixEntityManager.getGroupIndex(), (int)UnixEntityManager.getExistingUser((PasswdIndex)UnixEntityManager.getPasswdIndex(), (String)username).gid).groupname;
    }

    public static int getUserDefaultGroupGid(String username) throws UserDoesnotExistException, FileNotFoundException, IOException {
        return UnixEntityManager.getExistingUser((PasswdIndex)UnixEntityManager.getPasswdIndex(), (String)username).gid;
    }

    public static class GroupIndex {
        public Map<String, struct_group> byGroupname = new HashMap<String, struct_group>();
        public Map<Integer, struct_group> byGid = new HashMap<Integer, struct_group>();

        public static GroupIndex parseAndIndexAll(String[] lines) {
            GroupIndex ret = new GroupIndex();
            for (String s : lines) {
                struct_group g;
                if (null == s || null == (g = struct_group.parseLineSafe(s))) continue;
                ret.byGroupname.put(g.groupname, g);
                ret.byGid.put(g.gid, g);
            }
            return ret;
        }

        public static GroupIndex parseAndIndexGroupFile(String file) throws FileNotFoundException, IOException {
            String[] lines = RegexTools.LINUX_NEW_LINE.split(IOTools.getFileContents((String)file));
            return GroupIndex.parseAndIndexAll(lines);
        }
    }

    public static class struct_group {
        public String groupname;
        public int gid;
        public HashSet<String> users = new HashSet();

        @MayNotNull
        public static struct_group parseLine(String line) {
            String[] data = RegexTools.COLON.split(line);
            struct_group ret = new struct_group();
            ret.groupname = data[0];
            ret.gid = Integer.parseInt(data[2]);
            if (data.length > 3) {
                CollectionTools.copyInto((Object[])RegexTools.COMMA.split(data[3]), ret.users);
            }
            return ret;
        }

        @MayNull
        public static struct_group parseLineSafe(String line) {
            try {
                return struct_group.parseLine(line);
            }
            catch (Throwable t) {
                LoggingTools.tryLogFormatException((Logger)LOG, (LoggingDetailLevel)LogLevel.WARNING, (Throwable)t, (String)"Can't parse group line: %s", (Object)line);
                return null;
            }
        }
    }

    public static class PasswdIndex {
        public Map<String, struct_passwd> byUsername = new HashMap<String, struct_passwd>();
        public Map<Integer, struct_passwd> byUid = new HashMap<Integer, struct_passwd>();

        public static PasswdIndex parseAndIndexAll(String[] lines) {
            PasswdIndex ret = new PasswdIndex();
            for (String s : lines) {
                struct_passwd p;
                if (null == s || null == (p = struct_passwd.parseLineSafe(s))) continue;
                ret.byUsername.put(p.username, p);
                ret.byUid.put(p.uid, p);
            }
            return ret;
        }

        public static PasswdIndex parseAndIndexPasswdFile(String file) throws FileNotFoundException, IOException {
            String[] lines = RegexTools.LINUX_NEW_LINE.split(IOTools.getFileContents((String)file));
            return PasswdIndex.parseAndIndexAll(lines);
        }
    }

    public static class struct_passwd {
        public String username;
        public int uid;
        public int gid;
        public String etcData;
        public String homeDir;
        public String shell;

        @MayNotNull
        public static struct_passwd parseLine(String line) {
            String[] data = RegexTools.COLON.split(line);
            struct_passwd ret = new struct_passwd();
            ret.username = data[0];
            ret.uid = Integer.parseInt(data[2]);
            ret.gid = Integer.parseInt(data[3]);
            ret.etcData = data[4];
            ret.homeDir = data[5];
            ret.shell = data[6];
            return ret;
        }

        @MayNull
        public static struct_passwd parseLineSafe(String line) {
            try {
                return struct_passwd.parseLine(line);
            }
            catch (Throwable t) {
                LoggingTools.tryLogFormatException((Logger)LOG, (LoggingDetailLevel)LogLevel.WARNING, (Throwable)t, (String)"Can't parse passwd line: %s", (Object)line);
                return null;
            }
        }
    }
}

