/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.unix.user;

import eu.javaexperience.unix.user.UnixEntityManager;
import eu.javaexperience.unix.user.UnixGroupEntity;
import eu.javaexperience.unix.user.UnixUserEntity;
import eu.javaexperience.unix.user.exception.GroupDoesnotExistException;
import java.io.IOException;

public class UnixGroup
implements UnixGroupEntity {
    protected final String gropuname;
    protected final int gid;

    public static UnixGroup getInstanceByName(String name) throws GroupDoesnotExistException, IOException {
        return new UnixGroup(name, UnixEntityManager.gidByGroupname(name));
    }

    public static UnixGroup getInstanceByGid(int gid) throws GroupDoesnotExistException, IOException {
        return new UnixGroup(UnixEntityManager.groupnameByGID(gid), gid);
    }

    public UnixGroup(String grpname, int gid) {
        this.gropuname = grpname;
        this.gid = gid;
    }

    @Override
    public String getName() {
        return this.gropuname;
    }

    @Override
    public String getGroupname() {
        return this.gropuname;
    }

    @Override
    public int getGid() {
        return this.gid;
    }

    @Override
    public String toString() {
        return "UnixGroup: " + this.gropuname;
    }

    @Override
    public UnixUserEntity[] getUsers() {
        return null;
    }
}

