#include <pty.h>
#include <stdlib.h>
#include <stdio.h>
#include <sys/un.h>
#include <utmp.h>
#include <cstring>
#include <termio.h>
#include <iostream>
#include <unistd.h>
#include <sys/types.h>
#include <signal.h>
#include <unistd.h>
#include <pty.h>
#include <jni.h>
#include <sys/wait.h>
#include <sys/socket.h>
#include <sys/stat.h>
#include <poll.h>
#include <sys/mman.h>
#include <fcntl.h>
#include <cerrno>
#include <unistd.h>
#include <fcntl.h>
#include <stdio.h>
#include <sched.h>
#include <sys/io.h>
#include <sys/sendfile.h>
#include <dlfcn.h>

extern "C"
{
	static jfieldID	inp;	//INTEGER
	static jfieldID	chp;	//STRING
	static jfieldID pointer; //VOID (long)

	JNIEXPORT void JNICALL Java_eu_javaexperience_nativ_posix_Posix_initNative(JNIEnv * env,jobject obj)
	{
		jclass cls;

		cls = env->FindClass("eu/javaexperience/nativ/posix/STRING");
		if(cls == NULL)
				return env->FatalError("eu/javaexperience/nativ/posix/STRING osztály nem található");

		chp = env->GetFieldID(cls, "value", "Ljava/lang/String;");

		cls = env->FindClass("eu/javaexperience/nativ/posix/INTEGER");
		if(cls == NULL)
			return env->FatalError("eu/javaexperience/nativ/posix/INTEGER osztály nem található");

		inp = env->GetFieldID(cls, "value", "I");
			

		cls = env->FindClass("eu/javaexperience/nativ/posix/VOID");
		if(cls == NULL)
			return env->FatalError("eu/javaexperience/nativ/posix/VOID osztály nem található");

		pointer = env->GetFieldID(cls, "value", "J");
	}
	

	JNIEXPORT jstring JNICALL Java_eu_javaexperience_nativ_posix_Posix_canonicalFilename(JNIEnv * env,jobject obj,jstring file)//TODO memleak?
	{
		return env->NewStringUTF(canonicalize_file_name(env->GetStringUTFChars(file,NULL)));
	}

	JNIEXPORT void JNICALL Java_eu_javaexperience_nativ_posix_Posix_pause(JNIEnv * env,jobject obj)
	{
		pause();
	}

	JNIEXPORT JNICALL int Java_eu_javaexperience_nativ_posix_Posix_kill(JNIEnv * env,jobject obj,jint pid, jint signal)
	{
		return	kill(pid,signal);
	}

	JNIEXPORT int JNICALL Java_eu_javaexperience_nativ_posix_Posix_forkpty(JNIEnv * env,jobject obj,jobject fd,jobject path,long termios,long winp)
	{
		int num = 0;
		char* name = (char*) malloc(100);
		int retval = forkpty(&num, name, (const struct termios*) termios, (const struct winsize*)winp);

		env->SetIntField(fd,inp,num);

		env->SetObjectField(path,chp, (jobject) env->NewStringUTF(name));

		free(name);

		return retval;
	}

	JNIEXPORT jint JNICALL Java_eu_javaexperience_nativ_posix_Posix_openpty(JNIEnv * env,jobject obj,jobject fdmaster,jobject fdslave,jobject path,long termios,long winp)
	{
		int master = 0;
		int slave = 0;
		char* name = (char*) malloc(100);
		jint retval = (jint) openpty(&master, &slave, name, (const struct termios*)termios, (const struct winsize*) winp);

		env->SetIntField(fdmaster, inp, master);
		env->SetIntField(fdslave, inp, slave);
		env->SetObjectField(path,chp, (jobject) env->NewStringUTF(name));

		free(name);
		return retval;
	}

	JNIEXPORT int JNICALL Java_eu_javaexperience_nativ_posix_Posix_loginTTY(JNIEnv * env,jobject obj,int fd)
	{
		return login_tty(fd);
	}

	JNIEXPORT int JNICALL Java_eu_javaexperience_nativ_posix_Posix_execv(JNIEnv * env,jobject obj,jstring path,jobjectArray jargs)
	{
		int stringCount = env->GetArrayLength(jargs);
		char** arg = (char**)malloc(stringCount+1);
		char* cmd = (char*) env->GetStringUTFChars(path, 0);

		for (int i=0; i<stringCount; i++)
		{
			jstring string = (jstring) env->GetObjectArrayElement(jargs, i);
			const char *rawString = env->GetStringUTFChars(string, 0);
			arg[i] = (char*) rawString;
		}

		arg[stringCount] = (char*)NULL;

		int retval = execv(cmd,arg);

		env->ReleaseStringUTFChars( path, cmd);
		for (int i=0; i<stringCount; i++)
			env->ReleaseStringUTFChars((jstring)env->GetObjectArrayElement(jargs, i), arg[i]);

		//free(cmd);

		return retval;
	}

	JNIEXPORT int JNICALL Java_eu_javaexperience_nativ_posix_Posix_waitpid(JNIEnv * env,jobject obj,jint pid,jobject retval)
	{
		int status = -1;
		int ret = waitpid((int)pid,&status,0);
		env->SetIntField(retval,inp,status);
		return ret;
	}

	JNIEXPORT jint JNICALL Java_eu_javaexperience_nativ_posix_Posix_fork(JNIEnv * env,jobject obj)
	{
		return fork();
	}

	JNIEXPORT jint JNICALL Java_eu_javaexperience_nativ_posix_Posix_socketpair(JNIEnv * env,jobject obj,jobject fd1,jobject fd2)
	{
		int pair[2];
		int ret = socketpair(PF_LOCAL, SOCK_STREAM, 0,pair);

		env->SetIntField(fd1,inp,pair[0]);
		env->SetIntField(fd2,inp,pair[1]);

		return ret;
	}

	JNIEXPORT jint JNICALL Java_eu_javaexperience_nativ_posix_Posix_dup2(JNIEnv * env,jobject obj,jobject fd1,jobject fd2)
	{
		return dup2(env->GetIntField(fd1,inp),env->GetIntField(fd2,inp));
	}

	JNIEXPORT void JNICALL Java_eu_javaexperience_nativ_posix_Posix_dup(JNIEnv * env,jobject obj,jobject fd,jobject to)
	{
		env->SetIntField(to,inp,dup(env->GetIntField(fd,inp)));
	}

	JNIEXPORT int JNICALL Java_eu_javaexperience_nativ_posix_Posix_close(JNIEnv * env,jobject obj,int fd)
	{
		return close(fd);
	}

	/*JNIEXPORT int JNICALL Java_eu_javaexperience_nativ_posix_Posix_accept(JNIEnv * env,jobject obj,int fd,jlong sp,jlong alp)
	{
		socklen_t len = alp;
		int sock = accept(fd, (struct sockaddr*) sp, &len);
		return sock;
	}*/

	JNIEXPORT jint JNICALL Java_eu_javaexperience_nativ_posix_Posix_chdir(JNIEnv * env,jobject obj,jstring utv)
	{
		char* path = (char*) env->GetStringUTFChars(utv, 0);
		int retval = chdir(path);
		env->ReleaseStringUTFChars(utv,path);
		return retval;
	}

	//TODO
	JNIEXPORT jint JNICALL Java_eu_javaexperience_nativ_posix_Posix_select(JNIEnv * env,jobject obj,jobjectArray fds,long timeout_s,long timeout_us)
	{

		int len = env->GetArrayLength(fds);
		jclass cls = env->FindClass("java/io/FileDescriptor");
		jfieldID fid = env->GetFieldID(cls, "fd", "I");
		fd_set watch;

		FD_ZERO(&watch);

		int buf = 0;
		int max = 0;

		for(int i=0;i <  len;i++)
		{
			FD_SET( buf=(int) env->GetIntField(env->GetObjectArrayElement(fds, i),fid),&watch);
			if(buf>max)
				max = buf;
		}

		struct timeval timeout;
		timeout.tv_sec = timeout_s;
		timeout.tv_usec = timeout_us;
		int retval = select(max+1, &watch, NULL,NULL,&timeout);
		return retval;
	}

	//TODO
	JNIEXPORT jint JNICALL Java_eu_javaexperience_nativ_posix_Posix_poll(JNIEnv * env,jobject obj,jlongArray pollfds,int timeout_ms)
	{
		int nfds = env->GetArrayLength(pollfds);

		jlong* pointerfor = (jlong*) malloc(nfds*(sizeof(void*)));

		env->GetLongArrayRegion(pollfds,0,nfds, pointerfor);

		int retval = poll( ((struct pollfd*)pointerfor), nfds,timeout_ms);
		free(pointerfor);
		return retval;
	}

	//TODO
	JNIEXPORT jlong JNICALL Java_eu_javaexperience_nativ_posix_Posix_pollfd(JNIEnv * env,jobject obj,jobject fd,jshort events,jshort revents)
	{
		jclass cls = env->FindClass("java/io/FileDescriptor");
		jfieldID fid = env->GetFieldID(cls, "fd", "I");

		struct pollfd *pfd = (pollfd*) malloc(sizeof( pollfd));
			pfd->fd = env->GetIntField(fd,fid);
			pfd->events = events;
			pfd->revents = 0x0;

		return (jlong) pfd;
	}

	//TODO
	JNIEXPORT jint JNICALL Java_eu_javaexperience_nativ_posix_Posix_pollfdfd(JNIEnv * env,jobject obj,jlong pfd_struct)
	{
		return ((struct pollfd*)pfd_struct)->fd;
	}

	//TODO
	JNIEXPORT jshort JNICALL Java_eu_javaexperience_nativ_posix_Posix_pollfdevents(JNIEnv * env,jobject obj,jlong pfd_struct)
	{
		return ((struct pollfd*)pfd_struct)->events;
	}

	//TODO
	JNIEXPORT jshort JNICALL Java_eu_javaexperience_nativ_posix_Posix_pollfdrevents(JNIEnv * env,jobject obj,jlong pfd_struct)
	{
		return ((struct pollfd*)pfd_struct)->revents;
	}

	JNIEXPORT void JNICALL Java_eu_javaexperience_nativ_posix_Posix_free(JNIEnv * env,jobject obj,jlong pointer)
	{
		free(((void*)pointer));
	}

	JNIEXPORT jlong JNICALL Java_eu_javaexperience_nativ_posix_Posix_mmap(JNIEnv * env,jobject obj,jlong addr,jlong length,jint prot,jint flags,int filedes,jlong offset)
	{
		return ((jlong) mmap(((void*)addr), ((size_t)length), prot,flags, filedes,offset));
	}

	JNIEXPORT jint JNICALL Java_eu_javaexperience_nativ_posix_Posix_munmap(JNIEnv * env,jobject obj,jlong addr,jlong length)
	{
		return ((jint) munmap(((void*)addr), ((size_t)length)));
	}

	JNIEXPORT jint JNICALL Java_eu_javaexperience_nativ_posix_Posix_msync(JNIEnv * env,jobject obj,jlong addr,jlong length,jint flags)
	{
		return ((jint) msync(((void*)addr), ((size_t)length),flags));
	}

	JNIEXPORT jbyte JNICALL Java_eu_javaexperience_nativ_posix_Posix_byteAt(JNIEnv * env,jobject obj,jlong pointer)
	{
		return ((jbyte) *((char*)pointer));
	}

	JNIEXPORT jlong JNICALL Java_eu_javaexperience_nativ_posix_Posix_longAt(JNIEnv * env,jobject obj,jlong pointer)
	{
		return ((jlong) *((long*)pointer));
	}

	JNIEXPORT jint JNICALL Java_eu_javaexperience_nativ_posix_Posix_intAt(JNIEnv * env,jobject obj,jlong pointer)
	{
		return ((jint) *((int*)pointer));
	}

	JNIEXPORT jlong JNICALL Java_eu_javaexperience_nativ_posix_Posix_malloc(JNIEnv * env,jobject obj,jlong size)
	{
		return ((jlong)malloc(size));
	}

	JNIEXPORT void JNICALL Java_eu_javaexperience_nativ_posix_Posix_setByteAt(JNIEnv * env,jobject obj,jlong pointer,jbyte b)
	{
		*((char*)pointer) = b;
	}

	JNIEXPORT void JNICALL Java_eu_javaexperience_nativ_posix_Posix_setLongAt(JNIEnv * env,jobject obj,jlong pointer,jlong l)
	{
		*((long*)pointer)= l;
	}

	JNIEXPORT void JNICALL Java_eu_javaexperience_nativ_posix_Posix_setIntAt(JNIEnv * env,jobject obj,jlong pointer,jint i)
	{
		*((int*)pointer) = i;
	}

	JNIEXPORT jint JNICALL Java_eu_javaexperience_nativ_posix_Posix_mprotect(JNIEnv * env,jobject obj,jlong addr,jlong size,jint prot)
	{
		return mprotect(((void*)addr),size,prot);
	}

	JNIEXPORT jlong JNICALL Java_eu_javaexperience_nativ_posix_Posix_getObjectPointer(JNIEnv * env,jobject obj,jobject point)
	{
		return ((jlong)point);
	}

	JNIEXPORT jobject JNICALL Java_eu_javaexperience_nativ_posix_Posix_getObjectAtPointer(JNIEnv * env,jobject obj,jlong point)
	{
		return ((jobject)point);
	}

	JNIEXPORT jlong JNICALL Java_eu_javaexperience_nativ_posix_Posix_splice(JNIEnv * env,jobject obj, int sfd, jlong soffset,int dfd,jlong doffset, long len,int flags)
	{
		off_t* s;
		off_t* d;
		if(soffset>-1)
			s = (off_t*)&soffset;
		else
			s = NULL;

		if(doffset>-1)
			d = (off_t*)&doffset;
		else
			d = NULL;

		return (long) splice(sfd, s, dfd, d,len,flags);
	}

	JNIEXPORT jlong JNICALL Java_eu_javaexperience_nativ_posix_Posix_sendfile(JNIEnv * env,jobject obj,int sfd,int dfd,jlong soffset, long len)
	{
		off_t* s;
		if(soffset>-1)
			s = (off_t*)&soffset;
		else
			s = NULL;

		return sendfile(sfd, dfd,s,len);
	}

	JNIEXPORT jint JNICALL Java_eu_javaexperience_nativ_posix_Posix_errno(JNIEnv * env,jobject obj)
	{
		return errno;
	}

	JNIEXPORT jlong JNICALL Java_eu_javaexperience_nativ_posix_Posix_read(JNIEnv * env,jobject obj,int fd,jlong *pointer,jlong len)
	{
		return read(fd,pointer,len);
	}

	JNIEXPORT long JNICALL Java_eu_javaexperience_nativ_posix_Posix_write(JNIEnv * env,jobject obj,int fd,jlong *pointer,jlong len)
	{
		return write(fd,pointer,len);
	}

	JNIEXPORT jint JNICALL Java_eu_javaexperience_nativ_posix_Posix_fcntl(JNIEnv * env,jobject obj,jint fd,jint cmd,jint sarg)
	{
		return fcntl(fd,cmd,sarg);
	}

	JNIEXPORT jint JNICALL Java_eu_javaexperience_nativ_posix_Posix_closen(JNIEnv * env,jobject obj,jint fd)
	{
		return close(fd);
	}

	JNIEXPORT jlong JNICALL Java_eu_javaexperience_nativ_posix_Posix_recv(JNIEnv * env,jobject obj,jint fd,jlong *pointer,jlong len,jint flags)
	{
		return recv(fd,pointer,len,flags);
	}


	JNIEXPORT jlong JNICALL Java_eu_javaexperience_nativ_posix_Posix_send(JNIEnv * env,jobject obj,jint fd,jlong *pointer,jlong len,jint flags)
	{
		return send(fd,pointer,len,flags);
	}

/*	JNIEXPORT jint JNICALL Java_eu_javaexperience_nativ_posix_Posix_mlock(JNIEnv * env,jobject obj,jint fd,jlong *pointer,jlong len,jint flags)
	{
		return send(fd,pointer,len,flags);
	}*/

	JNIEXPORT jint JNICALL Java_eu_javaexperience_nativ_posix_Posix_ioctl(JNIEnv * env,jobject obj,jint fd,jint flags,jlong *pointer)
	{
		return ioctl(fd,flags,(void*)pointer);
	}

	JNIEXPORT void JNICALL Java_eu_javaexperience_nativ_posix_Posix_jstrcpyp(JNIEnv * env,jobject obj,jstring str,jlong pointer)
	{
		const char* chrs = (char*)env->GetStringUTFChars(str, NULL );
		strcpy((char*)pointer,(char*)chrs);
		env->ReleaseStringUTFChars(str, chrs);
	}

	JNIEXPORT jlong JNICALL Java_eu_javaexperience_nativ_posix_Posix_jstrcpy(JNIEnv * env,jobject obj,jstring str)
	{
		int strlen = env->GetStringLength(str);
		void* ret = malloc(strlen+1);
		const char* chrs = (char*)env->GetStringUTFChars(str, NULL);
		strcpy((char*) ret,(char*) chrs);
		env->ReleaseStringUTFChars(str, chrs);
		return (long)ret;
	}

	JNIEXPORT jstring JNICALL Java_eu_javaexperience_nativ_posix_Posix_getCstr(JNIEnv * env,jobject obj,long *pointer)
	{
		return env->NewString((const jchar*)pointer,(jsize)strlen((char*)pointer));
	}

	JNIEXPORT jobject JNICALL Java_eu_javaexperience_nativ_posix_Posix_getCstrUTF(JNIEnv * env,jobject obj,long *pointer)
	{
		return env->NewStringUTF((const char*)pointer);
	}

	JNIEXPORT jint JNICALL Java_eu_javaexperience_nativ_posix_Posix_getuid(JNIEnv * env,jobject obj)
	{
		return getuid();
	}

	JNIEXPORT jint JNICALL Java_eu_javaexperience_nativ_posix_Posix_getgid(JNIEnv * env,jobject obj)
	{
		return getgid();
	}

	JNIEXPORT jint JNICALL Java_eu_javaexperience_nativ_posix_Posix_setuid(JNIEnv * env,jobject obj,jint uid)
	{
		return setuid(uid);
	}

	JNIEXPORT jint JNICALL Java_eu_javaexperience_nativ_posix_Posix_setgid(JNIEnv * env,jobject obj,jint gid)
	{
		return setgid(gid);
	}

	JNIEXPORT jint JNICALL Java_eu_javaexperience_nativ_posix_Posix_geteuid(JNIEnv * env,jobject obj)
	{
		return geteuid();
	}

	JNIEXPORT jint JNICALL Java_eu_javaexperience_nativ_posix_Posix_getegid(JNIEnv * env,jobject obj)
	{
		return getegid();
	}

	JNIEXPORT jint JNICALL Java_eu_javaexperience_nativ_posix_Posix_seteuid(JNIEnv * env,jobject obj,jint uid)
	{
		return seteuid(uid);
	}

	JNIEXPORT jint JNICALL Java_eu_javaexperience_nativ_posix_Posix_setegid(JNIEnv * env,jobject obj,jint gid)
	{
		return setegid(gid);
	}

	JNIEXPORT void JNICALL Java_eu_javaexperience_nativ_posix_Posix_exit(JNIEnv * env,jobject obj,jint stat)
	{
		exit(stat);
	}

	JNIEXPORT jint JNICALL Java_eu_javaexperience_nativ_posix_Posix_ftruncate(JNIEnv * env,jobject obj,jint fd,jlong len)
	{
		return ftruncate(fd,len);
	}

	JNIEXPORT jint JNICALL Java_eu_javaexperience_nativ_posix_Posix_truncate(JNIEnv * env,jobject obj,jint stat,jstring path,long len)
	{
		const jchar* chrs = (jchar*)env->GetStringUTFChars(path, NULL );
		int ret = truncate((const char*)chrs,len);
		env->ReleaseStringChars(path, chrs);
		return ret;
	}

	JNIEXPORT jint JNICALL Java_eu_javaexperience_nativ_posix_Posix_open(JNIEnv * env,jobject obj,jstring path,int flags)
	{
		const jchar* chrs = (jchar*)env->GetStringUTFChars(path, NULL );
		int ret = open((const char*)chrs,flags);
		env->ReleaseStringChars(path, chrs);
		return ret;
	}

	JNIEXPORT jint JNICALL Java_eu_javaexperience_nativ_posix_Posix_openm(JNIEnv * env,jobject obj,jstring path,int flags,int mode)
	{
		const jchar* chrs = (jchar*)env->GetStringUTFChars(path, NULL );
		int ret = open((const char*)chrs, flags,(mode_t)mode);
		env->ReleaseStringChars(path, chrs);
		return ret;
	}

	JNIEXPORT jint JNICALL Java_eu_javaexperience_nativ_posix_Posix_creat(JNIEnv * env,jobject obj,jstring path,int mode)
	{
		const jchar* chrs = (jchar*)env->GetStringUTFChars(path, NULL );
		int ret = creat((const char*)chrs, (mode_t) mode);
		env->ReleaseStringChars(path, chrs);
		return ret;
	}
	
	JNIEXPORT jint JNICALL Java_eu_javaexperience_nativ_posix_Posix_mkdir(JNIEnv * env,jobject obj,jstring path,int mode)
	{
		const jchar* chrs = (jchar*)env->GetStringUTFChars(path, NULL );
		int ret = mkdir((const char*)chrs, (mode_t) mode);
		env->ReleaseStringChars(path, chrs);
		return ret;
	}
	
	JNIEXPORT jshort JNICALL Java_eu_javaexperience_nativ_posix_Posix_shortAt(JNIEnv * env,jobject obj,long p)
	{
		return *((short*)p);
	}
	
	JNIEXPORT void JNICALL Java_eu_javaexperience_nativ_posix_Posix_setShortAt(JNIEnv * env,jobject obj,long p,jshort s)
	{
		*((short*)p) = (short) s;
	}
	
	
	JNIEXPORT jfloat JNICALL Java_eu_javaexperience_nativ_posix_Posix_floatAt(JNIEnv * env,jobject obj,long p)
	{
		return *((float*)p);
	}
	
	JNIEXPORT void JNICALL Java_eu_javaexperience_nativ_posix_Posix_setFloatAt(JNIEnv * env,jobject obj,long p,jfloat s)
	{
		*((float*)p) = s;
	}
	
	JNIEXPORT jdouble JNICALL Java_eu_javaexperience_nativ_posix_Posix_doubleAt(JNIEnv * env,jobject obj,long p)
	{
		return *((jdouble*)p);
	}
	
	JNIEXPORT void JNICALL Java_eu_javaexperience_nativ_posix_Posix_setDoubleAt(JNIEnv * env,jobject obj,long p,jdouble s)
	{
		*((jdouble*)p) = s;
	}
	
	JNIEXPORT int JNICALL Java_eu_javaexperience_nativ_posix_Posix_tcgetattr(JNIEnv * env,jobject obj,int fd,long p)
	{
		return tcgetattr(fd,(struct termios*) p);
	}

	JNIEXPORT int JNICALL Java_eu_javaexperience_nativ_posix_Posix_tcsetattr(JNIEnv * env,jobject obj,int fd,int opt,long p)
	{
		return tcsetattr(fd,opt,(const struct termios*) p);
	}

	JNIEXPORT void JNICALL Java_eu_javaexperience_nativ_posix_Posix_memcpy(JNIEnv * env,jobject obj,long d,long s,int l)
	{
		memcpy((void*)d,(void*)s,(size_t)l);
	}
	
	JNIEXPORT void JNICALL Java_eu_javaexperience_nativ_posix_Posix_memset(JNIEnv * env,jobject obj,long d,jbyte val ,int len)
	{
		memset((void*) d,(int) val,len);
	}

	JNIEXPORT int JNICALL Java_eu_javaexperience_nativ_posix_Posix_strlen(JNIEnv * env,jobject obj,long d)
	{
		return strlen((char*)d);
	}
	
	JNIEXPORT void JNICALL Java_eu_javaexperience_nativ_posix_Posix_strcpy(JNIEnv * env,jobject obj,long dest,long src)
	{
		strcpy((char*)dest,(const char*)src);
	}
	
	JNIEXPORT int JNICALL Java_eu_javaexperience_nativ_posix_Posix_cpyrange(JNIEnv * env,jobject obj,long dest,long src,int length)
	{
		char* d = (char*) dest;
		char* s = (char*) src;
		for(int i=0;i<length;i++)
			*(d+i) = *(s+i);
	}
	
	JNIEXPORT int JNICALL Java_eu_javaexperience_nativ_posix_Posix_getpid(JNIEnv * env,jobject obj)
	{
		return getpid();
	}

	JNIEXPORT int JNICALL Java_eu_javaexperience_nativ_posix_Posix_clone(JNIEnv * env,jobject obj,long startaddr,long stackpointer,int flags,long args)
	{
		return clone((int(*)(void*))startaddr,(void*)stackpointer,flags,(void*) args);
	}

	JNIEXPORT int JNICALL Java_eu_javaexperience_nativ_posix_Posix_ioperm(JNIEnv * env,jobject obj,long startaddr,int len,int turn_on)
	{
		return ioperm(startaddr,len,turn_on);
	}

	JNIEXPORT jbyte JNICALL Java_eu_javaexperience_nativ_posix_Posix_inb(JNIEnv * env,jobject obj,short addr)
	{
		return inb(addr);
	}
	
	JNIEXPORT void JNICALL Java_eu_javaexperience_nativ_posix_Posix_outb(JNIEnv * env,jobject obj,char b,short addr)
	{
		outb(b,addr);
	}
	
	#include <net/if.h>
	#include <linux/if_tun.h>

	int tun_alloc(char *dev, int flags) {
	
	  struct ifreq ifr;
	  int fd, err;
	
	  /* Arguments taken by the function:
	   *
	   * char *dev: the name of an interface (or '\0'). MUST have enough
	   *   space to hold the interface name if '\0' is passed
	   * int flags: interface flags (eg, IFF_TUN etc.)
	   */
	
	   /* open the clone device */
	   if( (fd = open("/dev/net/tun", O_RDWR)) < 0 ) {
	     return fd;
	   }
	
	   /* preparation of the struct ifr, of type "struct ifreq" */
	   memset(&ifr, 0, sizeof(ifr));
	
	   ifr.ifr_flags = flags;   /* IFF_TUN or IFF_TAP, plus maybe IFF_NO_PI */
	
	   if (*dev) {
	     /* if a device name was specified, put it in the structure; otherwise,
	      * the kernel will try to allocate the "next" device of the
	      * specified type */
	     strncpy(ifr.ifr_name, dev, IFNAMSIZ);
	   }
	
	   /* try to create the device */
	   if( (err = ioctl(fd, TUNSETIFF, (void *) &ifr)) < 0 ) {
	     close(fd);
	     return err;
	   }
	
	  /* if the operation was successful, write back the name of the
	   * interface to the variable "dev", so the caller can know
	   * it. Note that the caller MUST reserve space in *dev (see calling
	   * code below) */
	  strcpy(dev, ifr.ifr_name);
	
	  /* this is the special file descriptor that the caller will use to talk
	   * with the virtual interface */
	  return fd;
	}

	JNIEXPORT int JNICALL Java_eu_javaexperience_nativ_posix_Posix_tunalloc(JNIEnv * env,jobject thi,jstring name,int flag)
	{
		char* chrs = (char*)env->GetStringUTFChars(name, NULL );
		int ret = tun_alloc(chrs,flag);
		env->ReleaseStringChars(name,(jchar*) chrs);
		return ret;
	}

	JNIEXPORT int JNICALL Java_eu_javaexperience_nativ_posix_Posix_socket(JNIEnv * env,jobject thi, int family,int type,int opts)
	{
		return socket(family,type,opts);
	}
	
	JNIEXPORT int JNICALL Java_eu_javaexperience_nativ_posix_Posix_bind(JNIEnv * env,jobject thi, int fd,long addr,int size)
	{
		return bind(fd, (struct sockaddr *)addr, size);
	}
	
	JNIEXPORT int JNICALL Java_eu_javaexperience_nativ_posix_Posix_connect(JNIEnv * env,jobject thi, int fd,long addr,int size)
	{
		return connect(fd, (struct sockaddr *)addr, size);
	}

	JNIEXPORT int JNICALL Java_eu_javaexperience_nativ_posix_Posix_listen(JNIEnv * env,jobject thi, int fd, int backlog)
	{
		return listen(fd, backlog);
	}

	JNIEXPORT int JNICALL Java_eu_javaexperience_nativ_posix_Posix_accept(JNIEnv * env,jobject thi, int fd,long addr,jlong size)
	{
		return accept(fd, (struct sockaddr *)addr, (socklen_t*) size);
	}

	JNIEXPORT int JNICALL Java_eu_javaexperience_nativ_posix_Posix_accept4(JNIEnv * env,jobject thi, int fd,long addr,jlong size, int flags)
	{
		return accept4(fd, (struct sockaddr *)addr, (socklen_t*) size, flags);
	}

	JNIEXPORT int JNICALL Java_eu_javaexperience_nativ_posix_Posix_shutdown(JNIEnv * env,jobject thi, jint fd, jint how)
	{
		return shutdown(fd, how);
	}

	JNIEXPORT int JNICALL Java_eu_javaexperience_nativ_posix_Posix_setsockopt(JNIEnv * env,jobject thi,int socket, int level, int option_name,long option_value, int option_len)
	{
		return setsockopt(socket, level, option_name, (void*) option_value, option_len);
	}

	JNIEXPORT int JNICALL Java_eu_javaexperience_nativ_posix_Posix_fsync(JNIEnv * env,jobject thi,int fd)
	{
		return fsync(fd);
	}

	JNIEXPORT int JNICALL Java_eu_javaexperience_nativ_posix_Posix_fdatasync(JNIEnv * env,jobject thi,int fd)
	{
		return fdatasync(fd);
	}

	JNIEXPORT int JNICALL Java_eu_javaexperience_nativ_posix_Posix_getpeername(JNIEnv * env,jobject thi,jint fd, jlong addrPtr, jlong sockLen)
	{
		return getpeername(fd, (struct sockaddr *)addrPtr, (socklen_t*) sockLen);
	}

	JNIEXPORT int JNICALL Java_eu_javaexperience_nativ_posix_Posix_tcflush(JNIEnv * env,jobject thi,jint fd, jint asd)
	{
		return tcflush(fd, asd);
	}

	JNIEXPORT int JNICALL Java_eu_javaexperience_nativ_posix_Posix_tcdrain(JNIEnv * env,jobject thi,jint fd)
	{
		return tcdrain(fd);
	}

	JNIEXPORT long JNICALL Java_eu_javaexperience_nativ_posix_Posix_dlopen(JNIEnv * env,jobject thi,jstring file, int flags)
	{
		if(NULL == file)
		{
			return 0;
		}

		const char* f = env->GetStringUTFChars(file, NULL);
		void* ret = dlopen(f, flags);
		if(NULL == ret)
		{
			printf("dlopen error: %s\n", dlerror());
			fsync(1);
		}
		env->ReleaseStringUTFChars(file, f);

		return (long) ret;
	}

	JNIEXPORT jstring JNICALL Java_eu_javaexperience_nativ_posix_Posix_dlerror(JNIEnv * env,jobject thi)
	{
		const char* ret = dlerror();
		if(NULL == ret)
		{
			return NULL;
		}

		return env->NewStringUTF(ret);
	}

	JNIEXPORT long JNICALL Java_eu_javaexperience_nativ_posix_Posix_dlsym(JNIEnv * env,jobject thi, long handle, jstring symbol)
	{
		if(NULL == symbol)
		{
			return 0;
		}

		const char* sym = env->GetStringUTFChars(symbol, NULL);
		void* ret = dlsym((void*) handle, sym);
		env->ReleaseStringUTFChars(symbol, sym);

		return (long) ret;
	}

	JNIEXPORT long JNICALL Java_eu_javaexperience_nativ_posix_Posix_dlclose(JNIEnv * env,jobject thi, long handle)
	{
		return dlclose((void*) handle);
	}

	JNIEXPORT long JNICALL Java_eu_javaexperience_nativ_posix_Posix_placeString(JNIEnv * env,jobject thi, jstring str)
	{
		if(NULL == str)
		{
			return 0;
		}

		const char* s = env->GetStringUTFChars(str, NULL);
		int len = strlen(s);
		long ret = (long) malloc(len+1);
		strcpy((char*)ret, s);
		env->ReleaseStringUTFChars(str, s);
		return ret;
	}
}
// g++ -fPIC -shared -o JUnix.amd64.so JUnix.cpp -lutil
