/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.gnu;

import eu.javaexperience.io.IOTools;
import eu.javaexperience.text.StringTools;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.URL;
import java.util.ArrayList;

public class GccTools {
    protected static final String[] emptyStringArray = new String[0];

    public static boolean loadArchDependSharedJavaLibraryOrCompileAndLoad(String searchPath, String SoStartName, String[] libs, String[] headerPaths, String[] switches, PrintStream out, PrintStream err) {
        searchPath = searchPath + "/";
        String arch = System.getProperty("os.arch");
        String file = SoStartName + "." + arch + ".so";
        String labs = new File(file).getAbsolutePath();
        boolean loaded = false;
        try {
            System.load(labs);
            loaded = true;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(searchPath + file);
            if (is != null) {
                IOTools.writeInputStreamToFile((InputStream)is, (String)file);
                System.load(labs);
                loaded = true;
            }
        }
        catch (Exception is) {
            // empty catch block
        }
        String[] dirs = System.getProperty("java.class.path").split(":");
        if (!loaded) {
            for (String dir : dirs) {
                try {
                    File f = new File(dir);
                    if (f.isDirectory()) {
                        System.load(dir + searchPath + file);
                        loaded = true;
                        break;
                    }
                    InputStream is = new URL("jar:file:" + dir + "!" + searchPath + file).openStream();
                    if (is == null) continue;
                    try {
                        IOTools.writeInputStreamToFile((InputStream)is, (String)file);
                        System.load(labs);
                        loaded = true;
                        break;
                    }
                    catch (Exception exception) {
                    }
                }
                catch (Throwable f) {
                    // empty catch block
                }
            }
        }
        if (loaded) {
            return true;
        }
        String sourceName = SoStartName + ".cpp";
        boolean sourceFile = false;
        if (!loaded) {
            try {
                InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(searchPath + sourceName);
                if (is != null) {
                    IOTools.writeInputStreamToFile((InputStream)is, (String)sourceName);
                    is.close();
                    sourceFile = true;
                }
            }
            catch (Exception is) {
                // empty catch block
            }
        }
        if (!sourceFile) {
            for (String d : dirs) {
                try {
                    FileInputStream is = new FileInputStream(d + "/" + searchPath + sourceName);
                    IOTools.writeInputStreamToFile((InputStream)is, (String)sourceName);
                    ((InputStream)is).close();
                    sourceFile = true;
                    break;
                }
                catch (Exception is) {
                }
            }
        }
        if (!sourceFile) {
            try {
                FileInputStream is = new FileInputStream(searchPath + sourceName);
                IOTools.writeInputStreamToFile((InputStream)is, (String)sourceName);
                ((InputStream)is).close();
                sourceFile = true;
            }
            catch (Exception is) {
                // empty catch block
            }
        }
        try {
            if (!loaded && sourceFile) {
                ArrayList<String> params = new ArrayList<String>();
                params.add("g++");
                params.add("-fPIC");
                params.add("-I" + GccTools.whereIsJNIandJNI_HMheaders());
                if (switches != null) {
                    for (String p : switches) {
                        params.add(p);
                    }
                }
                if (headerPaths != null) {
                    for (String p : headerPaths) {
                        params.add("-I" + p);
                    }
                }
                params.add("-shared");
                params.add("-o");
                params.add(file);
                params.add(sourceName);
                if (libs != null) {
                    for (String lib : libs) {
                        params.add("-l" + lib);
                    }
                }
                if (out != null) {
                    StringBuilder sb = new StringBuilder();
                    for (String s : params) {
                        sb.append(s);
                        sb.append(" ");
                    }
                    out.println(sb.toString());
                }
                Process process = new ProcessBuilder(params.toArray(emptyStringArray)).start();
                int ret = process.waitFor();
                if (out != null) {
                    out.write(IOTools.loadAllFromInputStream((InputStream)process.getInputStream()));
                }
                if (err != null) {
                    err.write(IOTools.loadAllFromInputStream((InputStream)process.getErrorStream()));
                }
                if (ret == 0) {
                    System.load(labs);
                    loaded = true;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return loaded;
    }

    public static String whereIsJNIandJNI_HMheaders() {
        String home = System.getProperty("java.home");
        File f = new File(home = StringTools.getSubstringBeforeLastString((String)home, (String)"/jre"));
        if (!f.isDirectory()) {
            throw new RuntimeException("Java home`" + home + "` doesn't exists");
        }
        String jni_h = home + "/include/jni.h";
        if (!new File(jni_h).exists()) {
            throw new RuntimeException("Required file: `" + jni_h + "` doesn't exists");
        }
        String jni_md_h = home + "/include/jni_md.h";
        if (!new File(jni_md_h).exists()) {
            throw new RuntimeException("Required file: `" + jni_md_h + "` doesn't exists");
        }
        return home + "/include/";
    }
}

