/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.nativ.java.socket;

import eu.javaexperience.nativ.java.JavaNativeExtension;
import eu.javaexperience.nativ.java.socket.FileDescriptorHolder;
import eu.javaexperience.nativ.posix.Posix;
import eu.javaexperience.nativ.posix.PosixErrnoException;
import java.io.IOException;
import java.io.OutputStream;

public class NativeLinuxOutputStream
extends OutputStream {
    protected FileDescriptorHolder fdh;

    public NativeLinuxOutputStream(FileDescriptorHolder fdh) {
        this.fdh = fdh;
    }

    @Override
    public void write(int i) throws IOException {
        byte[] rb = new byte[]{(byte)i};
        this.write(rb);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        int diff;
        for (int rem = len; rem > 0; rem -= diff) {
            diff = JavaNativeExtension.checkedExperimentalWrite(this.fdh.getFd(), b, off + (len - rem), rem);
            if (diff >= 0) continue;
            throw new RuntimeException(PosixErrnoException.getIfOcurred());
        }
    }

    @Override
    public void flush() throws IOException {
        Posix.fsync(this.fdh.getFd());
    }
}

