/*
 * Decompiled with CFR 0.152.
 */
package eu.linuxengineering.snmp;

import eu.javaexperience.collection.map.KeyVal;
import eu.javaexperience.interfaces.simple.getBy.GetBy1;
import eu.javaexperience.log.JavaExperienceLoggingFacility;
import eu.javaexperience.log.LogLevel;
import eu.javaexperience.log.Loggable;
import eu.javaexperience.log.LoggableUnitDescriptor;
import eu.javaexperience.log.Logger;
import eu.javaexperience.log.LoggingDetailLevel;
import eu.javaexperience.log.LoggingTools;
import eu.linuxengineering.snmp.SnmpNode;
import eu.linuxengineering.snmp.SnmpPathDispatch;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.sf.snmpadaptor4j.api.AttributeAccessor;
import net.sf.snmpadaptor4j.object.SnmpOid;

public class SnmpRequestSensitiveDispatchCollection
implements SnmpNode {
    protected static final Logger LOG = JavaExperienceLoggingFacility.getLogger((LoggableUnitDescriptor)new Loggable("SnmpRequestSensitiveDispatchCollection"));
    protected ConcurrentMap<SnmpOid, Map.Entry<Integer, SnmpNode>> nodeCache = new ConcurrentHashMap<SnmpOid, Map.Entry<Integer, SnmpNode>>();
    protected NavigableMap<Integer, GetBy1<SnmpNode, SnmpOid>> nodeFactories = Collections.synchronizedNavigableMap(new TreeMap());

    public void addNodeFactory(Integer index, GetBy1<SnmpNode, SnmpOid> factory) {
        this.nodeFactories.put(index, factory);
    }

    public void addNodeFactory(Integer index, SnmpNode node) {
        this.nodeFactories.put(index, (GetBy1<SnmpNode, SnmpOid>)((GetBy1)a -> node));
    }

    @Override
    public Map.Entry<Integer, SnmpNode> getSubNodeGte(SnmpPathDispatch dispatch) {
        SnmpOid oid = SnmpOid.newInstance((int[])dispatch.copyCurrentPath());
        dispatch.jumpNextNode();
        Map.Entry ret = (Map.Entry)this.nodeCache.get(oid);
        if (oid.toString().endsWith(".1.25.50.0.0.-1")) {
            System.out.println();
        }
        if (null == ret) {
            int[] roid = oid.getOid();
            Integer index = (roid = Arrays.copyOf(roid, roid.length))[roid.length - 1];
            Map.Entry<Integer, GetBy1<SnmpNode, SnmpOid>> creEnt = this.nodeFactories.ceilingEntry(index);
            if (null == creEnt) {
                LoggingTools.tryLogFormat((Logger)LOG, (LoggingDetailLevel)LogLevel.TRACE, (String)"Requesting oid `%s` returns: null", (Object)oid);
                return null;
            }
            int dst = creEnt.getKey();
            roid[roid.length - 1] = creEnt.getKey();
            SnmpOid actOid = SnmpOid.newInstance((int[])roid);
            KeyVal add = new KeyVal((Object)creEnt.getKey(), creEnt.getValue().getBy((Object)actOid));
            int i = index;
            while (i <= dst) {
                roid[roid.length - 1] = i++;
                this.nodeCache.put(SnmpOid.newInstance((int[])Arrays.copyOf(roid, roid.length)), (Map.Entry<Integer, SnmpNode>)add);
            }
            ret = add;
        }
        LoggingTools.tryLogFormat((Logger)LOG, (LoggingDetailLevel)LogLevel.TRACE, (String)"Requesting oid `%s` returns: `%s`", (Object)oid, ret.getValue());
        return ret;
    }

    @Override
    public boolean hasSubNodes() {
        return true;
    }

    @Override
    public AttributeAccessor getAccessor() {
        return null;
    }
}

