/*
 * Decompiled with CFR 0.152.
 */
package eu.linuxengineering.snmp;

import eu.javaexperience.interfaces.simple.SimpleGet;
import eu.javaexperience.interfaces.simple.getBy.GetBy1;
import eu.javaexperience.log.JavaExperienceLoggingFacility;
import eu.javaexperience.log.LogLevel;
import eu.javaexperience.log.Loggable;
import eu.javaexperience.log.LoggableUnitDescriptor;
import eu.javaexperience.log.Logger;
import eu.javaexperience.log.LoggingDetailLevel;
import eu.javaexperience.log.LoggingTools;
import eu.javaexperience.reflect.Mirror;
import eu.javaexperience.reflect.PrimitiveTools;
import eu.javaexperience.text.StringTools;
import eu.linuxengineering.snmp.SnmpDispatchNode;
import eu.linuxengineering.snmp.SnmpFinalNode;
import eu.linuxengineering.snmp.SnmpMibDispatch;
import eu.linuxengineering.snmp.SnmpNode;
import eu.linuxengineering.snmp.SnmpPathDispatch;
import eu.linuxengineering.snmp.SnmpProxyNode;
import eu.linuxengineering.snmp.SnmpRequestSensitiveDispatchCollection;
import eu.linuxengineering.snmp.annotations.SnmpIndex;
import eu.linuxengineering.snmp.annotations.SnmpNodeDetails;
import eu.linuxengineering.snmp.annotations.SnmpSubnode;
import eu.linuxengineering.snmp.nodes.SnmpNodeType;
import eu.linuxengineering.snmp.nodes.SnmpReflectFields;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import net.sf.snmpadaptor4j.api.AttributeAccessor;
import net.sf.snmpadaptor4j.object.SnmpDataType;
import net.sf.snmpadaptor4j.object.SnmpOid;

public class SnmpTools {
    protected static final Logger LOG = JavaExperienceLoggingFacility.getLogger((LoggableUnitDescriptor)new Loggable("SnmpTools"));
    public static final Mirror.MethodSelector SELECT_ALL_PUBLIC_INSTANCE_METHOD = new Mirror.MethodSelector(true, Mirror.Visibility.Public, Mirror.BelongTo.Instance, Mirror.Select.IsNot, Mirror.Select.All, Mirror.Select.All, Mirror.Select.All, Mirror.Select.All);

    private SnmpTools() {
    }

    public static SnmpDispatchNode ensurePath(SnmpDispatchNode from, int[] path) {
        for (int i = 0; i < path.length; ++i) {
            SnmpNode node = from.subNodes.get(path[i]);
            if (null == node) {
                SnmpDispatchNode tmp = new SnmpDispatchNode();
                from.addEntry(path[i], tmp);
                node = tmp;
            }
            if (!(node instanceof SnmpDispatchNode)) {
                throw new RuntimeException("A non SnmpDispatchNode node already present in path `" + Arrays.toString(path) + " at " + i + " " + node);
            }
            from = (SnmpDispatchNode)node;
        }
        return from;
    }

    public static void addToPath(SnmpDispatchNode from, int[] path, SnmpNode node, boolean forceOverride) {
        SnmpDispatchNode to = SnmpTools.ensurePath(from, Arrays.copyOf(path, path.length - 1));
        Integer tar = path[path.length - 1];
        if (to.subNodes.containsKey(tar) && !forceOverride) {
            throw new RuntimeException("Node at path " + Arrays.toString(path) + " already exists: " + to.subNodes.get(tar));
        }
        to.addEntry(tar, node);
    }

    public static AttributeAccessor createReadOnlyAttributeAccessor(final SnmpOid id, final SnmpDataType type, final SimpleGet<?> source) {
        return new AttributeAccessor(){

            public void setValue(Object value) throws Exception {
            }

            public boolean isWritable() {
                return false;
            }

            public boolean isReadable() {
                return true;
            }

            public Object getValue() throws Exception {
                return source.get();
            }

            public SnmpDataType getSnmpDataType() {
                return type;
            }

            public SnmpOid getOid() {
                return id;
            }

            public Class<?> getJmxDataType() {
                return null;
            }
        };
    }

    public static SnmpFinalNode addRoAccessorToPath(SnmpDispatchNode root, int[] id, SnmpDataType type, SimpleGet<Object> getter, boolean forceOverride) {
        SnmpOid oid = SnmpOid.newInstance((int[])id);
        SnmpFinalNode ret = new SnmpFinalNode(SnmpTools.createReadOnlyAttributeAccessor(oid, type, getter));
        SnmpTools.addToPath(root, id, ret, forceOverride);
        return ret;
    }

    public static SnmpFinalNode createFinalNode(SnmpOid oid, SnmpDataType type, SimpleGet<?> getter) {
        return new SnmpFinalNode(SnmpTools.createReadOnlyAttributeAccessor(oid, type, getter));
    }

    public static SnmpNode addSnmpObjectToPath(SnmpMibDispatch root, int[] path, Object node, boolean forceOverride) {
        SnmpNode add = SnmpTools.wrapSnmpObject(node);
        SnmpTools.addToPath(root, path, add, forceOverride);
        return add;
    }

    public static SnmpDataType recogniseSnmpDataType(Class cls) {
        if (String.class == (cls = PrimitiveTools.toObjectClassType((Class)cls, (Class)cls))) {
            return SnmpDataType.octetString;
        }
        if (Boolean.class == cls || Byte.class == cls || Character.class == cls || Short.class == cls || Integer.class == cls) {
            return SnmpDataType.integer32;
        }
        if (Long.class == cls) {
            return SnmpDataType.counter64;
        }
        if (SnmpOid.class == cls) {
            return SnmpDataType.objectIdentifier;
        }
        return null;
    }

    protected static SnmpNode createReflectNode(String name, String description, SnmpNodeType type, SimpleGet<Integer> itemsCount) {
        SnmpRequestSensitiveDispatchCollection ret = new SnmpRequestSensitiveDispatchCollection();
        if (!StringTools.isNullOrTrimEmpty((String)name)) {
            ret.addNodeFactory((Integer)1, (GetBy1<SnmpNode, SnmpOid>)((GetBy1)oid -> SnmpTools.createFinalNode(oid, SnmpDataType.octetString, () -> name)));
        }
        if (!StringTools.isNullOrTrimEmpty((String)description)) {
            ret.addNodeFactory((Integer)2, (GetBy1<SnmpNode, SnmpOid>)((GetBy1)oid -> SnmpTools.createFinalNode(oid, SnmpDataType.octetString, () -> description)));
        }
        ret.addNodeFactory((Integer)3, (GetBy1<SnmpNode, SnmpOid>)((GetBy1)oid -> SnmpTools.createFinalNode(oid, SnmpDataType.octetString, () -> type.name())));
        ret.addNodeFactory((Integer)4, (GetBy1<SnmpNode, SnmpOid>)((GetBy1)oid -> SnmpTools.createFinalNode(oid, SnmpDataType.integer32, itemsCount)));
        return ret;
    }

    protected static SnmpNode wrapConstant(SimpleGet<Object> source, String name, String description) {
        return new SnmpNode(){

            @Override
            public boolean hasSubNodes() {
                return false;
            }

            @Override
            public Map.Entry<Integer, SnmpNode> getSubNodeGte(SnmpPathDispatch index) {
                return null;
            }

            @Override
            public AttributeAccessor getAccessor() {
                return null;
            }
        };
    }

    protected static SnmpNode wrapCollectionReturning(final Object node, final Method m) {
        return new SnmpProxyNode(){
            protected Collection prev;

            @Override
            public synchronized void beforeAccess() {
                try {
                    Collection now = (Collection)m.invoke(node, new Object[0]);
                    if (null == this.original || !Mirror.equals((Object)this.prev, (Object)now)) {
                        SnmpRequestSensitiveDispatchCollection ret = new SnmpRequestSensitiveDispatchCollection();
                        SnmpNodeDetails info = m.getAnnotation(SnmpNodeDetails.class);
                        ret.addNodeFactory((Integer)0, SnmpTools.createReflectNode(null == info ? null : info.name(), null == info ? null : info.description(), SnmpNodeType.ENUMERATION, (SimpleGet<Integer>)((SimpleGet)() -> now.size())));
                        int i = 0;
                        for (Object o : now) {
                            ret.addNodeFactory((Integer)(++i), SnmpTools.wrapSnmpObject(o));
                        }
                        this.original = ret;
                    }
                }
                catch (Exception e) {
                    Mirror.propagateAnyway((Throwable)e);
                }
            }
        };
    }

    public static SnmpNode wrapSnmpObject(Object node) {
        if (node instanceof SnmpNode) {
            return (SnmpNode)node;
        }
        return SnmpTools.wrapSnmpBeam(node);
    }

    public static SnmpNode wrapSnmpBeam(final Object node) {
        Mirror.ClassData cd = Mirror.getClassData(node.getClass());
        Method[] methods = cd.select(SELECT_ALL_PUBLIC_INSTANCE_METHOD);
        SnmpRequestSensitiveDispatchCollection ret = new SnmpRequestSensitiveDispatchCollection();
        int[] itemsCount = new int[]{0};
        if (node instanceof SnmpReflectFields) {
            SnmpReflectFields details = (SnmpReflectFields)node;
            SnmpNode cre = SnmpTools.createReflectNode(details.getName(), details.getDescription(), SnmpNodeType.COLLECTION, (SimpleGet<Integer>)((SimpleGet)() -> itemsCount[0]));
            ret.addNodeFactory((Integer)0, cre);
        }
        for (final Method m : methods) {
            boolean subnode;
            SnmpIndex index;
            if (0 != m.getParameters().length || null == (index = m.getAnnotation(SnmpIndex.class))) continue;
            Class<?> retType = m.getReturnType();
            SnmpDataType type = SnmpTools.recogniseSnmpDataType(retType);
            SnmpNodeType nodeType = SnmpNodeType.EXACT_VALUE;
            SimpleGet nodeItemCount = () -> 1;
            GetBy1 getter = null;
            if (Collection.class.isAssignableFrom(retType)) {
                ret.addNodeFactory((Integer)index.index(), SnmpTools.wrapCollectionReturning(node, m));
                itemsCount[0] = itemsCount[0] + 1;
                continue;
            }
            getter = null == type ? f -> new SnmpProxyNode(){
                protected Object prev;

                @Override
                public void beforeAccess() {
                    Object now = null;
                    try {
                        now = m.invoke(node, new Object[0]);
                    }
                    catch (Exception e) {
                        Mirror.propagateAnyway((Throwable)e);
                    }
                    if (null == this.original || !Mirror.equals((Object)this.prev, (Object)now)) {
                        this.original = SnmpTools.wrapSnmpObject(now);
                    }
                }
            } : oid -> SnmpFinalNode.wrap(oid, type, () -> {
                try {
                    return m.invoke(node, new Object[0]);
                }
                catch (Exception e) {
                    LoggingTools.tryLogFormatException((Logger)LOG, (LoggingDetailLevel)LogLevel.ERROR, (Throwable)e, (String)"Exception while invoking method `%s` on `%s`", (Object)m, (Object)node);
                    Mirror.propagateAnyway((Throwable)e);
                    return null;
                }
            });
            if (null == getter) continue;
            itemsCount[0] = itemsCount[0] + 1;
            boolean bl = subnode = null != m.getAnnotation(SnmpSubnode.class);
            if (subnode) {
                SnmpRequestSensitiveDispatchCollection add = new SnmpRequestSensitiveDispatchCollection();
                SnmpNodeDetails info = m.getAnnotation(SnmpNodeDetails.class);
                if (null != info) {
                    add.addNodeFactory((Integer)0, SnmpTools.createReflectNode(info.name(), info.description(), nodeType, (SimpleGet<Integer>)nodeItemCount));
                }
                add.addNodeFactory((Integer)1, (GetBy1<SnmpNode, SnmpOid>)getter);
                ret.addNodeFactory((Integer)index.index(), add);
                continue;
            }
            ret.addNodeFactory((Integer)index.index(), (GetBy1<SnmpNode, SnmpOid>)getter);
        }
        return ret;
    }
}

