package eu.linuxengineering.snmp;

import java.util.Map.Entry;

import eu.javaexperience.interfaces.simple.SimpleGet;
import net.sf.snmpadaptor4j.api.AttributeAccessor;
import net.sf.snmpadaptor4j.object.SnmpDataType;
import net.sf.snmpadaptor4j.object.SnmpOid;

public class SnmpFinalNode implements SnmpNode
{
	protected AttributeAccessor accessor;
	
	public SnmpFinalNode(AttributeAccessor accessor)
	{
		this.accessor = accessor;
	}
	
	@Override
	public boolean hasSubNodes()
	{
		return false;
	}

	@Override
	public Entry<Integer, SnmpNode> getSubNodeGte(SnmpPathDispatch index)
	{
		return null;
	}

	@Override
	public AttributeAccessor getAccessor()
	{
		return accessor;
	}
	
	public static SnmpFinalNode wrap(AttributeAccessor accessor) 
	{
		return new SnmpFinalNode(accessor);
	}
	
	@Override
	public String toString()
	{
		return "SnmpFinalNode: "+accessor.getOid();
	}
	
	public static SnmpFinalNode wrap(SnmpOid id, SnmpDataType type, SimpleGet<?> source)
	{
		return new SnmpFinalNode(SnmpTools.createReadOnlyAttributeAccessor(id, type, source));
	}
}
