/*
 * Decompiled with CFR 0.152.
 */
package eu.linuxengineering.snmp;

import eu.javaexperience.parse.ParsePrimitive;
import eu.javaexperience.regex.RegexTools;
import java.util.Arrays;
import net.sf.snmpadaptor4j.object.SnmpOid;

public class SnmpRelativeOid {
    protected int[] path;
    public static final int PATH_FROM_ROOT = -3;
    public static final int PATH_CURRENT_ELEMENT = -2;
    public static final int PATH_BACKWARD = -1;

    public SnmpRelativeOid(int[] path) {
        this.path = path;
    }

    public int[] getPathComponents() {
        return this.path;
    }

    public SnmpOid resolve(SnmpOid oid) {
        if (this.isStatic()) {
            return SnmpOid.newInstance((int[])Arrays.copyOfRange(this.path, 1, this.path.length));
        }
        int[] p = oid.getOid();
        int ep = p.length;
        p = Arrays.copyOf(p, ep + this.path.length);
        for (int i = 0; i < this.path.length; ++i) {
            int el = this.path[i];
            if (-2 == el) continue;
            if (-1 == el) {
                --ep;
                continue;
            }
            p[ep++] = el;
        }
        return SnmpOid.newInstance((int[])Arrays.copyOf(p, ep));
    }

    public boolean isStatic() {
        if (this.path[0] != -3) {
            return false;
        }
        for (int i = 0; i < this.path.length; ++i) {
            if (this.path[i] != -1) continue;
            return false;
        }
        return true;
    }

    public static int[] parseAsFilePathExpression(String path) {
        if ("/".equals(path = path.trim())) {
            return new int[]{-3};
        }
        String[] components = RegexTools.SLASHES.split(path);
        int[] ret = new int[components.length + 1];
        int ep = 0;
        for (int i = 0; i < components.length; ++i) {
            String comp = components[i];
            if (0 == i && "".equals(comp)) {
                ret[ep++] = -3;
                continue;
            }
            if (".".equals(comp)) {
                if (0 != i) continue;
                ret[ep++] = -2;
                continue;
            }
            if ("..".equals(comp)) {
                if (ep > 0) {
                    if (-3 == ret[ep - 1]) continue;
                    if (ret[ep - 1] >= 0) {
                        --ep;
                        continue;
                    }
                    if (ret[ep - 1] == -2) {
                        // empty if block
                    }
                }
                int n = --ep;
                ++ep;
                ret[n] = -1;
                continue;
            }
            int val = ParsePrimitive.tryParseInt((String)comp, (int)Integer.MIN_VALUE);
            if (val == Integer.MIN_VALUE || val < 0) {
                throw new RuntimeException("Illegal path element `" + comp + "` at location `" + i + "` in path expression: `" + path + "`");
            }
            ret[ep++] = val;
        }
        return Arrays.copyOf(ret, ep);
    }

    public String renderPath() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.path.length; ++i) {
            int el = this.path[i];
            if (sb.length() > 0 || 1 == i && -3 == this.path[0]) {
                sb.append("/");
            }
            if (-3 == el) continue;
            if (-2 == el) {
                sb.append(".");
                continue;
            }
            if (-1 == el) {
                sb.append("..");
                continue;
            }
            sb.append(el);
        }
        return sb.toString();
    }

    public String toString() {
        return "SnmpRelativeOid: " + this.renderPath();
    }

    public static SnmpRelativeOid parse(String path) {
        return new SnmpRelativeOid(SnmpRelativeOid.parseAsFilePathExpression(path));
    }
}

