package eu.linuxengineering.snmp;

import java.util.List;

import eu.javaexperience.collection.list.NullList;
import eu.javaexperience.log.JavaExperienceLoggingFacility;
import eu.javaexperience.log.LogLevel;
import net.sf.snmpadaptor4j.SnmpConfiguration;
import net.sf.snmpadaptor4j.SnmpManagerConfiguration;
import net.sf.snmpadaptor4j.api.SnmpApiFactory;
import net.sf.snmpadaptor4j.api.SnmpDaemon;
import net.sf.snmpadaptor4j.api.SnmpMib;
import net.sf.snmpadaptor4j.api.opennms.OpennmsSnmpApiFactory;
import net.sf.snmpadaptor4j.object.SnmpDataType;

public class SnmpServer
{
	protected SnmpDaemon adaptor;
	
	public SnmpServer(String bindAddress, int port, SnmpMib root) throws Exception
	{
		final SnmpApiFactory apiFactory = new OpennmsSnmpApiFactory();

		SnmpConfiguration cfg = new SnmpConfiguration()
		{
			@Override
			public String getListenerWriteCommunity()
			{
				return "private";
			}
			
			@Override
			public Integer getListenerSnmpVersion()
			{
				return 2;
			}
			
			@Override
			public String getListenerReadCommunity()
			{
				return "public";
			}
			
			@Override
			public Integer getListenerPort()
			{
				return port;
			}
			
			@Override
			public String getListenerAddress()
			{
				return bindAddress;
			}
			
			@Override
			public List<SnmpManagerConfiguration> getManagerList()
			{
				return NullList.instance;
			}
		};
		
		adaptor = apiFactory.newSnmpDaemon(cfg, root);
	}
	
	public void start() throws Exception
	{
		adaptor.start();
	}
	
	public void stop() throws Exception
	{
		adaptor.stop();
	}
	
	public static void main(String[] args) throws Exception
	{
		JavaExperienceLoggingFacility.setFutureDefaultLoglevel(LogLevel.DEBUG);
		
		JavaExperienceLoggingFacility.addStdOut();
		
		SnmpMibDispatch disp = new SnmpMibDispatch();
		
		SnmpTools.addRoAccessorToPath(disp, new int[] {1, 25, 2}, SnmpDataType.octetString, ()->"Hello World", false);
		
		SnmpServer server = new SnmpServer("0.0.0.0", 2100, disp);
		server.start();
	}
}
