package eu.linuxengineering.zabbix.api;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

import org.json.JSONArray;

import eu.javaexperience.arrays.ArrayTools;
import eu.javaexperience.collection.enumerations.EnumTools;
import eu.javaexperience.datareprez.DataArray;
import eu.javaexperience.datareprez.DataCommon;
import eu.javaexperience.datareprez.DataObject;
import eu.javaexperience.datareprez.convertFrom.DataReprezType;
import eu.javaexperience.datareprez.convertFrom.ModifiableObject;
import eu.javaexperience.datareprez.convertFrom.ObjectLike;
import eu.javaexperience.datareprez.jsonImpl.DataArrayJsonImpl;
import eu.javaexperience.reflect.CastTo;
import eu.javaexperience.reflect.Caster;
import eu.javaexperience.reflect.Mirror;
import eu.javaexperience.semantic.references.MayNotModified;

public class TargetObject implements ModifiableObject, ObjectLike
{
	@Override
	public DataReprezType getDataReprezType()
	{
		return DataReprezType.OBJECT;
	}

	@Override
	public boolean has(String key)
	{
		return ArrayTools.contains(keys(), key);
	}
	
	protected static class ModifiableFields
	{
		public ModifiableFields(Class cls)
		{
			for(Field f:Mirror.collectClassFields(cls, true))
			{
				fields.put(f.getName(), f);
			}
			
			keys = fields.keySet().toArray(Mirror.emptyStringArray);
		}

		public String[] keys;
		public Map<String, Field> fields = new HashMap<>();
	}
	
	protected static Map<Class, ModifiableFields> MF = new ConcurrentHashMap<>();
	
	protected static ModifiableFields getMappingData(Class cls)
	{
		ModifiableFields ret = MF.get(cls);
		if(null == ret)
		{
			ret = new ModifiableFields(cls);
			MF.put(cls, ret);
		}
		return ret;
	}
	
	
	@Override
	public String[] keys()
	{
		try
		{
			return getMappingData(getClass()).keys;
		}
		catch (Exception e)
		{
			Mirror.propagateAnyway(e);
			return null;
		}
	}

	@Override
	public int size()
	{
		return keys().length;
	}

	@Override
	public boolean set(String key, Object src)
	{
		return set(key, src, false);
	}
	
	@Override
	public Object get(String key)
	{
		ModifiableFields mapping;
		try
		{
			return getMappingData(getClass()).fields.get(key).get(this);
		
		}
		catch (Exception e)
		{
			e.printStackTrace();
			return null;
		}
	}

	public boolean set(String key, Object src, boolean filter)
	{
		try
		{
			ModifiableFields mapping = getMappingData(this.getClass());
			Field f = mapping.fields.get(key);
			
			if(null != f)
			{
				if(filter && null != f.getAnnotation(MayNotModified.class))
				{
					return false;
				}
				
				if(null != src)
				{
					src = tryCast(this, f.getType(), src);
					f.set(this, src);
				}
			}
		}
		catch(Exception e)
		{
			Mirror.propagateAnyway(e);
		}
		return false;
	}
	
	public static <T> Object tryCast(Object subject, Class reqType, Object src) throws Exception
	{
		if(reqType.isEnum())
		{
			return EnumTools.recogniseSymbol(reqType, src);
		}
		else
		{
			if(String.class == reqType && src instanceof DataCommon)
			{
				byte[] ret = ((DataCommon)src).toBlob();
				return null  == ret?null:new String(ret);
			}
			
			Caster c = CastTo.getCasterRestrictlyForTargetClass(reqType);
			if(null != c)
			{
				return c.cast(src);
			}
		}
		
		if(reqType.isEnum())
		{
			if(src instanceof DataObject)
			{
				return EnumTools.recogniseSymbol(reqType, ((DataObject) src).optString("name"));
			}
		}
		else if(reqType.isArray())
		{
			DataArray arr = null;
			if(src instanceof String)
			{
				arr = new DataArrayJsonImpl(new JSONArray(src.toString()));
			}
			else if(src instanceof DataArray)
			{
				arr = (DataArray) src;
			}
			
			Class nType = reqType.getComponentType();
			
			T[] ret = (T[]) Array.newInstance(nType, arr.size());
			for(int i=0;i<ret.length;++i)
			{
				ret[i] = (T) tryCast(subject, nType, arr.get(i));
			}
			
			return ret;
		}
		else if(null != reqType && null != src && reqType.isAssignableFrom(src.getClass()))
		{
			return src;
		}
		
		return null;
	}

	@Override
	public void unset(String key)
	{
		set(key, null);
	}
	
	public void loadFrom(ObjectLike from)
	{
		for(String k:from.keys())
		{
			set(k, from.get(k));
		}
	}
	
	public void loadFromUser(ObjectLike from)
	{
		for(String k:from.keys())
		{
			set(k, from.get(k), true);
		}
	}
	
	@Override
	public String toString()
	{
		return Mirror.usualToString(this);
	}
}
