package eu.linuxengineering.zabbix.api;

import eu.linuxengineering.zabbix.ZabbixApiClient;

public class ZabbixGenericApiNode implements ZabbixApi
{
	protected ZabbixApiClient apiClient;
	protected String path;
	
	public ZabbixGenericApiNode(ZabbixApiClient apiClient, String path)
	{
		this.apiClient = apiClient;
		this.path = path;
	}
	
	@Override
	public ZabbixApiClient getApiClient()
	{
		return apiClient;
	}
	
	@Override
	public String getApiPath()
	{
		return path;
	}
	
	@Override
	public ZabbixGenericApiNode nextPath(String reqName)
	{
		return new ZabbixGenericApiNode(apiClient, ("".equals(path)?"":(path+"."))+reqName);
	}
}
