/*
 * Decompiled with CFR 0.152.
 */
package eu.linuxengineering.snmp;

import eu.javaexperience.semantic.references.MayNull;
import java.util.Arrays;
import net.sf.snmpadaptor4j.object.SnmpOid;

public class SnmpPathDispatch {
    @MayNull
    protected SnmpOid oid;
    protected int index;
    protected int[] oids;

    protected SnmpPathDispatch(SnmpOid oid) {
        this(oid, 0);
    }

    public SnmpPathDispatch(SnmpOid oid, int index) {
        this.oid = oid;
        this.oids = oid.getOid();
        this.index = index;
    }

    public SnmpPathDispatch(SnmpPathDispatch spd, int index) {
        this.oid = spd.oid;
        this.oids = spd.oids;
        this.index = index;
    }

    public SnmpPathDispatch(int[] oids, int index) {
        this.oids = oids;
        this.index = index;
    }

    public boolean hasNexOidPath() {
        return this.index < this.oids.length;
    }

    public Integer getCurrentPathOid() {
        return this.oids[this.index];
    }

    public Integer getCurrentPathIdAndGoNext() {
        return this.oids[this.index++];
    }

    public int getCurrentPathIndex() {
        return this.index;
    }

    public int getPathLength() {
        return this.oids.length;
    }

    public String toString() {
        return "SnmpPathDispatch: " + Arrays.toString(this.oids) + ", at: " + this.index;
    }

    public boolean isLastDispatch() {
        return this.index == this.oids.length - 1;
    }

    public boolean isInvalid() {
        return this.index >= this.oids.length || this.index < 0;
    }

    public void jumpNextNode() {
        ++this.index;
    }

    public void jumpPreviousNode() {
        --this.index;
    }

    public void setPathIndex(int i) {
        this.index = i;
    }

    public int[] copyCurrentPath() {
        return Arrays.copyOf(this.oids, this.index + 1);
    }
}

