package eu.linuxengineering.zabbix.api;

import eu.linuxengineering.zabbix.ZabbixApiClient;
import eu.linuxengineering.zabbix.annotation.ExtraParameters;
import eu.linuxengineering.zabbix.annotation.ParameterName;

public interface ZabbixApiUser extends ZabbixApi
{
	public static class ZabixUserData extends TargetObject
	{
		public Integer userid;
		public String alias;
		public String name;
		public String surname;
		public String url;
		public Integer autologin;
		public Integer autologout;
		public String lang;
		public Integer refresh;
		public Integer type;
		public String theme;
		public Integer attempt_failed;
		public String attempt_ip;
		public Integer attempt_clock;
		public Integer rows_per_page;
		public Boolean debug_mode;
		public String userip;
		public String sessionid;
		public Integer gui_access;
	}
	
	/**
	 * Don't use directly.
	 * Use {@link ZabbixApiClient#login(String, String)} instead.
	 * */
	@Deprecated
	@ExtraParameters(params="userData=true")
	public ZabixUserData login(@ParameterName(name="user") String username, @ParameterName(name="password") String login);

	public void logout();
}
