/*
 * Decompiled with CFR 0.152.
 */
package eu.linuxengineering.zabbix.api;

import eu.javaexperience.arrays.ArrayTools;
import eu.javaexperience.collection.enumerations.EnumTools;
import eu.javaexperience.datareprez.DataArray;
import eu.javaexperience.datareprez.DataCommon;
import eu.javaexperience.datareprez.DataObject;
import eu.javaexperience.datareprez.convertFrom.DataReprezType;
import eu.javaexperience.datareprez.convertFrom.ModifiableObject;
import eu.javaexperience.datareprez.convertFrom.ObjectLike;
import eu.javaexperience.datareprez.jsonImpl.DataArrayJsonImpl;
import eu.javaexperience.reflect.CastTo;
import eu.javaexperience.reflect.Mirror;
import eu.javaexperience.semantic.references.MayNotModified;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.json.JSONArray;

public class TargetObject
implements ModifiableObject,
ObjectLike {
    protected static Map<Class, ModifiableFields> MF = new ConcurrentHashMap<Class, ModifiableFields>();

    public DataReprezType getDataReprezType() {
        return DataReprezType.OBJECT;
    }

    public boolean has(String key) {
        return ArrayTools.contains((Object[])this.keys(), (Object)key);
    }

    protected static ModifiableFields getMappingData(Class cls) {
        ModifiableFields ret = MF.get(cls);
        if (null == ret) {
            ret = new ModifiableFields(cls);
            MF.put(cls, ret);
        }
        return ret;
    }

    public String[] keys() {
        try {
            return TargetObject.getMappingData(this.getClass()).keys;
        }
        catch (Exception e) {
            Mirror.propagateAnyway((Throwable)e);
            return null;
        }
    }

    public int size() {
        return this.keys().length;
    }

    public boolean set(String key, Object src) {
        return this.set(key, src, false);
    }

    public Object get(String key) {
        try {
            return TargetObject.getMappingData(this.getClass()).fields.get(key).get(this);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean set(String key, Object src, boolean filter) {
        try {
            ModifiableFields mapping = TargetObject.getMappingData(this.getClass());
            Field f = mapping.fields.get(key);
            if (null != f) {
                if (filter && null != f.getAnnotation(MayNotModified.class)) {
                    return false;
                }
                if (null != src) {
                    src = TargetObject.tryCast(this, f.getType(), src);
                    f.set(this, src);
                }
            }
        }
        catch (Exception e) {
            Mirror.propagateAnyway((Throwable)e);
        }
        return false;
    }

    public static <T> Object tryCast(Object subject, Class reqType, Object src) throws Exception {
        if (reqType.isEnum()) {
            return EnumTools.recogniseSymbol((Class)reqType, (Object)src);
        }
        if (String.class == reqType && src instanceof DataCommon) {
            byte[] ret = ((DataCommon)src).toBlob();
            return null == ret ? null : new String(ret);
        }
        CastTo c = CastTo.getCasterRestrictlyForTargetClass((Class)reqType);
        if (null != c) {
            return c.cast(src);
        }
        if (reqType.isEnum()) {
            if (src instanceof DataObject) {
                return EnumTools.recogniseSymbol((Class)reqType, (Object)((DataObject)src).optString("name"));
            }
        } else {
            if (reqType.isArray()) {
                DataArray arr = null;
                if (src instanceof String) {
                    arr = new DataArrayJsonImpl(new JSONArray(src.toString()));
                } else if (src instanceof DataArray) {
                    arr = (DataArray)src;
                }
                Class<?> nType = reqType.getComponentType();
                Object[] ret = (Object[])Array.newInstance(nType, arr.size());
                for (int i = 0; i < ret.length; ++i) {
                    ret[i] = TargetObject.tryCast(subject, nType, arr.get(i));
                }
                return ret;
            }
            if (null != reqType && null != src && reqType.isAssignableFrom(src.getClass())) {
                return src;
            }
        }
        return null;
    }

    public void unset(String key) {
        this.set(key, null);
    }

    public void loadFrom(ObjectLike from) {
        for (String k : from.keys()) {
            this.set(k, from.get(k));
        }
    }

    public void loadFromUser(ObjectLike from) {
        for (String k : from.keys()) {
            this.set(k, from.get(k), true);
        }
    }

    public String toString() {
        return Mirror.usualToString((Object)this);
    }

    protected static class ModifiableFields {
        public String[] keys;
        public Map<String, Field> fields = new HashMap<String, Field>();

        public ModifiableFields(Class cls) {
            for (Field f : Mirror.collectClassFields((Class)cls, (boolean)true)) {
                this.fields.put(f.getName(), f);
            }
            this.keys = this.fields.keySet().toArray(Mirror.emptyStringArray);
        }
    }
}

