package eu.linuxengineering.zabbix.api;

import java.util.List;

import eu.linuxengineering.zabbix.annotation.ParameterName;

/**
 * https://www.zabbix.com/documentation/3.0/manual/api/reference/item
 * TODO
 * 	delete
 * 	isreadable
 * 	iswriteable
 * 	update
 * */
public interface ZabbixApiItem extends ZabbixApi
{
	public static class ZabbixItemIds extends TargetObject
	{
		public Integer[] itemids;
	}
	
	public ZabbixItemIds create
	(
		@ParameterName(name="name") String name,
		@ParameterName(name="key_") String key,
		@ParameterName(name="hostid") int hostId,
		@ParameterName(name="type") int type,
		@ParameterName(name="value_type") int valueType,
		@ParameterName(name="interfaceid") int interfaceId,
		@ParameterName(name="applications") List<Integer> applications,
		@ParameterName(name="delay") int delay
	);
	
	
	public ZabbixItemIds create(ZabbixItem item);
	
	public static class ZabbixItem extends TargetObject implements ZabbixParameters
	{
		public Integer itemid;
		public Integer type;
		public String snmp_community;
		public String snmp_oid;
		public Integer hostid;
		public String name;
		public String key_;
		public Integer delay;
		public Integer history;
		public Integer trends;
		public Integer lastvalue;
		public Integer lastclock;
		public String prevvalue;
		public Integer state;
		public Integer status;
		public Integer value_type;
		public String trapper_hosts;
		public String units;
		public Integer multiplier;
		public String delta;
		public String snmpv3_securityname;
		public Integer snmpv3_securitylevel;
		public String snmpv3_authpassphrase;
		public String snmpv3_privpassphrase;
		public Integer snmpv3_authprotocol;
		public Integer snmpv3_privprotocol;
		public String snmpv3_contextname;
		public Integer formula;
		public String error;
		public Integer lastlogsize;
		public String logtimefmt;
		public Integer templateid;
		public Integer valuemapid;
		public String delay_flex;
		public String params;
		public String ipmi_sensor;
		public Integer data_type;
		public Integer authtype;
		public String username;
		public String password;
		public String publickey;
		public String privatekey;
		public Integer mtime;
		public Integer lastns;
		public Integer flags;
		public Integer interfaceid;
		public String port;
		public String description;
		public Integer inventory_link;
		public Integer lifetime;
		public Integer evaltype;
	}
	
	public List<ZabbixItem> get(ZabbixParams params);
}
