package eu.linuxengineering.snmp.nodes;

import java.util.Collection;

import eu.linuxengineering.snmp.annotations.SnmpIndex;

/**
 * Every 0 namespace is a reflection node
 * 
 * This interface is not used directly, it works as a documentation about how a
 * 	reflection node works.
 * */
public interface SnmpReflect
{
	@SnmpIndex(index=1)
	public String getNodeName();
	
	@SnmpIndex(index=2)
	public String getNodeDescription();
	
	@SnmpIndex(index=3)
	public SnmpNodeType getType();
	
	@SnmpIndex(index=4)
	public int getSubItemCount();
	
	public Collection<SnmpDiscoverableItem> getDiscoverableItems();
}
