/*
 * Decompiled with CFR 0.152.
 */
package eu.linuxengineering.zabbix.api;

import eu.javaexperience.arrays.ArrayTools;
import eu.javaexperience.collection.enumerations.EnumTools;
import eu.javaexperience.datareprez.DataArray;
import eu.javaexperience.datareprez.DataCommon;
import eu.javaexperience.datareprez.DataObject;
import eu.javaexperience.datareprez.DataReprezTools;
import eu.javaexperience.datareprez.convertFrom.DataReprezType;
import eu.javaexperience.datareprez.convertFrom.ModifiableObject;
import eu.javaexperience.datareprez.convertFrom.ObjectLike;
import eu.javaexperience.datareprez.jsonImpl.DataArrayJsonImpl;
import eu.javaexperience.interfaces.ObjectWithProperty;
import eu.javaexperience.reflect.CastTo;
import eu.javaexperience.reflect.Mirror;
import eu.javaexperience.semantic.references.MayNotModified;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.json.JSONArray;

public class TargetObject
implements ModifiableObject,
ObjectLike {
    protected static Map<Class, ModifiableFields> MF = new ConcurrentHashMap<Class, ModifiableFields>();

    public DataReprezType getDataReprezType() {
        return DataReprezType.OBJECT;
    }

    public boolean has(String key) {
        return ArrayTools.contains((Object[])this.keys(), (Object)key);
    }

    protected static ModifiableFields getMappingData(Class cls) {
        ModifiableFields ret = MF.get(cls);
        if (null == ret) {
            ret = new ModifiableFields(cls);
            MF.put(cls, ret);
        }
        return ret;
    }

    public String[] keys() {
        try {
            return TargetObject.getMappingData(this.getClass()).keys;
        }
        catch (Exception e) {
            Mirror.propagateAnyway((Throwable)e);
            return null;
        }
    }

    public int size() {
        return this.keys().length;
    }

    public boolean set(String key, Object src) {
        return this.set(key, src, false);
    }

    public Object get(String key) {
        try {
            return TargetObject.getMappingData(this.getClass()).fields.get(key).get(this);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean set(String key, Object src, boolean filter) {
        try {
            ModifiableFields mapping = TargetObject.getMappingData(this.getClass());
            Field f = mapping.fields.get(key);
            if (null != f) {
                if (filter && null != f.getAnnotation(MayNotModified.class)) {
                    return false;
                }
                if (null != src) {
                    src = TargetObject.tryCast(this, f.getGenericType(), src);
                    f.set(this, src);
                }
            }
        }
        catch (Exception e) {
            Mirror.propagateAnyway((Throwable)e);
        }
        return false;
    }

    public static Type tryExtractGenericTypeOne(Type genRet) {
        Type[] args;
        if (genRet instanceof ParameterizedType && (args = ((ParameterizedType)genRet).getActualTypeArguments()).length > 0) {
            return args[0];
        }
        return null;
    }

    public static <T> Object tryCast(Object subject, Type reqType, Object src) throws Exception {
        Class raw = Mirror.extracClass((Type)reqType);
        if (null != reqType && null != src && raw.isAssignableFrom(src.getClass())) {
            return src;
        }
        if (raw.isEnum()) {
            if (src instanceof DataObject) {
                return EnumTools.recogniseSymbol((Class)raw, (Object)((DataObject)src).optString("name"));
            }
            return EnumTools.recogniseSymbol((Class)raw, (Object)src);
        }
        if (Collection.class.isAssignableFrom(raw)) {
            AbstractCollection ret = null;
            Type generic = TargetObject.tryExtractGenericTypeOne(reqType);
            if (!Modifier.isAbstract(raw.getModifiers()) && !raw.isInterface()) {
                try {
                    ret = (HashSet)raw.newInstance();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (null == ret) {
                if (Set.class.isAssignableFrom(raw)) {
                    ret = new HashSet();
                } else if (List.class.isAssignableFrom(raw)) {
                    ret = new ArrayList();
                }
            }
            if (null == ret) {
                return null;
            }
            DataArray arr = null;
            if (src instanceof String) {
                arr = new DataArrayJsonImpl(new JSONArray(src.toString()));
            } else if (src instanceof DataArray) {
                arr = (DataArray)src;
            }
            if (null == arr) {
                return null;
            }
            for (int i = 0; i < arr.size(); ++i) {
                if (null != generic) {
                    ret.add(TargetObject.tryCast(subject, generic, arr.get(i)));
                    continue;
                }
                ret.add(arr.get(i));
            }
            return ret;
        }
        if (raw.isArray()) {
            DataArray arr = null;
            if (src instanceof String) {
                arr = new DataArrayJsonImpl(new JSONArray(src.toString()));
            } else if (src instanceof DataArray) {
                arr = (DataArray)src;
            }
            Class<?> nType = raw.getComponentType();
            Object[] ret = (Object[])Array.newInstance(nType, arr.size());
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = TargetObject.tryCast(subject, nType, arr.get(i));
            }
            return ret;
        }
        if (String.class == reqType && src instanceof DataCommon) {
            byte[] ret = ((DataCommon)src).toBlob();
            return null == ret ? null : new String(ret);
        }
        if (ModifiableObject.class.isAssignableFrom(raw) && src instanceof DataObject) {
            TargetObject ret = null;
            if (!Modifier.isAbstract(raw.getModifiers()) && !raw.isInterface()) {
                try {
                    ret = (ModifiableObject)raw.newInstance();
                }
                catch (Exception nType) {
                    // empty catch block
                }
            }
            if (null == ret) {
                ret = new TargetObject();
            }
            DataObject from = (DataObject)src;
            DataReprezTools.copyInto((ModifiableObject)ret, (ObjectWithProperty)from);
            return ret;
        }
        CastTo c = CastTo.getCasterRestrictlyForTargetClass((Class)raw);
        if (null != c) {
            return c.cast(src);
        }
        return null;
    }

    public void unset(String key) {
        this.set(key, null);
    }

    public void loadFrom(ObjectLike from) {
        for (String k : from.keys()) {
            this.set(k, from.get(k));
        }
    }

    public void loadFromUser(ObjectLike from) {
        for (String k : from.keys()) {
            this.set(k, from.get(k), true);
        }
    }

    public String toString() {
        return Mirror.usualToString((Object)this);
    }

    protected static class ModifiableFields {
        public String[] keys;
        public Map<String, Field> fields = new HashMap<String, Field>();

        public ModifiableFields(Class cls) {
            for (Field f : Mirror.collectClassFields((Class)cls, (boolean)true)) {
                this.fields.put(f.getName(), f);
            }
            this.keys = this.fields.keySet().toArray(Mirror.emptyStringArray);
        }
    }
}

