package eu.linuxengineering.snmp;

import java.util.Map.Entry;
import java.util.TreeMap;

import net.sf.snmpadaptor4j.api.AttributeAccessor;

public class SnmpDispatchNode implements SnmpNode
{
	protected TreeMap<Integer, SnmpNode> subNodes = new TreeMap<>();
	
	@Override
	public boolean hasSubNodes()
	{
		return true;
	}

	@Override
	public Entry<Integer, SnmpNode> getSubNodeGte(SnmpPathDispatch index)
	{
		if(null == index || !index.hasNexOidPath())
		{
			return subNodes.firstEntry();
		}
		
		Integer id = index.getCurrentPathIdAndGoNext();
		return subNodes.ceilingEntry(id);
	}

	@Override
	public AttributeAccessor getAccessor()
	{
		return null;
	}
	
	public void addEntry(Integer id, SnmpNode node)
	{
		subNodes.put(id, node);
	}
}
