/*
 * Decompiled with CFR 0.152.
 */
package eu.linuxengineering.snmp;

import eu.javaexperience.interfaces.simple.SimpleGet;
import eu.javaexperience.interfaces.simple.getBy.GetBy1;
import eu.javaexperience.log.JavaExperienceLoggingFacility;
import eu.javaexperience.log.LogLevel;
import eu.javaexperience.log.Loggable;
import eu.javaexperience.log.LoggableUnitDescriptor;
import eu.javaexperience.log.Logger;
import eu.javaexperience.log.LoggingDetailLevel;
import eu.javaexperience.log.LoggingTools;
import eu.javaexperience.reflect.CastTo;
import eu.javaexperience.reflect.Mirror;
import eu.javaexperience.reflect.PrimitiveTools;
import eu.javaexperience.semantic.references.MayNull;
import eu.javaexperience.text.StringTools;
import eu.linuxengineering.snmp.SnmpDispatchNode;
import eu.linuxengineering.snmp.SnmpFinalNode;
import eu.linuxengineering.snmp.SnmpMibDispatch;
import eu.linuxengineering.snmp.SnmpNode;
import eu.linuxengineering.snmp.SnmpProxyNode;
import eu.linuxengineering.snmp.SnmpRelativeOid;
import eu.linuxengineering.snmp.SnmpRequestSensitiveDispatchCollection;
import eu.linuxengineering.snmp.annotations.SnmpIndex;
import eu.linuxengineering.snmp.annotations.SnmpNodeDetails;
import eu.linuxengineering.snmp.annotations.SnmpSubnode;
import eu.linuxengineering.snmp.nodes.SnmpNodeType;
import eu.linuxengineering.snmp.nodes.SnmpReflectFields;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import net.sf.snmpadaptor4j.api.AttributeAccessor;
import net.sf.snmpadaptor4j.object.SnmpDataType;
import net.sf.snmpadaptor4j.object.SnmpOid;

public class SnmpTools {
    protected static final Logger LOG = JavaExperienceLoggingFacility.getLogger((LoggableUnitDescriptor)new Loggable("SnmpTools"));
    public static final Mirror.MethodSelector SELECT_ALL_PUBLIC_INSTANCE_METHOD = new Mirror.MethodSelector(true, Mirror.Visibility.Public, Mirror.BelongTo.Instance, Mirror.Select.IsNot, Mirror.Select.All, Mirror.Select.All, Mirror.Select.All, Mirror.Select.All);
    public static final GetBy1<SnmpNode, Object> WRAP_OBJECT_TO_SNMP = obj -> SnmpTools.wrapSnmpObject(obj);

    private SnmpTools() {
    }

    public static SnmpDispatchNode ensurePath(SnmpDispatchNode from, int[] path) {
        for (int i = 0; i < path.length; ++i) {
            SnmpNode node = from.subNodes.get(path[i]);
            if (null == node) {
                SnmpDispatchNode tmp = new SnmpDispatchNode();
                from.addEntry(path[i], tmp);
                node = tmp;
            }
            if (!(node instanceof SnmpDispatchNode)) {
                throw new RuntimeException("A non SnmpDispatchNode node already present in path `" + Arrays.toString(path) + " at " + i + " " + node);
            }
            from = (SnmpDispatchNode)node;
        }
        return from;
    }

    public static SnmpNode tryAddToPath(SnmpDispatchNode from, int[] path, SnmpNode node) {
        SnmpDispatchNode to = SnmpTools.ensurePath(from, Arrays.copyOf(path, path.length - 1));
        Integer tar = path[path.length - 1];
        SnmpNode ret = null;
        ret = to.subNodes.get(tar);
        if (null != ret && ret != node) {
            return ret;
        }
        to.addEntry(tar, node);
        return null;
    }

    public static void addToPath(SnmpDispatchNode from, int[] path, SnmpNode node, boolean forceOverride) {
        SnmpDispatchNode to = SnmpTools.ensurePath(from, Arrays.copyOf(path, path.length - 1));
        Integer tar = path[path.length - 1];
        if (to.subNodes.containsKey(tar) && !forceOverride) {
            throw new RuntimeException("Node at path " + Arrays.toString(path) + " already exists: " + to.subNodes.get(tar));
        }
        to.addEntry(tar, node);
    }

    public static AttributeAccessor createReadOnlyAttributeAccessor(final SnmpOid id, final SnmpDataType type, final SimpleGet<?> source) {
        return new AttributeAccessor(){

            public void setValue(Object value) throws Exception {
            }

            public boolean isWritable() {
                return false;
            }

            public boolean isReadable() {
                return true;
            }

            public Object getValue() throws Exception {
                return source.get();
            }

            public SnmpDataType getSnmpDataType() {
                return type;
            }

            public SnmpOid getOid() {
                return id;
            }

            public Class<?> getJmxDataType() {
                return null;
            }
        };
    }

    public static SnmpFinalNode addRoAccessorToPath(SnmpDispatchNode root, int[] id, SnmpDataType type, SimpleGet<Object> getter, boolean forceOverride) {
        SnmpOid oid = SnmpOid.newInstance((int[])id);
        SnmpFinalNode ret = new SnmpFinalNode(SnmpTools.createReadOnlyAttributeAccessor(oid, type, getter));
        SnmpTools.addToPath(root, id, ret, forceOverride);
        return ret;
    }

    public static SnmpFinalNode createFinalNode(SnmpOid oid, SnmpDataType type, SimpleGet<?> getter) {
        return new SnmpFinalNode(SnmpTools.createReadOnlyAttributeAccessor(oid, type, getter));
    }

    public static SnmpNode addSnmpObjectToPath(SnmpMibDispatch root, int[] path, Object node, boolean forceOverride) {
        SnmpNode add = SnmpTools.wrapSnmpObject(node);
        SnmpTools.addToPath(root, path, add, forceOverride);
        return add;
    }

    public static SnmpDataType recogniseSnmpDataType(Class cls) {
        if (String.class == (cls = PrimitiveTools.toObjectClassType((Class)cls, (Class)cls))) {
            return SnmpDataType.octetString;
        }
        if (Boolean.class == cls || Byte.class == cls || Character.class == cls || Short.class == cls || Integer.class == cls) {
            return SnmpDataType.integer32;
        }
        if (Long.class == cls) {
            return SnmpDataType.counter64;
        }
        if (SnmpOid.class == cls) {
            return SnmpDataType.objectIdentifier;
        }
        return null;
    }

    protected static SnmpNode createReflectNode(String name, String description, SnmpNodeType type, SimpleGet<Integer> itemsCount) {
        SnmpRequestSensitiveDispatchCollection ret = new SnmpRequestSensitiveDispatchCollection();
        if (!StringTools.isNullOrTrimEmpty((String)name)) {
            ret.addNodeFactory((Integer)1, (GetBy1<SnmpNode, SnmpOid>)((GetBy1)oid -> SnmpTools.createFinalNode(oid, SnmpDataType.octetString, () -> name)));
        }
        if (!StringTools.isNullOrTrimEmpty((String)description)) {
            ret.addNodeFactory((Integer)2, (GetBy1<SnmpNode, SnmpOid>)((GetBy1)oid -> SnmpTools.createFinalNode(oid, SnmpDataType.octetString, () -> description)));
        }
        ret.addNodeFactory((Integer)3, (GetBy1<SnmpNode, SnmpOid>)((GetBy1)oid -> SnmpTools.createFinalNode(oid, SnmpDataType.octetString, () -> type.name())));
        ret.addNodeFactory((Integer)4, (GetBy1<SnmpNode, SnmpOid>)((GetBy1)oid -> SnmpTools.createFinalNode(oid, SnmpDataType.integer32, itemsCount)));
        return ret;
    }

    public static GetBy1<SnmpNode, SnmpOid> wrapToSnmpObjectCreator(Object o) {
        if (o instanceof SnmpRelativeOid) {
            return oid -> SnmpTools.createFinalNode(oid, SnmpDataType.octetString, () -> ((SnmpRelativeOid)o).resolve((SnmpOid)oid).toString());
        }
        if (String.class == o.getClass() || PrimitiveTools.isPrimitiveTypeObject((Class)PrimitiveTools.translatePrimitiveToObjectType(o.getClass()))) {
            return oid -> SnmpTools.createFinalNode(oid, SnmpTools.recogniseSnmpDataType(o.getClass()), () -> o);
        }
        if (o instanceof Collection) {
            return oid -> SnmpTools.wrapCollectionSource((SimpleGet<Collection>)((SimpleGet)() -> (Collection)o), null);
        }
        if (o instanceof Map) {
            return oid -> SnmpTools.wrapMapSource((SimpleGet<Map>)((SimpleGet)() -> (Map)o), null);
        }
        return oid -> SnmpTools.wrapSnmpObject(o);
    }

    protected static SnmpNode wrapCollectionSource(final SimpleGet<Collection> src, final SnmpReflectFields info) {
        return new SnmpProxyNode(){
            protected Collection prev;

            @Override
            public synchronized void beforeAccess() {
                try {
                    Collection now = (Collection)src.get();
                    if (null == this.original || !Mirror.equals((Object)this.prev, (Object)now)) {
                        SnmpRequestSensitiveDispatchCollection ret = new SnmpRequestSensitiveDispatchCollection();
                        int[] items = new int[]{0};
                        if (null != info) {
                            ret.addNodeFactory((Integer)0, SnmpTools.createReflectNode(null == info ? null : info.getName(), null == info ? null : info.getDescription(), SnmpNodeType.ENUMERATION, (SimpleGet<Integer>)((SimpleGet)() -> items[0])));
                        }
                        int i = 1;
                        for (Object o : now) {
                            if (null != o) {
                                ret.addNodeFactory((Integer)i, SnmpTools.wrapToSnmpObjectCreator(o));
                                items[0] = items[0] + 1;
                            }
                            ++i;
                        }
                        this.prev = now;
                        this.original = ret;
                    }
                }
                catch (Exception e) {
                    Mirror.propagateAnyway((Throwable)e);
                }
            }

            public String toString() {
                return "SnmpTools.wrapCollectionSource(src: `" + src + "`, info: `" + info + "`)";
            }
        };
    }

    protected static SnmpNode wrapMapSource(final SimpleGet<Map> src, final SnmpReflectFields info) {
        return new SnmpProxyNode(){
            protected Map<Object, Object> prev;

            @Override
            public synchronized void beforeAccess() {
                try {
                    Map now = (Map)src.get();
                    if (null == this.original || !Mirror.equals(this.prev, (Object)now)) {
                        SnmpRequestSensitiveDispatchCollection ret = new SnmpRequestSensitiveDispatchCollection();
                        int[] items = new int[]{0};
                        if (null != info) {
                            ret.addNodeFactory((Integer)0, SnmpTools.createReflectNode(null == info ? null : info.getName(), null == info ? null : info.getDescription(), SnmpNodeType.ENUMERATION, (SimpleGet<Integer>)((SimpleGet)() -> items[0])));
                        }
                        for (Map.Entry kv : now.entrySet()) {
                            Integer index;
                            Object v = kv.getValue();
                            if (null == v || null == (index = (Integer)CastTo.Int.cast(kv.getKey()))) continue;
                            ret.addNodeFactory(index, SnmpTools.wrapToSnmpObjectCreator(v));
                            items[0] = items[0] + 1;
                        }
                        this.prev = now;
                        this.original = ret;
                    }
                }
                catch (Exception e) {
                    Mirror.propagateAnyway((Throwable)e);
                }
            }

            public String toString() {
                return "SnmpTools.wrapMapSource(src: `" + src + "`, info: `" + info + "`)";
            }
        };
    }

    public static SnmpNode wrapSnmpObject(Object node) {
        if (node instanceof SnmpNode) {
            return (SnmpNode)node;
        }
        if (node instanceof Collection) {
            return SnmpTools.wrapCollectionSource((SimpleGet<Collection>)((SimpleGet)() -> (Collection)node), null);
        }
        if (node instanceof Map) {
            return SnmpTools.wrapMapSource((SimpleGet<Map>)((SimpleGet)() -> (Map)node), null);
        }
        return SnmpTools.wrapSnmpBeam(node);
    }

    public static GetBy1<SnmpNode, SnmpOid> createRelativeDemandProxy(final GetBy1<SnmpNode, Object> nodeCreator, final SimpleGet<Object> source, final boolean useCache) {
        return f -> new SnmpProxyNode(){
            protected Object prev;

            @Override
            public void beforeAccess() {
                Object now = null;
                try {
                    now = source.get();
                }
                catch (Exception e) {
                    Mirror.propagateAnyway((Throwable)e);
                }
                if (null == this.original || !useCache || !Mirror.equals((Object)this.prev, (Object)now)) {
                    this.original = (SnmpNode)nodeCreator.getBy(now);
                    this.prev = now;
                }
            }

            public String toString() {
                return "createRelativeDemandProxy(nodeCreator: `" + nodeCreator + "`, source: `" + source + "`, useCache: `" + useCache + "`)";
            }
        };
    }

    @Deprecated
    public static SimpleGet<Object> wrapMethodGetterWithLogging(Method m, Object subject) {
        return () -> {
            try {
                return m.invoke(subject, new Object[0]);
            }
            catch (Exception e) {
                LoggingTools.tryLogFormatException((Logger)LOG, (LoggingDetailLevel)LogLevel.ERROR, (Throwable)e, (String)"Exception while invoking method `%s` on `%s`", (Object)m, (Object)subject);
                Mirror.propagateAnyway((Throwable)e);
                return null;
            }
        };
    }

    @MayNull
    public static SnmpReflectFields tryExtractReflectInformation(Method m) {
        final SnmpNodeDetails info = m.getAnnotation(SnmpNodeDetails.class);
        if (null == info) {
            return null;
        }
        return new SnmpReflectFields(){

            @Override
            public String getName() {
                return info.name();
            }

            @Override
            public String getDescription() {
                return info.description();
            }
        };
    }

    public static SnmpNode wrapSnmpBeam(Object node) {
        Mirror.ClassData cd = Mirror.getClassData(node.getClass());
        Method[] methods = cd.select(SELECT_ALL_PUBLIC_INSTANCE_METHOD);
        SnmpRequestSensitiveDispatchCollection ret = new SnmpRequestSensitiveDispatchCollection();
        int[] itemsCount = new int[]{0};
        if (node instanceof SnmpReflectFields) {
            SnmpReflectFields details = (SnmpReflectFields)node;
            SnmpNode cre = SnmpTools.createReflectNode(details.getName(), details.getDescription(), SnmpNodeType.COLLECTION, (SimpleGet<Integer>)((SimpleGet)() -> itemsCount[0]));
            ret.addNodeFactory((Integer)0, cre);
        }
        for (Method m : methods) {
            boolean subnode;
            SnmpIndex index;
            if (0 != m.getParameters().length || null == (index = m.getAnnotation(SnmpIndex.class))) continue;
            Class<?> retType = m.getReturnType();
            SnmpDataType type = SnmpTools.recogniseSnmpDataType(retType);
            SnmpNodeType nodeType = SnmpNodeType.EXACT_VALUE;
            SimpleGet nodeItemCount = () -> 1;
            Object getter = null;
            SimpleGet<Object> invoke = SnmpTools.wrapMethodGetterWithLogging(m, node);
            SnmpReflectFields info = SnmpTools.tryExtractReflectInformation(m);
            if (Collection.class.isAssignableFrom(retType)) {
                ret.addNodeFactory((Integer)index.index(), SnmpTools.wrapCollectionSource(invoke, info));
                itemsCount[0] = itemsCount[0] + 1;
                continue;
            }
            if (Map.class.isAssignableFrom(retType)) {
                ret.addNodeFactory((Integer)index.index(), SnmpTools.wrapMapSource(invoke, info));
                itemsCount[0] = itemsCount[0] + 1;
                continue;
            }
            getter = SnmpRelativeOid.class.isAssignableFrom(retType) ? oid -> (SnmpNode)SnmpTools.createRelativeDemandProxy((GetBy1<SnmpNode, Object>)((GetBy1)o -> (SnmpNode)SnmpTools.wrapToSnmpObjectCreator(o).getBy(oid)), SnmpTools.wrapMethodGetterWithLogging(m, node), true).getBy(oid) : (null == type ? SnmpTools.createRelativeDemandProxy(WRAP_OBJECT_TO_SNMP, SnmpTools.wrapMethodGetterWithLogging(m, node), true) : oid -> SnmpFinalNode.wrap(oid, type, SnmpTools.wrapMethodGetterWithLogging(m, node)));
            if (null == getter) continue;
            itemsCount[0] = itemsCount[0] + 1;
            boolean bl = subnode = null != m.getAnnotation(SnmpSubnode.class);
            if (subnode) {
                SnmpRequestSensitiveDispatchCollection add = new SnmpRequestSensitiveDispatchCollection();
                if (null != info) {
                    add.addNodeFactory((Integer)0, SnmpTools.createReflectNode(info.getName(), info.getDescription(), nodeType, (SimpleGet<Integer>)nodeItemCount));
                }
                add.addNodeFactory((Integer)1, (GetBy1<SnmpNode, SnmpOid>)getter);
                ret.addNodeFactory((Integer)index.index(), add);
                continue;
            }
            ret.addNodeFactory((Integer)index.index(), (GetBy1<SnmpNode, SnmpOid>)getter);
        }
        return ret;
    }
}

