/*
 * Decompiled with CFR 0.152.
 */
package eu.linuxengineering.snmp;

import eu.linuxengineering.snmp.SnmpRelativeOid;
import java.util.Arrays;
import net.sf.snmpadaptor4j.object.SnmpOid;
import org.junit.Assert;
import org.junit.Test;

public class SnmpRelativeOidTest {
    protected static void testPath(String path, int[] data) {
        int[] actual = SnmpRelativeOid.parse((String)path).getPathComponents();
        try {
            Assert.assertArrayEquals((int[])data, (int[])actual);
        }
        catch (Throwable e) {
            throw new AssertionError("Path: " + path + ", Expected: " + Arrays.toString(data) + ", Actual: " + Arrays.toString(actual), e);
        }
    }

    @Test
    public void testParseSimple() {
        SnmpRelativeOidTest.testPath("/", new int[]{-3});
    }

    @Test
    public void testParseRelative() {
        SnmpRelativeOidTest.testPath("./10/23/0", new int[]{-2, 10, 23, 0});
        SnmpRelativeOidTest.testPath("../10/2/1", new int[]{-1, 10, 2, 1});
        SnmpRelativeOidTest.testPath(".", new int[]{-2});
    }

    @Test
    public void testParseStepBack() {
        SnmpRelativeOidTest.testPath("..", new int[]{-1});
    }

    @Test
    public void testParseSimplifications() {
        SnmpRelativeOidTest.testPath("./10/.././2/1", new int[]{-2, 2, 1});
        SnmpRelativeOidTest.testPath("10/././2/1", new int[]{10, 2, 1});
        SnmpRelativeOidTest.testPath("./10/././2/1", new int[]{-2, 10, 2, 1});
    }

    @Test
    public void testParseRelativeOutside() {
        SnmpRelativeOidTest.testPath("./../../../10/2/3", new int[]{-1, -1, -1, 10, 2, 3});
    }

    @Test
    public void testDetermineStaticTrue() {
        Assert.assertTrue((boolean)SnmpRelativeOid.parse((String)"/10/12/100").isStatic());
        Assert.assertTrue((boolean)SnmpRelativeOid.parse((String)"/10/../12/100").isStatic());
        Assert.assertTrue((boolean)SnmpRelativeOid.parse((String)"/10/12/../100").isStatic());
        Assert.assertTrue((boolean)SnmpRelativeOid.parse((String)"/../../../../").isStatic());
    }

    @Test
    public void testDetermineStaticFalse() {
        Assert.assertFalse((boolean)SnmpRelativeOid.parse((String)"./..").isStatic());
        Assert.assertFalse((boolean)SnmpRelativeOid.parse((String)"..").isStatic());
        Assert.assertFalse((boolean)SnmpRelativeOid.parse((String)"./10/20/30/../../../../").isStatic());
        Assert.assertFalse((boolean)SnmpRelativeOid.parse((String)"./././././.").isStatic());
    }

    @Test
    public void testResolvStatic() {
        Assert.assertEquals((Object)SnmpOid.newInstance((String)".1.25.10"), (Object)SnmpRelativeOid.parse((String)"/1/25/10").resolve(SnmpOid.newInstance((String)".106")));
    }

    @Test
    public void testResolvRelative() {
        Assert.assertEquals((Object)SnmpOid.newInstance((String)".106.1.25.10"), (Object)SnmpRelativeOid.parse((String)"1/25/10").resolve(SnmpOid.newInstance((String)".106")));
    }
}

