/*
 * Decompiled with CFR 0.152.
 */
package eu.linuxengineering.snmp;

import eu.javaexperience.collection.list.NullList;
import eu.javaexperience.interfaces.simple.SimpleGet;
import eu.javaexperience.log.JavaExperienceLoggingFacility;
import eu.javaexperience.log.LogLevel;
import eu.javaexperience.log.LoggingDetailLevel;
import eu.linuxengineering.snmp.SnmpMibDispatch;
import eu.linuxengineering.snmp.SnmpTools;
import java.util.List;
import net.sf.snmpadaptor4j.SnmpConfiguration;
import net.sf.snmpadaptor4j.SnmpManagerConfiguration;
import net.sf.snmpadaptor4j.api.SnmpDaemon;
import net.sf.snmpadaptor4j.api.SnmpDaemonConfiguration;
import net.sf.snmpadaptor4j.api.SnmpMib;
import net.sf.snmpadaptor4j.api.opennms.OpennmsSnmpApiFactory;
import net.sf.snmpadaptor4j.object.SnmpDataType;

public class SnmpServer {
    protected SnmpDaemon adaptor;

    public SnmpServer(final String bindAddress, final int port, SnmpMib root) throws Exception {
        OpennmsSnmpApiFactory apiFactory = new OpennmsSnmpApiFactory();
        SnmpConfiguration cfg = new SnmpConfiguration(){

            public String getListenerWriteCommunity() {
                return "private";
            }

            public Integer getListenerSnmpVersion() {
                return 2;
            }

            public String getListenerReadCommunity() {
                return "public";
            }

            public Integer getListenerPort() {
                return port;
            }

            public String getListenerAddress() {
                return bindAddress;
            }

            public List<SnmpManagerConfiguration> getManagerList() {
                return NullList.instance;
            }
        };
        this.adaptor = apiFactory.newSnmpDaemon((SnmpDaemonConfiguration)cfg, root);
    }

    public void start() throws Exception {
        this.adaptor.start();
    }

    public void stop() throws Exception {
        this.adaptor.stop();
    }

    public static void main(String[] args) throws Exception {
        JavaExperienceLoggingFacility.setFutureDefaultLoglevel((LoggingDetailLevel)LogLevel.DEBUG);
        JavaExperienceLoggingFacility.addStdOut();
        SnmpMibDispatch disp = new SnmpMibDispatch();
        SnmpTools.addRoAccessorToPath(disp, new int[]{1, 25, 2}, SnmpDataType.octetString, (SimpleGet<Object>)((SimpleGet)() -> "Hello World"), false);
        SnmpServer server = new SnmpServer("0.0.0.0", 2100, disp);
        server.start();
    }
}

