/*
 * Decompiled with CFR 0.152.
 */
package eu.linuxengineering.procfs;

import eu.javaexperience.collection.map.SmallMap;
import eu.javaexperience.io.IOTools;
import eu.javaexperience.parse.ParsePrimitive;
import eu.javaexperience.reflect.Mirror;
import eu.javaexperience.regex.RegexTools;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class CpuStat {
    public List<CpuStatEntry> cpuEntries = new ArrayList<CpuStatEntry>();
    public Map<String, Long> values = new SmallMap();
    public List<CpuStatOtherEntry> otherEntries = new ArrayList<CpuStatOtherEntry>();

    public String toString() {
        return Mirror.usualToString((Object)this);
    }

    public static CpuStat parseStatData(String data) {
        CpuStat ret = new CpuStat();
        for (String line : RegexTools.LINUX_NEW_LINE.split(data)) {
            String[] comp = RegexTools.SPACES.split(line);
            if (0 == comp.length) continue;
            if (2 == comp.length) {
                ret.values.put(comp[0], ParsePrimitive.tryParseLong((String)comp[1]));
            }
            if (comp[0].startsWith("cpu")) {
                CpuStatEntry add = CpuStatEntry.parse(comp);
                if (null == add) continue;
                ret.cpuEntries.add(add);
                continue;
            }
            CpuStatOtherEntry oth = CpuStatOtherEntry.parse(comp);
            if (null == oth) continue;
            ret.otherEntries.add(oth);
        }
        return ret;
    }

    public static void main(String[] args) throws Throwable {
        System.out.println(CpuStat.parseStatData(new String(IOTools.loadFileProcContent((String)"/proc/stat"))));
    }

    public static class CpuStatEntry {
        public String name;
        public long user;
        public long nice;
        public long system;
        public long idle;
        public long iowait;
        public long irq;
        public long softirq;
        public long steal;
        public long guest;
        protected static List<Field> CPU_FIELDS = new ArrayList<Field>();

        public static CpuStatEntry parse(String[] comp) {
            CpuStatEntry ret = new CpuStatEntry();
            ret.name = comp[0];
            for (int i = 1; i < comp.length && i <= CPU_FIELDS.size(); ++i) {
                try {
                    CPU_FIELDS.get(i - 1).set(ret, ParsePrimitive.tryParseLong((String)comp[i]));
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return ret;
        }

        public String toString() {
            return Mirror.usualToString((Object)this);
        }

        static {
            for (Field f : CpuStatEntry.class.getFields()) {
                if (f.getType() != Long.TYPE) continue;
                CPU_FIELDS.add(f);
            }
        }
    }

    public static class CpuStatOtherEntry {
        public String name;
        public List<Long> values = new ArrayList<Long>();

        public static CpuStatOtherEntry parse(String[] comp) {
            CpuStatOtherEntry ret = new CpuStatOtherEntry();
            ret.name = comp[0];
            for (int i = 1; i < comp.length; ++i) {
                ret.values.add(ParsePrimitive.tryParseLong((String)comp[i]));
            }
            return ret;
        }

        public String toString() {
            return Mirror.usualToString((Object)this);
        }
    }
}

