/*
 * Decompiled with CFR 0.152.
 */
package eu.linuxengineering.snmp;

import eu.javaexperience.collection.map.KeyVal;
import eu.javaexperience.log.JavaExperienceLoggingFacility;
import eu.javaexperience.log.LogLevel;
import eu.javaexperience.log.Loggable;
import eu.javaexperience.log.LoggableUnitDescriptor;
import eu.javaexperience.log.Logger;
import eu.javaexperience.log.LoggingDetailLevel;
import eu.javaexperience.log.LoggingTools;
import eu.javaexperience.reflect.Mirror;
import eu.linuxengineering.snmp.SnmpDispatchNode;
import eu.linuxengineering.snmp.SnmpNode;
import eu.linuxengineering.snmp.SnmpPathDispatch;
import java.util.Arrays;
import java.util.Map;
import java.util.SortedMap;
import net.sf.snmpadaptor4j.api.AttributeAccessor;
import net.sf.snmpadaptor4j.api.SnmpMib;
import net.sf.snmpadaptor4j.object.SnmpOid;

public class SnmpMibDispatch
extends SnmpDispatchNode
implements SnmpMib {
    protected static final Logger LOG = JavaExperienceLoggingFacility.getLogger((LoggableUnitDescriptor)new Loggable("SnmpMibDisaptch"));

    public void addNode(Integer id, SnmpNode node) {
        this.subNodes.put(id, node);
    }

    public SnmpNode getNode(Integer id) {
        return (SnmpNode)this.subNodes.get(id);
    }

    public AttributeAccessor find(SnmpOid oid) {
        LoggingTools.tryLogFormat((Logger)LOG, (LoggingDetailLevel)LogLevel.DEBUG, (String)"SnmpMibDisaptch.find(this: `%s`, oid: `%s`)", (Object)this, (Object)oid);
        SnmpPathDispatch dispatch = new SnmpPathDispatch(oid, 0);
        Object node = new KeyVal((Object)-1, (Object)this);
        int prevIndex = -1;
        do {
            if (prevIndex == dispatch.getCurrentPathIndex()) {
                LoggingTools.tryLogFormat((Logger)LOG, (LoggingDetailLevel)LogLevel.ERROR, (String)"SnmpMibDisaptch.find: Snmp dispatch looping ocurred when dispatching oid: `%s` at node: `%s`, node: `%s`", (Object)oid, (Object)prevIndex, (Object)node);
                throw new RuntimeException("Snmp dispatch loop exception oid: " + oid + ", node: " + node + " index: " + prevIndex);
            }
            prevIndex = dispatch.getCurrentPathIndex();
            Integer id = dispatch.getCurrentPathOid();
            boolean last = dispatch.isLastDispatch();
            if (null == (node = ((SnmpNode)node.getValue()).getSubNodeGte(dispatch))) {
                return null;
            }
            if (!((Integer)node.getKey()).equals(id)) {
                return null;
            }
            if (!last || !((Integer)node.getKey()).equals(id)) continue;
            return ((SnmpNode)node.getValue()).getAccessor();
        } while (dispatch.hasNexOidPath());
        return null;
    }

    public AttributeAccessor next(SnmpOid oid) {
        LoggingTools.tryLogFormat((Logger)LOG, (LoggingDetailLevel)LogLevel.DEBUG, (String)"SnmpMibDisaptch.next(this: `%s`, oid: `%s`)", (Object)this, (Object)oid);
        SnmpNode ret = null;
        try {
            SnmpPathDispatch dispatch = new SnmpPathDispatch(oid, 0);
            ret = SnmpMibDispatch.findNext(this, dispatch, false);
        }
        catch (Exception e) {
            LoggingTools.tryLogFormatException((Logger)LOG, (LoggingDetailLevel)LogLevel.ERROR, (Throwable)e, (String)"SnmpMibDisaptch.next(this: `%s`, oid: `%s`): Exception: ", (Object)this, (Object)oid);
            Mirror.propagateAnyway((Throwable)e);
        }
        LoggingTools.tryLogFormat((Logger)LOG, (LoggingDetailLevel)LogLevel.DEBUG, (String)"SnmpMibDisaptch.next(this: `%s`, oid: `%s`): found next: `%s`", (Object)this, (Object)oid, (Object)ret);
        return null == ret ? null : ret.getAccessor();
    }

    protected static SnmpPathDispatch modifyDispatchFrom(SnmpPathDispatch proto, int at, int newValue, int index) {
        int[] path = Arrays.copyOf(proto.oids, at + 1);
        path[at] = newValue;
        return new SnmpPathDispatch(path, index);
    }

    protected static final SnmpNode getDepthFirst(SnmpPathDispatch from, SnmpNode node) {
        int[] dsp = Arrays.copyOf(from.oids, from.index + 1);
        dsp[from.index] = -1;
        SnmpPathDispatch disp = new SnmpPathDispatch(dsp, from.index);
        if (node.hasSubNodes()) {
            Map.Entry<Integer, SnmpNode> next = node.getSubNodeGte(disp);
            disp.jumpPreviousNode();
            if (null != next) {
                dsp[from.index] = next.getKey();
                disp.jumpNextNode();
                SnmpNode ret = SnmpMibDispatch.getDepthFirst(disp, next.getValue());
                if (null == ret) {
                    return next.getValue();
                }
                return ret;
            }
        }
        return node;
    }

    protected static final SnmpNode findNext(SnmpNode node, SnmpPathDispatch dispatch, boolean exact) {
        SnmpNode next;
        int pathIndex = dispatch.getCurrentPathIndex();
        Integer req = dispatch.getCurrentPathOid();
        Map.Entry<Integer, SnmpNode> n = node.getSubNodeGte(dispatch);
        if (n != null && n.getKey() > req) {
            return SnmpMibDispatch.getDepthFirst(SnmpMibDispatch.modifyDispatchFrom(dispatch, pathIndex, n.getKey(), pathIndex + 1), n.getValue());
        }
        SnmpNode snmpNode = next = null == n ? null : n.getValue();
        if (null == next) {
            return null;
        }
        if (dispatch.isInvalid()) {
            if (next.hasSubNodes()) {
                return SnmpMibDispatch.getDepthFirst(SnmpMibDispatch.modifyDispatchFrom(dispatch, pathIndex, n.getKey(), pathIndex + 1), next);
            }
            if (exact) {
                return next;
            }
            return SnmpMibDispatch.findNext(node, SnmpMibDispatch.modifyDispatchFrom(dispatch, pathIndex, dispatch.oids[pathIndex] + 1, pathIndex), true);
        }
        if (null == (next = SnmpMibDispatch.findNext(next, dispatch, false))) {
            return SnmpMibDispatch.findNext(node, SnmpMibDispatch.modifyDispatchFrom(dispatch, pathIndex, dispatch.oids[pathIndex] + 1, pathIndex), true);
        }
        return next;
    }

    public SortedMap<SnmpOid, AttributeAccessor> nextSet(SnmpOid oid) {
        LoggingTools.tryLogFormat((Logger)LOG, (LoggingDetailLevel)LogLevel.ERROR, (String)"SnmpMibDisaptch.nextSet(this: `%s`, oid: `%s`", (Object)this, (Object)oid);
        return null;
    }
}

