package eu.linuxengineering.zabbix.api;

import java.util.ArrayList;
import java.util.List;

/**
 * https://www.zabbix.com/documentation/3.0/manual/api/reference/graph
 * */
public interface ZabbixApiGraph extends ZabbixApi
{
	public static class NewZabbixGraphItem
	{
		public Integer itemid;
		public String color;
		
		public NewZabbixGraphItem(){}
		
		public NewZabbixGraphItem(int id, String name)
		{
			this.itemid = id;
			this.color = name;
		}
	}
	
	public static class NewZabbixGraph extends TargetObject implements ZabbixParameters
	{
		public String name;
		public Integer width;
		public Integer height;
		public List<NewZabbixGraphItem> gitems = new ArrayList<>();
	}
	
	public static class ZabbixGraph extends TargetObject implements ZabbixParameters
	{
		public Integer graphid;
		public String name;
		public Integer width;
		public Integer height;
		public Double yaxismin;
		public Double yaxismax;
		public Integer templateid;
		public Integer show_work_period;
		public Integer show_triggers;
		public Integer graphtype;
		public Integer show_legend;
		public Integer show_3d;
		public Double percent_left;
		public Double percent_right;
		public Integer ymin_type;
		public Integer ymax_type;
		public Integer ymin_itemid;
		public Integer ymax_itemid;
		public Integer flags;
	}
	
	public ZabbixGraphIds create(NewZabbixGraph newGraph);
	
	public ZabbixGraph get(ZabbixParams params);
	
	public static class ZabbixGraphIds extends TargetObject
	{
		public Integer[] graphids;
	}
	
	public ZabbixGraphIds update(ZabbixGraph update);
}
