package eu.linuxengineering.zabbix.api;

import eu.javaexperience.asserts.AssertArgument;
import eu.javaexperience.generic.annotations.Ignore;
import eu.javaexperience.pdw.ProxyDataWrapperTools;
import eu.linuxengineering.zabbix.ZabbixApiClient;

public class ZabbixGenericApiNode implements ZabbixApi
{
	protected ZabbixApiClient apiClient;
	protected String path;
	
	public ZabbixGenericApiNode(ZabbixApiClient apiClient, String path)
	{
		this.apiClient = apiClient;
		this.path = path;
	}
	
	@Override
	public ZabbixApiClient getApiClient()
	{
		return apiClient;
	}
	
	@Override
	public String getApiPath()
	{
		return path;
	}
	
	@Ignore
	@Override
	public ZabbixGenericApiNode nextPath(String reqName)
	{
		return new ZabbixGenericApiNode(apiClient, ("".equals(path)?"":(path+"."))+reqName);
	}

	@Ignore
	@Override
	public <T extends ZabbixApi> T cast(Class<T> cls)
	{
		AssertArgument.assertNotNull(cls, "target class");
		return ProxyDataWrapperTools.wrapAccessor(this, cls, ZabbixApiClient.MAPPER);
	}
}
