package eu.linuxengineering.snmp;

import java.util.Arrays;

import eu.javaexperience.semantic.references.MayNull;
import net.sf.snmpadaptor4j.object.SnmpOid;

public class SnmpPathDispatch
{
	protected @MayNull SnmpOid oid;
	protected int index;
	protected int[] oids;
	
	protected SnmpPathDispatch(SnmpOid oid)
	{
		this(oid, 0);
	}
	
	public SnmpPathDispatch(SnmpOid oid, int index)
	{
		this.oid = oid;
		this.oids = oid.getOid();
		this.index = index;
	}
	
	public SnmpPathDispatch(SnmpPathDispatch spd, int index)
	{
		this.oid = spd.oid;
		this.oids = spd.oids;
		this.index = index;
	}
	
	public SnmpPathDispatch(int[] oids, int index)
	{
		this.oids = oids;
		this.index = index;
	}
	
	public boolean hasNexOidPath()
	{
		return index < oids.length;
	}
	
	public Integer getCurrentPathOid()
	{
		return oids[index];
	}

	public Integer getCurrentPathIdAndGoNext()
	{
		return oids[index++];
	}

	public int getCurrentPathIndex()
	{
		return index;
	}

	public int getPathLength()
	{
		return oids.length;
	}
	
	@Override
	public String toString()
	{
		return "SnmpPathDispatch: "+Arrays.toString(oids)+", at: "+index;
	}
	
	public boolean isLastDispatch()
	{
		return index == oids.length-1;
	}

	public boolean isInvalid()
	{
		return index >= oids.length || index < 0;
	}

	public void jumpNextNode()
	{
		++index;
	}
	
	public void jumpPreviousNode()
	{
		--index;
	}

	public void setPathIndex(int i)
	{
		index = i;
	}

	public int[] copyCurrentPath()
	{
		return Arrays.copyOf(oids, index+1);
	}
}
