/*
 * Decompiled with CFR 0.152.
 */
package eu.linuxengineering.snmp;

import eu.javaexperience.log.JavaExperienceLoggingFacility;
import eu.linuxengineering.snmp.SnmpDispatchNode;
import eu.linuxengineering.snmp.SnmpFinalNode;
import eu.linuxengineering.snmp.SnmpMibDispatch;
import eu.linuxengineering.snmp.SnmpNode;
import eu.linuxengineering.snmp.SnmpTools;
import eu.linuxengineering.snmp.annotations.SnmpIndex;
import net.sf.snmpadaptor4j.api.AttributeAccessor;
import net.sf.snmpadaptor4j.object.SnmpDataType;
import net.sf.snmpadaptor4j.object.SnmpOid;
import org.junit.Assert;
import org.junit.Test;

public class SnmpDispatchTest {
    @Test
    public void testFindExact1() {
        SnmpMibDispatch disp = new SnmpMibDispatch();
        SnmpFinalNode node = SnmpTools.addRoAccessorToPath((SnmpDispatchNode)disp, (int[])new int[]{25, 10, 1}, (SnmpDataType)SnmpDataType.integer32, () -> System.currentTimeMillis(), (boolean)false);
        AttributeAccessor find = disp.find(SnmpOid.newInstance((int[])new int[]{25, 10, 1}));
        Assert.assertEquals((Object)node.getAccessor(), (Object)find);
    }

    @Test
    public void testFindExact2() {
        SnmpMibDispatch disp = new SnmpMibDispatch();
        SnmpFinalNode node = SnmpTools.addRoAccessorToPath((SnmpDispatchNode)disp, (int[])new int[]{25, 10, 1}, (SnmpDataType)SnmpDataType.integer32, () -> System.currentTimeMillis(), (boolean)false);
        AttributeAccessor find = disp.find(SnmpOid.newInstance((int[])new int[]{25, 10, 1, 0}));
        Assert.assertNull((Object)find);
    }

    @Test
    public void testFindExact3() {
        SnmpMibDispatch disp = new SnmpMibDispatch();
        SnmpFinalNode node = SnmpTools.addRoAccessorToPath((SnmpDispatchNode)disp, (int[])new int[]{25, 10, 1}, (SnmpDataType)SnmpDataType.integer32, () -> System.currentTimeMillis(), (boolean)false);
        AttributeAccessor find = disp.find(SnmpOid.newInstance((int[])new int[]{25, 10, 0}));
        Assert.assertNull((Object)find);
    }

    @Test
    public void testFindExact4() {
        SnmpMibDispatch disp = new SnmpMibDispatch();
        SnmpFinalNode node = SnmpTools.addRoAccessorToPath((SnmpDispatchNode)disp, (int[])new int[]{25, 10, 1}, (SnmpDataType)SnmpDataType.integer32, () -> System.currentTimeMillis(), (boolean)false);
        AttributeAccessor find = disp.find(SnmpOid.newInstance((int[])new int[]{25, 10, 2}));
        Assert.assertNull((Object)find);
    }

    @Test
    public void testNext1() {
        SnmpMibDispatch disp = new SnmpMibDispatch();
        SnmpFinalNode node = SnmpTools.addRoAccessorToPath((SnmpDispatchNode)disp, (int[])new int[]{25, 10, 1}, (SnmpDataType)SnmpDataType.integer32, () -> System.currentTimeMillis(), (boolean)false);
        AttributeAccessor find = disp.next(SnmpOid.newInstance((int[])new int[]{25, 10, 0}));
        Assert.assertEquals((Object)node.getAccessor(), (Object)find);
    }

    @Test
    public void testNext2() {
        SnmpMibDispatch disp = new SnmpMibDispatch();
        SnmpFinalNode node = SnmpTools.addRoAccessorToPath((SnmpDispatchNode)disp, (int[])new int[]{25, 10, 1}, (SnmpDataType)SnmpDataType.integer32, () -> System.currentTimeMillis(), (boolean)false);
        AttributeAccessor find = disp.next(SnmpOid.newInstance((int[])new int[]{25, 10, 0, 1, 100}));
        Assert.assertEquals((Object)node.getAccessor(), (Object)find);
    }

    @Test
    public void testNext3() {
        SnmpMibDispatch disp = new SnmpMibDispatch();
        SnmpFinalNode node = SnmpTools.addRoAccessorToPath((SnmpDispatchNode)disp, (int[])new int[]{25, 10, 1}, (SnmpDataType)SnmpDataType.integer32, () -> System.currentTimeMillis(), (boolean)false);
        AttributeAccessor find = disp.next(SnmpOid.newInstance((int[])new int[]{25, 10}));
        Assert.assertEquals((Object)node.getAccessor(), (Object)find);
    }

    @Test
    public void testNext4() {
        SnmpMibDispatch disp = new SnmpMibDispatch();
        SnmpFinalNode node = SnmpTools.addRoAccessorToPath((SnmpDispatchNode)disp, (int[])new int[]{25, 10, 1}, (SnmpDataType)SnmpDataType.integer32, () -> System.currentTimeMillis(), (boolean)false);
        AttributeAccessor find = disp.next(SnmpOid.newInstance((int[])new int[]{25}));
        Assert.assertEquals((Object)node.getAccessor(), (Object)find);
    }

    @Test
    public void testNext5() {
        SnmpMibDispatch disp = new SnmpMibDispatch();
        SnmpFinalNode node = SnmpTools.addRoAccessorToPath((SnmpDispatchNode)disp, (int[])new int[]{25, 10, 1}, (SnmpDataType)SnmpDataType.integer32, () -> System.currentTimeMillis(), (boolean)false);
        AttributeAccessor find = disp.next(SnmpOid.newInstance((int[])new int[]{0}));
        Assert.assertEquals((Object)node.getAccessor(), (Object)find);
    }

    @Test
    public void testNextMulti1() {
        SnmpMibDispatch disp = new SnmpMibDispatch();
        SnmpFinalNode node1 = SnmpTools.addRoAccessorToPath((SnmpDispatchNode)disp, (int[])new int[]{25, 10, 1}, (SnmpDataType)SnmpDataType.integer32, () -> System.currentTimeMillis(), (boolean)false);
        SnmpFinalNode node2 = SnmpTools.addRoAccessorToPath((SnmpDispatchNode)disp, (int[])new int[]{25, 10, 2}, (SnmpDataType)SnmpDataType.integer32, () -> System.currentTimeMillis(), (boolean)false);
        SnmpFinalNode node3 = SnmpTools.addRoAccessorToPath((SnmpDispatchNode)disp, (int[])new int[]{27}, (SnmpDataType)SnmpDataType.integer32, () -> System.currentTimeMillis(), (boolean)false);
        AttributeAccessor find = disp.next(SnmpOid.newInstance((int[])new int[]{0}));
        Assert.assertEquals((Object)node1.getAccessor(), (Object)find);
    }

    @Test
    public void testNextMulti2() {
        SnmpMibDispatch disp = new SnmpMibDispatch();
        SnmpFinalNode node1 = SnmpTools.addRoAccessorToPath((SnmpDispatchNode)disp, (int[])new int[]{25, 10, 1}, (SnmpDataType)SnmpDataType.integer32, () -> System.currentTimeMillis(), (boolean)false);
        SnmpFinalNode node2 = SnmpTools.addRoAccessorToPath((SnmpDispatchNode)disp, (int[])new int[]{25, 10, 2}, (SnmpDataType)SnmpDataType.integer32, () -> System.currentTimeMillis(), (boolean)false);
        SnmpFinalNode node3 = SnmpTools.addRoAccessorToPath((SnmpDispatchNode)disp, (int[])new int[]{27}, (SnmpDataType)SnmpDataType.integer32, () -> System.currentTimeMillis(), (boolean)false);
        AttributeAccessor find = disp.next(SnmpOid.newInstance((int[])new int[]{25, 10}));
        Assert.assertEquals((Object)node1.getAccessor(), (Object)find);
    }

    @Test
    public void testNextMulti3() {
        SnmpMibDispatch disp = new SnmpMibDispatch();
        SnmpFinalNode node1 = SnmpTools.addRoAccessorToPath((SnmpDispatchNode)disp, (int[])new int[]{25, 10, 1}, (SnmpDataType)SnmpDataType.integer32, () -> System.currentTimeMillis(), (boolean)false);
        SnmpFinalNode node2 = SnmpTools.addRoAccessorToPath((SnmpDispatchNode)disp, (int[])new int[]{25, 10, 2}, (SnmpDataType)SnmpDataType.integer32, () -> System.currentTimeMillis(), (boolean)false);
        SnmpFinalNode node3 = SnmpTools.addRoAccessorToPath((SnmpDispatchNode)disp, (int[])new int[]{27}, (SnmpDataType)SnmpDataType.integer32, () -> System.currentTimeMillis(), (boolean)false);
        AttributeAccessor find = disp.next(SnmpOid.newInstance((int[])new int[]{25, 10, 0, 0, 0, 1000}));
        Assert.assertEquals((Object)node1.getAccessor(), (Object)find);
    }

    @Test
    public void testNextMulti4() {
        SnmpMibDispatch disp = new SnmpMibDispatch();
        SnmpFinalNode node1 = SnmpTools.addRoAccessorToPath((SnmpDispatchNode)disp, (int[])new int[]{25, 10, 1}, (SnmpDataType)SnmpDataType.integer32, () -> System.currentTimeMillis(), (boolean)false);
        SnmpFinalNode node2 = SnmpTools.addRoAccessorToPath((SnmpDispatchNode)disp, (int[])new int[]{25, 10, 2}, (SnmpDataType)SnmpDataType.integer32, () -> System.currentTimeMillis(), (boolean)false);
        SnmpFinalNode node3 = SnmpTools.addRoAccessorToPath((SnmpDispatchNode)disp, (int[])new int[]{27}, (SnmpDataType)SnmpDataType.integer32, () -> System.currentTimeMillis(), (boolean)false);
        AttributeAccessor find = disp.next(SnmpOid.newInstance((int[])new int[]{25, 10, 1, 0, 0, 1000}));
        Assert.assertEquals((Object)node2.getAccessor(), (Object)find);
    }

    @Test
    public void testNextMulti5() {
        SnmpMibDispatch disp = new SnmpMibDispatch();
        SnmpFinalNode node1 = SnmpTools.addRoAccessorToPath((SnmpDispatchNode)disp, (int[])new int[]{25, 10, 1}, (SnmpDataType)SnmpDataType.integer32, () -> System.currentTimeMillis(), (boolean)false);
        SnmpFinalNode node2 = SnmpTools.addRoAccessorToPath((SnmpDispatchNode)disp, (int[])new int[]{25, 10, 2}, (SnmpDataType)SnmpDataType.integer32, () -> System.currentTimeMillis(), (boolean)false);
        SnmpFinalNode node3 = SnmpTools.addRoAccessorToPath((SnmpDispatchNode)disp, (int[])new int[]{27}, (SnmpDataType)SnmpDataType.integer32, () -> System.currentTimeMillis(), (boolean)false);
        AttributeAccessor find = disp.next(SnmpOid.newInstance((int[])new int[]{25, 10, 1}));
        Assert.assertEquals((Object)node2.getAccessor(), (Object)find);
    }

    @Test
    public void testNextMulti6() {
        SnmpMibDispatch disp = new SnmpMibDispatch();
        SnmpFinalNode node1 = SnmpTools.addRoAccessorToPath((SnmpDispatchNode)disp, (int[])new int[]{25, 10, 1}, (SnmpDataType)SnmpDataType.integer32, () -> System.currentTimeMillis(), (boolean)false);
        SnmpFinalNode node2 = SnmpTools.addRoAccessorToPath((SnmpDispatchNode)disp, (int[])new int[]{25, 10, 2}, (SnmpDataType)SnmpDataType.integer32, () -> System.currentTimeMillis(), (boolean)false);
        SnmpFinalNode node3 = SnmpTools.addRoAccessorToPath((SnmpDispatchNode)disp, (int[])new int[]{27}, (SnmpDataType)SnmpDataType.integer32, () -> System.currentTimeMillis(), (boolean)false);
        AttributeAccessor find = disp.next(SnmpOid.newInstance((int[])new int[]{26}));
        Assert.assertEquals((Object)node3.getAccessor(), (Object)find);
    }

    @Test
    public void testNextMulti7() {
        SnmpMibDispatch disp = new SnmpMibDispatch();
        SnmpFinalNode node1 = SnmpTools.addRoAccessorToPath((SnmpDispatchNode)disp, (int[])new int[]{25, 10, 1}, (SnmpDataType)SnmpDataType.integer32, () -> System.currentTimeMillis(), (boolean)false);
        SnmpFinalNode node2 = SnmpTools.addRoAccessorToPath((SnmpDispatchNode)disp, (int[])new int[]{25, 10, 2, 5, 10}, (SnmpDataType)SnmpDataType.integer32, () -> System.currentTimeMillis(), (boolean)false);
        SnmpFinalNode node3 = SnmpTools.addRoAccessorToPath((SnmpDispatchNode)disp, (int[])new int[]{27}, (SnmpDataType)SnmpDataType.integer32, () -> System.currentTimeMillis(), (boolean)false);
        AttributeAccessor find = disp.next(SnmpOid.newInstance((int[])new int[]{25, 10, 1}));
        Assert.assertEquals((Object)node2.getAccessor(), (Object)find);
    }

    @Test
    public void testNextdeadEnd() {
        SnmpMibDispatch disp = new SnmpMibDispatch();
        SnmpFinalNode node1 = SnmpTools.addRoAccessorToPath((SnmpDispatchNode)disp, (int[])new int[]{25, 10, 1}, (SnmpDataType)SnmpDataType.integer32, () -> System.currentTimeMillis(), (boolean)false);
        SnmpNode node2 = SnmpTools.wrapSnmpBean((Object)new DeadEndTester());
        SnmpTools.tryAddToPath((SnmpDispatchNode)disp, (int[])SnmpOid.newInstance((int[])new int[]{25, 10, 2, 5, 10}).getOid(), (SnmpNode)node2);
        SnmpFinalNode node3 = SnmpTools.addRoAccessorToPath((SnmpDispatchNode)disp, (int[])new int[]{27}, (SnmpDataType)SnmpDataType.integer32, () -> System.currentTimeMillis(), (boolean)false);
        AttributeAccessor find = disp.next(SnmpOid.newInstance((int[])new int[]{25, 10, 1}));
        Assert.assertEquals((Object)SnmpOid.newInstance((int[])new int[]{25, 10, 2, 5, 10, 1, 1}), (Object)find.getOid());
    }

    static {
        JavaExperienceLoggingFacility.addStdOut();
    }

    protected static class DeadEndTester {
        protected DeadEndTester() {
        }

        @SnmpIndex(index=1)
        public void noItems() {
        }
    }
}

