package eu.linuxengineering.zabbix.api;

import java.util.List;

public interface ZabbixApiScreen extends ZabbixApi
{
	public static class ZabbixScreenIds extends TargetObject
	{
		public Integer[] screenids;
	}
	
	public static class ZabbixScreenItem extends TargetObject
	{
		public Integer screenitemid;
		public Integer screenid;
		public Integer resourcetype;
		public Integer resourceid;
		public Integer width;
		public Integer height;
		public Integer x;
		public Integer y;
		public Integer colspan;
		public Integer rowspan;
		public Integer elements;
		public Integer valign;
		public Integer halign;
		public Integer style;
		public String url;
		public Integer dynamic;
		public Integer sort_triggers;
	}
	
	public static class ZabbixScreen extends TargetObject implements ZabbixParameters
	{
		public Integer screenid;
		public String name;
		public Integer hsize;
		public Integer vsize;
		public List<ZabbixScreenItem> screenitems;
		public Integer templateid;
		public Integer userid;
	}
	
	public List<ZabbixScreen> get(ZabbixParams params);
	
	public ZabbixScreenIds create(ZabbixScreen screen);
	
	public ZabbixScreenIds update(ZabbixScreen screen);
}
