/*
 * Decompiled with CFR 0.152.
 */
package eu.linuxengineering.snmp.client;

import eu.javaexperience.log.JavaExperienceLoggingFacility;
import eu.javaexperience.log.LogLevel;
import eu.javaexperience.log.Loggable;
import eu.javaexperience.log.LoggableUnitDescriptor;
import eu.javaexperience.log.Logger;
import eu.javaexperience.log.LoggingDetailLevel;
import eu.javaexperience.log.LoggingTools;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.List;
import java.util.Map;
import org.snmp4j.CommunityTarget;
import org.snmp4j.PDU;
import org.snmp4j.Session;
import org.snmp4j.Snmp;
import org.snmp4j.Target;
import org.snmp4j.TransportMapping;
import org.snmp4j.event.ResponseEvent;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.GenericAddress;
import org.snmp4j.smi.Null;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.UdpAddress;
import org.snmp4j.smi.Variable;
import org.snmp4j.smi.VariableBinding;
import org.snmp4j.transport.DefaultUdpTransportMapping;
import org.snmp4j.util.DefaultPDUFactory;
import org.snmp4j.util.PDUFactory;
import org.snmp4j.util.TreeEvent;
import org.snmp4j.util.TreeUtils;

public class SnmpClient
implements Closeable {
    protected static final Logger LOG = JavaExperienceLoggingFacility.getLogger((LoggableUnitDescriptor)new Loggable("SnmpClient"));
    protected String address = null;
    protected TransportMapping<UdpAddress> transport;
    protected Snmp snmp = null;

    public SnmpClient(String address) {
        this.address = address;
    }

    public SnmpClient(InetSocketAddress sa) {
        this.address = "udp:" + sa.getHostString() + "/" + sa.getPort();
    }

    public void start() throws IOException {
        this.transport = new DefaultUdpTransportMapping();
        this.snmp = new Snmp(this.transport);
        this.transport.listen();
    }

    @Override
    public void close() throws IOException {
        this.transport.close();
    }

    public String getAsString(OID oid) throws IOException {
        ResponseEvent event = this.get(new OID[]{oid});
        Variable var = event.getResponse().get(0).getVariable();
        if (var instanceof Null) {
            return null;
        }
        return var.toString();
    }

    public ResponseEvent get(OID[] oids) throws IOException {
        PDU pdu = new PDU();
        for (OID oid : oids) {
            pdu.add(new VariableBinding(oid));
        }
        pdu.setType(-96);
        ResponseEvent event = this.snmp.send(pdu, this.getTarget(), null);
        if (event != null) {
            return event;
        }
        throw new RuntimeException("GET timed out");
    }

    protected Target getTarget() {
        Address targetAddress = GenericAddress.parse((String)this.address);
        CommunityTarget target = new CommunityTarget();
        target.setCommunity(new OctetString("public"));
        target.setAddress(targetAddress);
        target.setRetries(2);
        target.setTimeout(1500L);
        target.setVersion(1);
        return target;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int walkSubtree(OID oid, Map<OID, Variable> result) throws IOException {
        int add = 0;
        DefaultUdpTransportMapping transport = new DefaultUdpTransportMapping();
        try (Snmp snmp = new Snmp((TransportMapping)transport);){
            transport.listen();
            TreeUtils treeUtils = new TreeUtils((Session)snmp, (PDUFactory)new DefaultPDUFactory());
            List events = treeUtils.getSubtree(this.getTarget(), oid);
            if (events == null || events.size() == 0) {
                LoggingTools.tryLogFormat((Logger)LOG, (LoggingDetailLevel)LogLevel.WARNING, (String)"Unable to read table `%s`", (Object)oid);
                throw new RuntimeException("Unable to read table at " + oid);
            }
            for (TreeEvent event : events) {
                if (event == null) continue;
                if (event.isError()) {
                    LoggingTools.tryLogFormat((Logger)LOG, (LoggingDetailLevel)LogLevel.WARNING, (String)"table OID `%s` message: `%s`", (Object)oid, (Object)event.getErrorMessage());
                    continue;
                }
                VariableBinding[] varBindings = event.getVariableBindings();
                if (varBindings == null || varBindings.length == 0) continue;
                for (VariableBinding varBinding : varBindings) {
                    if (varBinding == null) continue;
                    ++add;
                    result.put(varBinding.getOid(), varBinding.getVariable());
                }
            }
        }
        return add;
    }
}

