/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.mdsite.cli;

import eu.javaexperience.cli.CliEntry;
import eu.javaexperience.cli.CliTools;
import eu.javaexperience.io.IOTools;
import eu.javaexperience.io.file.FileTools;
import eu.javaexperience.log.JavaExperienceLoggingFacility;
import eu.javaexperience.log.LogLevel;
import eu.javaexperience.log.Loggable;
import eu.javaexperience.log.LoggableUnitDescriptor;
import eu.javaexperience.log.Logger;
import eu.javaexperience.log.LoggingDetailLevel;
import eu.javaexperience.log.LoggingTools;
import eu.javaexperience.mdsite.MdRenderContext;
import eu.javaexperience.mdsite.cli.MdSiteCliCommons;
import eu.javaexperience.text.Format;
import eu.javaexperience.text.StringTools;
import java.io.File;
import java.util.Date;
import java.util.Map;
import java.util.Properties;

public class MdsiteCompileCli {
    protected static final Logger LOG = JavaExperienceLoggingFacility.getLogger((LoggableUnitDescriptor)new Loggable("MdsiteCompileCli"));
    protected static final CliEntry[] COMPILE_CLI_ARGS = new CliEntry[]{MdSiteCliCommons.CLI_DIR, MdSiteCliCommons.CLI_TARGET, MdSiteCliCommons.CLI_CONFIG, MdSiteCliCommons.CLI_FORCE};

    public static void main(String ... args) throws Throwable {
        String to;
        String from;
        Map opts = CliTools.storeCliOptions((boolean)true, (String[])args);
        boolean fail = false;
        String sw = CliTools.getFirstUnknownParam((Map)opts, (CliEntry[])COMPILE_CLI_ARGS);
        if (null != sw) {
            System.err.println("Unknown Cli option: " + sw);
            fail = true;
        }
        if (null == (from = (String)MdSiteCliCommons.CLI_DIR.tryParse(opts))) {
            System.err.println("Source directory (-d) not specified!");
            fail = true;
        }
        if (null == (to = (String)MdSiteCliCommons.CLI_TARGET.tryParse(opts))) {
            System.err.println("Target directory (-t) not specified!");
            fail = true;
        }
        if (fail) {
            CliTools.printHelpAndExit((String)"MdSite.compile", (int)2, (CliEntry[])COMPILE_CLI_ARGS);
        }
        String cfg = (String)MdSiteCliCommons.CLI_CONFIG.tryParseOrDefault(opts, (Object)"main.mds");
        File cfgFile = new File(from + "/" + cfg);
        if (!cfgFile.exists()) {
            System.err.println("main.mds file doesn't exist at: " + cfgFile);
            System.exit(1);
        }
        Properties prop = MdRenderContext.loadProperties(cfgFile.toString());
        MdRenderContext ctx = MdRenderContext.createContext(from + "/", cfg, prop);
        String extension = ctx.getTargetFileExtension();
        boolean forceCompile = MdSiteCliCommons.CLI_FORCE.hasOption(opts);
        FileTools.translateFiles((boolean)true, (File)ctx.getSourceDir(), (File)new File(to), (f, t) -> {
            if (f.isFile() && f.toString().endsWith(".md")) {
                try {
                    LoggingTools.tryLogFormat((Logger)LOG, (LoggingDetailLevel)LogLevel.DEBUG, (String)"Visiting source file: `%s`", (Object)f);
                    String dst = StringTools.getSubstringBeforeLastString((String)t.toString(), (String)".md") + (null == extension ? "" : "." + extension);
                    t = new File(dst);
                    long srcMod = Math.max(ctx.lastModify, f.lastModified());
                    if (LOG.mayLog((LoggingDetailLevel)LogLevel.DEBUG)) {
                        LoggingTools.tryLogFormat((Logger)LOG, (LoggingDetailLevel)LogLevel.DEBUG, (String)"Source last modified: `%s`, Destination file `%s` last modified: `%s`, force recompile: %s", (Object[])new Object[]{Format.SQL_TIMESTAMP.format(new Date(srcMod)), dst, 0L == t.lastModified() ? "0" : Format.SQL_TIMESTAMP.format(new Date(t.lastModified())), forceCompile});
                    }
                    srcMod = Math.max(srcMod, ctx.lastModify);
                    if (!t.exists() || srcMod > t.lastModified() || forceCompile) {
                        IOTools.putFileContent((String)dst, (byte[])ctx.renderContent(IOTools.getFileContents((File)f)).getBytes());
                        t.setLastModified(srcMod);
                    }
                }
                catch (Exception e) {
                    System.err.println("Exception while processing file: " + f);
                    e.printStackTrace();
                }
            }
        });
    }
}

