/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.mdsite;

import eu.javaexperience.collection.map.MapTools;
import eu.javaexperience.collection.map.SmallMap;
import eu.javaexperience.interfaces.simple.getBy.GetBy1;
import eu.javaexperience.io.IOTools;
import eu.javaexperience.log.JavaExperienceLoggingFacility;
import eu.javaexperience.log.LogLevel;
import eu.javaexperience.log.Loggable;
import eu.javaexperience.log.LoggableUnitDescriptor;
import eu.javaexperience.log.Logger;
import eu.javaexperience.log.LoggingDetailLevel;
import eu.javaexperience.log.LoggingTools;
import eu.javaexperience.reflect.CastTo;
import eu.javaexperience.text.Format;
import eu.javaexperience.text.StringTools;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.commonmark.Extension;
import org.commonmark.ext.gfm.strikethrough.StrikethroughExtension;
import org.commonmark.ext.gfm.tables.TablesExtension;
import org.commonmark.parser.Parser;
import org.commonmark.renderer.html.HtmlRenderer;

public class MdRenderContext
implements Cloneable {
    protected static final Logger LOG = JavaExperienceLoggingFacility.getLogger((LoggableUnitDescriptor)new Loggable("MdRenderContext"));
    public String rootDir;
    public Properties props;
    public GetBy1<String, String> render;
    public List<GetBy1<String, String>> processors = new ArrayList<GetBy1<String, String>>();
    public long lastModify = 0L;
    public String cfgFile;
    private static final ThreadLocal<MdRenderContext> THREAD_CONTEXT = new ThreadLocal();
    protected static final Pattern FIND_HREFS = Pattern.compile("href\\s*=\\s*\\\"(?<url>[^\"]+)\\\"");
    protected static final Pattern FIND_EXTERNSION = Pattern.compile("(?<file>.*)(?<ext>\\.md)(?<post>($|#|\\?).*)", 2);

    public MdRenderContext(MdRenderContext ctx) {
        this.rootDir = ctx.rootDir;
        this.props = new Properties(ctx.props);
        this.render = ctx.render;
        this.processors.addAll(ctx.processors);
        this.lastModify = ctx.lastModify;
        this.cfgFile = ctx.cfgFile;
    }

    public void init() throws FileNotFoundException, IOException {
        String wrapperFile = StringTools.toStringOrNull((Object)this.props.get("wrapper"));
        if (null != wrapperFile) {
            String file = this.getSourceDir() + "/" + StringTools.getSubstringBeforeFirstString((String)wrapperFile, (String)"?", (String)wrapperFile);
            String _replace = StringTools.getSubstringAfterFirstString((String)wrapperFile, (String)"?", null);
            if (null == _replace) {
                throw new RuntimeException("No replacement variable specified at the wrapper in the `" + this.cfgFile + "`. Use this form: wrapper=index.html?body_content");
            }
            String replace = "$" + _replace;
            File wf = new File(file);
            if (!wf.exists()) {
                LoggingTools.tryLogFormat((Logger)LOG, (LoggingDetailLevel)LogLevel.WARNING, (String)"Specified wrapper file `%s` doesn't exists", (Object)file);
            } else {
                this.lastModify = wf.lastModified();
                LoggingTools.tryLogFormat((Logger)LOG, (LoggingDetailLevel)LogLevel.DEBUG, (String)"Wrapper file last modification date: %s", (Object)Format.SQL_TIMESTAMP.format(new Date(this.lastModify)));
                String wrapper = IOTools.getFileContents((String)file);
                this.processors.add((GetBy1<String, String>)((GetBy1)src -> StringTools.replaceAllStrings((String)wrapper, (String)replace, (String)src)));
            }
        } else {
            LoggingTools.tryLogFormat((Logger)LOG, (LoggingDetailLevel)LogLevel.INFO, (String)"No wrapper file specified", (Object)wrapperFile);
        }
    }

    public MdRenderContext() {
    }

    public MdRenderContext clone() {
        return new MdRenderContext(this);
    }

    public static GetBy1<String, String> createDefaultRenderer() {
        ArrayList<Extension> extensions = new ArrayList<Extension>();
        extensions.add(TablesExtension.create());
        extensions.add(StrikethroughExtension.create());
        Parser parser = Parser.builder().extensions(extensions).build();
        HtmlRenderer renderer = HtmlRenderer.builder().extensions(extensions).build();
        return a -> renderer.render(parser.parse(a));
    }

    public String renderContent(String content) {
        String ret = (String)this.render.getBy((Object)content);
        for (GetBy1<String, String> p : this.processors) {
            ret = (String)p.getBy((Object)ret);
        }
        return ret;
    }

    public File getSourceDir() throws IOException {
        String add = StringTools.toStringOrNull((Object)this.props.get("md_root_dir"));
        if (null == add) {
            return new File(this.rootDir).getCanonicalFile();
        }
        return new File(this.rootDir + add).getCanonicalFile();
    }

    public static MdRenderContext getCurrentRenderContext() {
        return THREAD_CONTEXT.get();
    }

    public static MdRenderContext ensureGetCurrentRpcSession() {
        MdRenderContext ret = MdRenderContext.getCurrentRenderContext();
        if (null == ret) {
            throw new RuntimeException("No MdRenderContext associated with the current processor thread.");
        }
        return ret;
    }

    public static void setCurrentRenderContext(MdRenderContext ctx) {
        THREAD_CONTEXT.set(ctx);
    }

    public String getTargetFileExtension() {
        String extension = this.props.getProperty("target_file_extension");
        if (null == extension) {
            extension = "md";
        } else if (extension.length() == 0) {
            extension = "";
        }
        return extension;
    }

    public static MdRenderContext createContext(String root, String cfgFile, Properties prop) throws IOException {
        MdRenderContext ctx = new MdRenderContext();
        ctx.render = ctx.createRenderer();
        ctx.cfgFile = cfgFile;
        ctx.props = prop;
        ctx.rootDir = root;
        ctx.init();
        return ctx;
    }

    public boolean isRewriteInternalLinkHrefs() {
        return Boolean.TRUE == CastTo.Boolean.cast(this.props.get("rewrite_internal_link_href"));
    }

    public static boolean isFullUrl(String str) {
        try {
            new URL(str);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public GetBy1<String, String> createRenderer() {
        GetBy1<String, String> def = MdRenderContext.createDefaultRenderer();
        return s -> {
            String te;
            s = (String)def.getBy(s);
            if (this.isRewriteInternalLinkHrefs() && !"md".equals(te = this.getTargetFileExtension())) {
                SmallMap ft = new SmallMap();
                Matcher m = FIND_HREFS.matcher((CharSequence)s);
                while (m.find()) {
                    Matcher em;
                    String url = m.group("url");
                    if (MdRenderContext.isFullUrl(url)) continue;
                    if (LOG.mayLog((LoggingDetailLevel)LogLevel.DEBUG)) {
                        LoggingTools.tryLogFormat((Logger)LOG, (LoggingDetailLevel)LogLevel.DEBUG, (String)"Link found: `%s`", (Object)url);
                    }
                    if (!(em = FIND_EXTERNSION.matcher(url)).find()) continue;
                    ft.put(em.group(0), em.group("file") + "." + te + em.group("post"));
                }
                if (LOG.mayLog((LoggingDetailLevel)LogLevel.DEBUG)) {
                    LoggingTools.tryLogFormat((Logger)LOG, (LoggingDetailLevel)LogLevel.DEBUG, (String)"Rewriting urls: %s", (Object)MapTools.toStringMultiline((Map)ft));
                }
                s = StringTools.multiReplaceAllString((String)s, (Map)ft);
            }
            return s;
        };
    }

    /*
     * Exception decompiling
     */
    public static Properties loadProperties(String propFile) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

