/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.mdsite.cli;

import eu.javaexperience.cli.CliEntry;
import eu.javaexperience.cli.CliTools;
import eu.javaexperience.interfaces.simple.getBy.GetBy1;
import eu.javaexperience.io.IOTools;
import eu.javaexperience.io.file.FileTools;
import eu.javaexperience.log.JavaExperienceLoggingFacility;
import eu.javaexperience.log.Loggable;
import eu.javaexperience.log.LoggableUnitDescriptor;
import eu.javaexperience.log.Logger;
import eu.javaexperience.mdsite.MdRenderContext;
import eu.javaexperience.mdsite.cli.MdSiteCliCommons;
import eu.javaexperience.text.StringFunctions;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;

public class MdsiteCgiCli {
    protected static final Logger LOG = JavaExperienceLoggingFacility.getLogger((LoggableUnitDescriptor)new Loggable("MdsiteCgiCli"));
    public static final CliEntry<String> CLI_CGI_HEADER = CliEntry.createFirstArgParserEntry((GetBy1)StringFunctions.PASS_TROUGHT, (String)"Print headers before content eg.: (-h \"Content-type: text/html;charset=utf-8\\nGenerated-with: MdSite\")", (String[])new String[]{"h", "-cgi-headers"});
    public static final CliEntry<String> CLI_FILE = CliEntry.createFirstArgParserEntry((GetBy1)StringFunctions.PASS_TROUGHT, (String)"The file to compile. This is the last CLI switch when using as CGI.Specify shebang like this: `#!/usr/bin/env -S MDSITE_REWRITE_HREF=false mdsite cgi -h \"Content-type: text/html;charset=utf-8\\n\" -f`", (String[])new String[]{"f", "-file"});
    protected static final CliEntry[] COMPILE_CLI_ARGS = new CliEntry[]{CLI_CGI_HEADER, MdSiteCliCommons.CLI_CONFIG, CLI_FILE};

    protected static File findConfig(String anchor, String cfg) throws IOException {
        File f = new File(anchor).getCanonicalFile();
        if (null == f) {
            return null;
        }
        f = FileTools.getDirectory((File)f);
        File c = null;
        do {
            if (!(c = new File(f + "/" + cfg)).exists()) continue;
            return c;
        } while (null != (f = f.getParentFile()));
        return null;
    }

    public static void main(String[] args) throws Throwable {
        String cfg;
        File cfgFile;
        String file;
        Map opts = CliTools.storeCliOptions((boolean)true, (String[])args);
        boolean fail = false;
        String sw = CliTools.getFirstUnknownParam((Map)opts, (CliEntry[])COMPILE_CLI_ARGS);
        if (null != sw) {
            System.err.println("Unknown Cli option: " + sw);
            fail = true;
        }
        if (null == (file = (String)CLI_FILE.tryParse(opts))) {
            System.err.println("No source file specified!");
            fail = true;
        }
        String header = (String)CLI_CGI_HEADER.tryParseOrDefault(opts, null);
        if (fail) {
            CliTools.printHelpAndExit((String)"MdSite.cgi", (int)2, (CliEntry[])COMPILE_CLI_ARGS);
        }
        if (null == (cfgFile = MdsiteCgiCli.findConfig(file, cfg = (String)MdSiteCliCommons.CLI_CONFIG.tryParseOrDefault(opts, (Object)"main.mds"))) || !cfgFile.exists()) {
            System.err.println("main.mds file doesn't exist at: " + cfgFile);
            System.exit(1);
        }
        if (null != header) {
            System.out.println(header);
        }
        Properties prop = MdRenderContext.loadProperties(cfgFile.toString());
        MdRenderContext ctx = MdRenderContext.createContext(cfgFile.getParent() + "/", cfg, prop);
        System.out.println(ctx.renderContent(IOTools.getFileContents((String)file)));
    }
}

