/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.algorithm.search.graph;

import eu.javaexperience.algorithm.search.graph.GraphSearchVertexTransition;
import eu.javaexperience.asserts.AssertArgument;
import eu.javaexperience.exceptions.IllegalOperationException;
import eu.javaexperience.reflect.Mirror;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class GraphPath<V, E>
implements Cloneable,
Iterable<GraphSearchVertexTransition<V, E>> {
    protected GraphSearchVertexTransition<V, E> first;
    protected GraphSearchVertexTransition<V, E> last;
    protected int transitions = 0;
    protected int hashCode = 0;

    public GraphSearchVertexTransition<V, E> addInitialVertext(V init) {
        AssertArgument.assertNotNull(init, "Vertex");
        if (null != this.first || null != this.last) {
            throw new IllegalStateException("GraphPath is already initalized");
        }
        ++this.transitions;
        this.last = new GraphSearchVertexTransition<V, Object>(this, init, null, init);
        this.first = this.last;
        return this.last;
    }

    protected GraphPath<V, E> clone() throws CloneNotSupportedException {
        GraphPath ret = (GraphPath)super.clone();
        GraphSearchVertexTransition<V, E> crnt = this.first;
        if (null != crnt) {
            GraphSearchVertexTransition build;
            ret.first = build = (GraphSearchVertexTransition)crnt.clone();
            build.setOwner(ret);
            while (null != (crnt = crnt.next)) {
                GraphSearchVertexTransition n = (GraphSearchVertexTransition)crnt.clone();
                n.setOwner(ret);
                build.next = n;
                n.prev = build;
                build = n;
            }
            ret.last = build;
        }
        return ret;
    }

    protected void registerFirst(GraphSearchVertexTransition<V, E> first) {
        if (first.next != this.first) {
            throw new IllegalOperationException("Bad chaining, new first Node is not pointed to the current first Node");
        }
        ++this.transitions;
        this.first = first;
    }

    public void registerLast(GraphSearchVertexTransition<V, E> last) {
        if (last.prev != this.last) {
            throw new IllegalOperationException("Bad chaining, new last Node is not pointed to the current last Node");
        }
        ++this.transitions;
        this.last = last;
    }

    public int getTransitionsCount() {
        return this.transitions;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("GraphPath: ");
        GraphSearchVertexTransition<V, E> crnt = this.first;
        if (null != crnt) {
            sb.append("[");
            sb.append(crnt.getFrom());
            sb.append("]");
            if (!crnt.isInitial()) {
                do {
                    sb.append(" ---");
                    sb.append(crnt.getEdge());
                    sb.append("---> [");
                    sb.append(crnt.getTo());
                    sb.append("]");
                } while (null != (crnt = crnt.next));
            }
        }
        return sb.toString();
    }

    protected void reOwn(GraphPath<V, E> owner) {
        GraphSearchVertexTransition<V, E> crnt = this.first;
        if (null != crnt) {
            crnt.setOwner(owner);
            while (null != (crnt = crnt.next)) {
                crnt.setOwner(owner);
            }
        }
    }

    public GraphPath<V, E> merge(GraphPath<V, E> with) {
        if (!this.last.getTo().equals(with.first.getFrom())) {
            throw new IllegalOperationException("Can't merge path " + this + " to " + with);
        }
        try {
            Object ret = this.clone();
            Object w = with.clone();
            ((GraphPath)ret).last.next = ((GraphPath)w).first;
            ((GraphPath)ret).last = ((GraphPath)w).last;
            ((GraphPath)w).reOwn((GraphPath<V, E>)ret);
            ((GraphPath)ret).transitions = this.transitions + ((GraphPath)w).transitions;
            return ret;
        }
        catch (CloneNotSupportedException e) {
            Mirror.propagateAnyway(e);
            return null;
        }
    }

    public GraphSearchVertexTransition<V, E> getFirst() {
        return this.first;
    }

    public GraphSearchVertexTransition<V, E> getLast() {
        return this.last;
    }

    @Override
    public Iterator<GraphSearchVertexTransition<V, E>> iterator() {
        return new Iterator<GraphSearchVertexTransition<V, E>>(){
            GraphSearchVertexTransition<V, E> crnt = null;

            protected GraphSearchVertexTransition<V, E> getNext() {
                return null == this.crnt ? GraphPath.this.first : this.crnt.next;
            }

            @Override
            public boolean hasNext() {
                return null != this.getNext();
            }

            @Override
            public GraphSearchVertexTransition<V, E> next() {
                this.crnt = this.getNext();
                if (null == this.crnt) {
                    throw new NoSuchElementException("GraphPath has no more Transition");
                }
                return this.crnt;
            }
        };
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof GraphPath)) {
            return false;
        }
        GraphPath other = (GraphPath)obj;
        if (this.transitions != other.transitions) {
            return false;
        }
        if (!this.first.equals(other.first)) {
            return false;
        }
        if (!this.last.equals(other.last)) {
            return false;
        }
        GraphSearchVertexTransition<V, E> tr = this.first;
        GraphSearchVertexTransition<V, E> otr = other.first;
        while (null != tr) {
            if (!tr.equals(otr)) {
                return false;
            }
            tr = tr.next;
        }
        return true;
    }

    public int hashCode() {
        if (0 == this.hashCode) {
            int ret = 27;
            GraphSearchVertexTransition<V, E> tr = this.first;
            while (null != tr) {
                ret = 31 * ret + tr.hashCode();
                tr = tr.next;
            }
            this.hashCode = ret;
        }
        return this.hashCode;
    }
}

