/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.algorithm.search.graph;

import eu.javaexperience.algorithm.search.graph.GraphSearchAlgorithm;
import eu.javaexperience.algorithm.search.graph.GraphSearchAlgorithms;
import eu.javaexperience.algorithm.search.graph.GraphSearchDirection;
import eu.javaexperience.algorithm.search.graph.GraphSearchTraveledPath;
import eu.javaexperience.algorithm.search.graph.GraphSearcher;
import eu.javaexperience.asserts.AssertArgument;
import eu.javaexperience.exceptions.UnimplementedCaseException;
import eu.javaexperience.interfaces.simple.getBy.GetBy1;
import eu.javaexperience.interfaces.simple.publish.SimplePublish2;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;

public class GraphSearchAlgorithmBuilder<V, E> {
    public GraphSearchDirection searchDirection = GraphSearchDirection.FORWARD;
    public ArrayList<GetBy1<Boolean, Map.Entry<GraphSearchTraveledPath<V, E>, V>>> extendFilters = new ArrayList();
    public Comparator<Map.Entry<GraphSearchTraveledPath<V, E>, Map.Entry<E, V>>> orderExtends = null;
    public SimplePublish2<List<Map.Entry<GraphSearchTraveledPath<V, E>, Map.Entry<E, V>>>, Collection<Map.Entry<GraphSearchTraveledPath<V, E>, Map.Entry<E, V>>>> extendSelector;

    public GraphSearchAlgorithm<V, E> build() {
        final SimplePublish2<List<Map.Entry<GraphSearchTraveledPath<V, E>, Map.Entry<E, V>>>, Collection<Map.Entry<GraphSearchTraveledPath<V, E>, Map.Entry<E, V>>>> extendSelector = this.extendSelector;
        AssertArgument.assertNotNull(extendSelector, "ExtendSelector must be given, so ");
        final GraphSearchDirection searchDirection = this.searchDirection;
        final ArrayList extendFilters = (ArrayList)this.extendFilters.clone();
        final Comparator<Map.Entry<GraphSearchTraveledPath<V, E>, Map.Entry<E, V>>> orderExtends = this.orderExtends;
        return new GraphSearchAlgorithm<V, E>(){

            @Override
            public void initSearch(GraphSearcher<V, E> search) {
                switch (searchDirection) {
                    case BACKWARD: {
                        search.initBackwardSearch();
                        break;
                    }
                    case BIDIRECTIONAL: {
                        search.initTwoSideSearch();
                        break;
                    }
                    case FORWARD: {
                        search.initForwardSearch();
                        break;
                    }
                    default: {
                        throw new UnimplementedCaseException(searchDirection);
                    }
                }
            }

            @Override
            public boolean mergeBranches(GraphSearcher<V, E> search, List<Map.Entry<GraphSearchTraveledPath<V, E>, GraphSearchTraveledPath<V, E>>> mergePairs) {
                if (searchDirection == GraphSearchDirection.BIDIRECTIONAL) {
                    return GraphSearchAlgorithms.mergeBranches(search, mergePairs);
                }
                return false;
            }

            @Override
            public void extendSearchFront(GraphSearcher<V, E> search, List<Map.Entry<GraphSearchTraveledPath<V, E>, Map.Entry<E, V>>> possibleExtends, Collection<Map.Entry<GraphSearchTraveledPath<V, E>, Map.Entry<E, V>>> selectedExtends, Collection<Map.Entry<GraphSearchTraveledPath<V, E>, Map.Entry<E, V>>> closedExtends) {
                ArrayList select = new ArrayList();
                block0: for (Map.Entry p : possibleExtends) {
                    for (GetBy1 f : extendFilters) {
                        Boolean ret = (Boolean)f.getBy(p);
                        if (Boolean.FALSE == ret) {
                            closedExtends.add(p);
                            continue block0;
                        }
                        if (Boolean.TRUE != ret) continue;
                        select.add(p);
                        continue block0;
                    }
                }
                if (null != orderExtends) {
                    Collections.sort(select, orderExtends);
                }
                extendSelector.publish(select, selectedExtends);
            }
        };
    }

    public GraphSearchDirection getSearchDirection() {
        return this.searchDirection;
    }

    public void setSearchDirection(GraphSearchDirection searchDirection) {
        this.searchDirection = searchDirection;
    }
}

