/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.algorithm.search.graph;

import eu.javaexperience.algorithm.search.graph.GraphSearchAlgorithm;
import eu.javaexperience.algorithm.search.graph.GraphSearchController;
import eu.javaexperience.algorithm.search.graph.GraphSearchDirection;
import eu.javaexperience.algorithm.search.graph.GraphSearchPhase;
import eu.javaexperience.algorithm.search.graph.GraphSearchSubject;
import eu.javaexperience.algorithm.search.graph.GraphSearchTraveledPath;
import eu.javaexperience.algorithm.search.graph.GraphSearchVisitor;
import eu.javaexperience.collection.CollectionReadOnlyFunctions;
import eu.javaexperience.collection.CollectionTools;
import eu.javaexperience.collection.ReadOnlyAndRwCollection;
import eu.javaexperience.collection.map.KeyVal;
import eu.javaexperience.collection.map.SmallMap;
import eu.javaexperience.interfaces.ExternalDataAttached;
import eu.javaexperience.semantic.references.MayNotNull;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class GraphSearcher<V, E>
implements ExternalDataAttached {
    protected GraphSearchAlgorithm<V, E> algorithm;
    protected GraphSearchSubject<V, E> subject;
    protected GraphSearchVisitor<V, E> visitor;
    protected GraphSearchController<V, E> controller;
    protected ReadOnlyAndRwCollection<List<V>> startVertexes = new ReadOnlyAndRwCollection<List>(new ArrayList(), CollectionReadOnlyFunctions.MAKE_LIST_READ_ONLY);
    protected ReadOnlyAndRwCollection<List<V>> destinationVertexes = new ReadOnlyAndRwCollection<List>(new ArrayList(), CollectionReadOnlyFunctions.MAKE_LIST_READ_ONLY);
    protected ReadOnlyAndRwCollection<Collection<GraphSearchTraveledPath<V, E>>> closedBranches = new ReadOnlyAndRwCollection<Set>(GraphSearcher.createSet(), CollectionReadOnlyFunctions.MAKE_SET_READ_ONLY);
    protected ReadOnlyAndRwCollection<Collection<GraphSearchTraveledPath<V, E>>> openBranches = new ReadOnlyAndRwCollection<Set>(GraphSearcher.createSet(), CollectionReadOnlyFunctions.MAKE_SET_READ_ONLY);
    protected ReadOnlyAndRwCollection<Collection<GraphSearchTraveledPath<V, E>>> solutions = new ReadOnlyAndRwCollection<Set>(GraphSearcher.createSet(), CollectionReadOnlyFunctions.MAKE_SET_READ_ONLY);
    protected boolean searchStarted = false;
    protected boolean noMoreSolution = false;
    protected int iteration;
    protected Map<String, Object> extraData;

    protected static Set createSet() {
        return Collections.newSetFromMap(new IdentityHashMap());
    }

    public GraphSearcher(GraphSearchAlgorithm<V, E> algorithm, GraphSearchSubject<V, E> subject, GraphSearchController<V, E> controller) {
        this.algorithm = algorithm;
        this.subject = subject;
        this.controller = controller;
    }

    public void setVisitor(GraphSearchVisitor<V, E> visitor) {
        this.visitor = visitor;
    }

    protected void addBranchStart(V point, GraphSearchDirection dir) {
        GraphSearchTraveledPath add = new GraphSearchTraveledPath(this, dir);
        add.path.addInitialVertext(point);
        this.openBranches.getWriteable().add(add);
    }

    public void initForwardSearch() {
        this.assertSearchNotStarted();
        for (V v : this.startVertexes.getReadOnly()) {
            this.addBranchStart(v, GraphSearchDirection.FORWARD);
        }
    }

    public void initTwoSideSearch() {
        this.assertSearchNotStarted();
        for (V v : this.startVertexes.getReadOnly()) {
            this.addBranchStart(v, GraphSearchDirection.FORWARD);
        }
        for (V v : this.destinationVertexes.getReadOnly()) {
            this.addBranchStart(v, GraphSearchDirection.BACKWARD);
        }
    }

    public void initBackwardSearch() {
        this.assertSearchNotStarted();
        for (V v : this.destinationVertexes.getReadOnly()) {
            this.addBranchStart(v, GraphSearchDirection.BACKWARD);
        }
    }

    public boolean isMoreSolutionPossible() {
        return !this.noMoreSolution;
    }

    public void assertSearchNotStarted() {
        if (this.searchStarted) {
            throw new RuntimeException("Search already started");
        }
    }

    public void setStartVertexes(V ... from) {
        this.assertSearchNotStarted();
        CollectionTools.copyInto(from, this.startVertexes.getWriteable());
    }

    public void setDestinationVertexes(V ... to) {
        this.assertSearchNotStarted();
        CollectionTools.copyInto(to, this.destinationVertexes.getWriteable());
    }

    public Collection<GraphSearchTraveledPath<V, E>> getSolutions() {
        return this.solutions.getReadOnly();
    }

    public Collection<GraphSearchTraveledPath<V, E>> getOpenBranches() {
        return this.openBranches.getReadOnly();
    }

    public Collection<GraphSearchTraveledPath<V, E>> getClosedBranches() {
        return this.closedBranches.getReadOnly();
    }

    public List<GraphSearchTraveledPath<V, E>> getAllBranches() {
        ArrayList<GraphSearchTraveledPath<V, GraphSearchTraveledPath<V, E>>> ret = new ArrayList<GraphSearchTraveledPath<V, GraphSearchTraveledPath<V, E>>>();
        ret.addAll(this.solutions.getReadOnly());
        ret.addAll(this.openBranches.getReadOnly());
        ret.addAll(this.closedBranches.getReadOnly());
        return ret;
    }

    public void continueSearch() {
        this.continueSearch(false);
    }

    public void continueSearch(boolean stepping) {
        if (!this.searchStarted) {
            this.visitAtPoint(true, GraphSearchPhase.INITALIZE);
            this.algorithm.initSearch(this);
            this.visitAtPoint(false, GraphSearchPhase.INITALIZE);
        }
        this.searchStarted = true;
        ArrayList<Map.Entry<GraphSearchTraveledPath<V, E>, Map.Entry<E, V>>> possibleExtends = new ArrayList<Map.Entry<GraphSearchTraveledPath<V, E>, Map.Entry<E, V>>>();
        Set closedExtends = GraphSearcher.createSet();
        ArrayList mergePairs = new ArrayList();
        this.visitAtPoint(true, GraphSearchPhase.CONTINUE);
        boolean step = true;
        while (step && this.isMoreSolutionPossible() && this.controller.needContinueSearch(this)) {
            if (stepping) {
                step = false;
            }
            possibleExtends.clear();
            mergePairs.clear();
            this.visitAtPoint(true, GraphSearchPhase.CHECK_FOR_SOLUTION);
            if (this.examineSolutions()) {
                this.visitAtPoint(true, GraphSearchPhase.EXIT_BY_CONTROLLER);
                return;
            }
            this.visitAtPoint(true, GraphSearchPhase.MERGE_BRANCH);
            if (this.algorithm.mergeBranches(this, mergePairs)) {
                this.executeMerges(mergePairs);
                if (this.examineSolutions()) {
                    this.visitAtPoint(true, GraphSearchPhase.EXIT_BY_CONTROLLER);
                    return;
                }
            }
            this.visitAtPoint(false, GraphSearchPhase.MERGE_BRANCH);
            this.visitAtPoint(true, GraphSearchPhase.EXTEND_SEARCH_FRONT);
            ++this.iteration;
            this.fillPossibleExtends(possibleExtends);
            if (possibleExtends.isEmpty()) {
                this.noMoreSolution = true;
                this.visitAtPoint(true, GraphSearchPhase.EXIT_NO_MORE_SOLUTION);
                return;
            }
            Set selectedExtends = GraphSearcher.createSet();
            this.algorithm.extendSearchFront(this, possibleExtends, selectedExtends, closedExtends);
            closedExtends.removeAll(selectedExtends);
            this.publishToExtend(possibleExtends, selectedExtends, closedExtends);
            for (Map.Entry c : closedExtends) {
                ((GraphSearchTraveledPath)c.getKey()).processedNeighborVertexes.add(c.getValue());
                this.tryRemoveClosedBranch((GraphSearchTraveledPath)c.getKey());
            }
            if (selectedExtends.isEmpty()) {
                this.noMoreSolution = true;
                this.visitAtPoint(true, GraphSearchPhase.EXIT_NO_MORE_SOLUTION);
                return;
            }
            Collection<GraphSearchTraveledPath<V, GraphSearchTraveledPath<V, E>>> ob = this.openBranches.getWriteable();
            for (Map.Entry e : selectedExtends) {
                GraphSearchTraveledPath<V, E> ex = this.createExtend(e);
                this.tryRemoveClosedBranch((GraphSearchTraveledPath)e.getKey());
                ob.add(ex);
            }
            this.visitAtPoint(false, GraphSearchPhase.EXTEND_SEARCH_FRONT);
            this.visitAtPoint(true, GraphSearchPhase.CHECK_FOR_SOLUTION);
            if (!this.examineSolutions()) continue;
            this.visitAtPoint(true, GraphSearchPhase.EXIT_BY_CONTROLLER);
            return;
        }
    }

    protected void publishToExtend(List<Map.Entry<GraphSearchTraveledPath<V, E>, Map.Entry<E, V>>> possibleExtends, Collection<Map.Entry<GraphSearchTraveledPath<V, E>, Map.Entry<E, V>>> selectedExtends, Collection<Map.Entry<GraphSearchTraveledPath<V, E>, Map.Entry<E, V>>> closedExtends) {
        if (null != this.visitor) {
            this.visitor.publishExtendSelection(this, possibleExtends, Collections.unmodifiableCollection(selectedExtends), Collections.unmodifiableCollection(closedExtends));
        }
    }

    protected void publishToMerge(List<Map.Entry<GraphSearchTraveledPath<V, E>, GraphSearchTraveledPath<V, E>>> lst) {
        if (null != this.visitor) {
            this.visitor.publishMergeSelection(this, Collections.unmodifiableList(lst));
        }
    }

    protected void visitAtPoint(boolean before, GraphSearchPhase phase) {
        if (null != this.visitor) {
            if (before) {
                this.visitor.before(this, phase);
            } else {
                this.visitor.after(this, phase);
            }
        }
    }

    @MayNotNull
    protected GraphSearchTraveledPath<V, E> createExtend(Map.Entry<GraphSearchTraveledPath<V, E>, Map.Entry<E, V>> ex) {
        return ex.getKey().fork(this.subject, ex.getValue());
    }

    protected void executeMerges(List<Map.Entry<GraphSearchTraveledPath<V, E>, GraphSearchTraveledPath<V, E>>> mergePairs) {
        Collection<GraphSearchTraveledPath<V, GraphSearchTraveledPath<V, E>>> ob = this.openBranches.getWriteable();
        for (Map.Entry<GraphSearchTraveledPath<V, E>, GraphSearchTraveledPath<V, E>> p : mergePairs) {
            GraphSearchTraveledPath<V, E> m1 = p.getKey();
            GraphSearchTraveledPath<V, E> m2 = p.getValue();
            GraphSearchTraveledPath<V, E> add = m1.merge(m2);
            ob.add(add);
            this.tryRemoveClosedBranch(m1);
            this.tryRemoveClosedBranch(m2);
        }
    }

    protected void tryRemoveClosedBranch(GraphSearchTraveledPath<V, E> b) {
        if (!b.hasUndiscoveredBranch(this.subject)) {
            this.openBranches.getWriteable().remove(b);
            this.closedBranches.getWriteable().add(b);
        }
    }

    protected void tryRemoveClosedBranchBulk(Collection<GraphSearchTraveledPath<V, E>> bs) {
        HashSet<GraphSearchTraveledPath<V, E>> set = new HashSet<GraphSearchTraveledPath<V, E>>();
        for (GraphSearchTraveledPath<V, E> b : bs) {
            if (b.hasUndiscoveredBranch(this.subject)) continue;
            set.add(b);
        }
        if (!set.isEmpty()) {
            this.openBranches.getWriteable().removeAll(set);
            this.closedBranches.getWriteable().addAll(set);
        }
    }

    protected void fillPossibleExtends(List<Map.Entry<GraphSearchTraveledPath<V, E>, Map.Entry<E, V>>> possibleExtends) {
        ArrayList v = new ArrayList();
        for (GraphSearchTraveledPath ob : this.openBranches.getReadOnly()) {
            v.clear();
            ob.fillOpenVertexes(this, v);
            for (Map.Entry e : v) {
                KeyVal add = new KeyVal(ob, e);
                possibleExtends.add(add);
            }
        }
    }

    protected boolean examineSolutions() {
        List<V> s = this.startVertexes.getReadOnly();
        List<V> d = this.destinationVertexes.getReadOnly();
        if (s.size() > 0 && d.size() > 0) {
            ArrayList<GraphSearchTraveledPath<V, E>> examinedSolutions = new ArrayList<GraphSearchTraveledPath<V, E>>();
            for (GraphSearchTraveledPath<V, E> k : this.openBranches.getReadOnly()) {
                if (!s.contains(k.getFirstVertex()) || !d.contains(k.getLastVertex())) continue;
                examinedSolutions.add(k);
            }
            if (!examinedSolutions.isEmpty()) {
                Collection<GraphSearchTraveledPath<V, E>> ob = this.openBranches.getWriteable();
                Collection<GraphSearchTraveledPath<V, GraphSearchTraveledPath>> sols = this.solutions.getWriteable();
                for (GraphSearchTraveledPath graphSearchTraveledPath : examinedSolutions) {
                    ob.remove(graphSearchTraveledPath);
                    sols.add(graphSearchTraveledPath);
                    if (null == this.visitor) continue;
                    this.visitor.solutionFound(graphSearchTraveledPath);
                }
            }
        }
        return !this.controller.needContinueSearch(this);
    }

    public V getFirstDestination() {
        return this.destinationVertexes.getReadOnly().get(0);
    }

    public int getIterationCount() {
        return this.iteration;
    }

    @Override
    public Map<String, Object> getExtraDataMap() {
        if (null == this.extraData) {
            this.extraData = new SmallMap<String, Object>();
        }
        return this.extraData;
    }

    @Deprecated
    public void resetSearchHistory() {
        this.openBranches.getWriteable().clear();
        this.closedBranches.getWriteable().clear();
        this.solutions.getWriteable().clear();
        this.startVertexes.getWriteable().clear();
        this.destinationVertexes.getWriteable().clear();
        this.searchStarted = false;
        this.noMoreSolution = false;
    }

    @Deprecated
    public void gc() {
        Set set = GraphSearcher.createSet();
        for (GraphSearchTraveledPath<V, E> cb : this.closedBranches.getReadOnly()) {
            if (!cb.hasFork() || cb.hasUndiscoveredBranch(this.subject)) continue;
            set.add(cb);
        }
        this.closedBranches.getWriteable().removeAll(set);
        System.out.println("GC: " + set.size() + " closed branch removed");
    }
}

